/*
 * Decompiled with CFR 0.152.
 */
package weblogic.timers.internal;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import weblogic.kernel.QueueFullException;
import weblogic.timers.CancelTimerListener;
import weblogic.timers.RuntimeDomainSelector;
import weblogic.timers.ScheduleExpression;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.timers.internal.CalendarTimerImpl;
import weblogic.timers.internal.ScheduleExpressionWrapper;
import weblogic.timers.internal.TimerFactory;
import weblogic.timers.internal.TimerImpl;
import weblogic.timers.internal.TimerManagerFactoryImpl;
import weblogic.timers.internal.TimerSet;
import weblogic.timers.internal.TimerThread;
import weblogic.utils.UnsyncCircularQueue;
import weblogic.work.WorkManager;

public class TimerManagerImpl
implements TimerManager {
    private static final int STOPPING = 1;
    private static final int STOPPED = 2;
    private static final int SUSPENDING = 3;
    private static final int SUSPENDED = 4;
    private static final int RUNNING = 5;
    private static ConcurrentHashMap<String, Map<String, TimerManagerImpl>> timerManagers = new ConcurrentHashMap();
    private TimerThread timerThread;
    private String name;
    private final Executor executor;
    private final String domainId;
    private int executing;
    private volatile int state;
    private final AtomicLong counter;
    private CountDownLatch listenersCompletionLatch;
    private volatile TimerSet timerSet;
    private final TimerFactory timerFactory;
    protected int idx = -1;
    private static final TimerSet STOPPED_STATE_TIMERSET = new TimerSet(){

        @Override
        public boolean add(TimerImpl t) {
            t.cleanup();
            throw new IllegalStateException();
        }

        @Override
        public boolean remove(TimerImpl t) {
            return false;
        }

        @Override
        public boolean update(TimerImpl t) {
            return false;
        }

        @Override
        public TimerImpl[] getNotAfter(long timeout) {
            return new TimerImpl[0];
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };

    TimerManagerImpl(TimerThread timerThread, String name, Executor executor, TimerFactory timerFactory) {
        this.timerThread = timerThread;
        this.name = name;
        this.executor = executor;
        this.domainId = RuntimeDomainSelector.getDomain();
        this.counter = new AtomicLong(0L);
        this.timerSet = new TimerSet();
        this.timerFactory = timerFactory;
        this.state = 5;
    }

    static void clearAll() {
        timerManagers = new ConcurrentHashMap();
    }

    @Override
    public void stop() {
        try {
            this.waitForStop(0L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isStopped() {
        return this.state == 2 || this.timerThread.isStopped();
    }

    @Override
    public boolean isStopping() {
        return this.state == 1 || this.isStopped();
    }

    @Override
    public boolean isSuspended() {
        return this.state == 4;
    }

    @Override
    public boolean isSuspending() {
        return this.state == 3 || this.isSuspended();
    }

    @Override
    public void suspend() {
        try {
            this.waitForSuspend(0L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForSuspend(long timeout_ms) throws InterruptedException, IllegalStateException, IllegalArgumentException {
        TimerManagerImpl timerManagerImpl = this;
        synchronized (timerManagerImpl) {
            if (this.state <= 2) {
                throw new IllegalStateException("Cannot suspend a TimerManager that is in STOPPED state");
            }
            if (this.state == 4) {
                return true;
            }
            this.state = 3;
            this.timerThread.unregister(this);
            if (this.listenersCompletionLatch == null) {
                this.listenersCompletionLatch = new CountDownLatch(this.executing);
            }
        }
        if (timeout_ms == 0L) {
            this.listenersCompletionLatch.await();
        } else {
            boolean completed = this.listenersCompletionLatch.await(timeout_ms, TimeUnit.MILLISECONDS);
            if (!completed) {
                return false;
            }
        }
        TimerManagerImpl timerManagerImpl2 = this;
        synchronized (timerManagerImpl2) {
            if (this.state != 3) {
                throw new IllegalStateException("TimerManager state changed to " + this.state + " while suspending. waitForSuspend is aborted.");
            }
            this.state = 4;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForStop(long timeout_ms) throws InterruptedException, IllegalArgumentException {
        TimerImpl[] timerImplArray = this;
        synchronized (this) {
            if (this.state == 2) {
                // ** MonitorExit[var4_2] (shouldn't be in output)
                return true;
            }
            this.state = 1;
            TimerSet prev = this.timerSet;
            this.timerSet = STOPPED_STATE_TIMERSET;
            this.timerThread.unregister((TimerManagerImpl)this);
            TimerImpl[] timers = prev.getNotAfter(Long.MAX_VALUE);
            prev.clear();
            this.executing += timers.length;
            if (this.listenersCompletionLatch == null) {
                this.listenersCompletionLatch = new CountDownLatch(this.executing);
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            for (TimerImpl timer : timers) {
                timer.setStopped();
                try {
                    this.executor.execute(timer);
                }
                catch (QueueFullException qfe) {
                    this.complete(timer);
                }
                catch (UnsyncCircularQueue.FullQueueException fqe) {
                    this.complete(timer);
                }
            }
            try {
                int n;
                if (timeout_ms == 0L) {
                    this.listenersCompletionLatch.await();
                } else {
                    boolean completed = this.listenersCompletionLatch.await(timeout_ms, TimeUnit.MILLISECONDS);
                    if (!completed) {
                        n = 0;
                        return n != 0;
                    }
                }
                TimerImpl[] timerImplArray2 = this;
                synchronized (this) {
                    assert (this.state == 1 || this.state == 2);
                    this.state = 2;
                    n = 1;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return n != 0;
                }
            }
            finally {
                Map<String, TimerManagerImpl> timerManagers;
                Map<String, TimerManagerImpl> map = timerManagers = TimerManagerImpl.getTimerManagersMapForDomain(this.domainId);
                synchronized (map) {
                    timerManagers.remove(this.name);
                }
            }
        }
    }

    @Override
    public synchronized void resume() {
        if (this.state == 5) {
            return;
        }
        if (this.state <= 2) {
            throw new IllegalStateException("Cannot resume a TimerManager that is in STOPPED state");
        }
        this.state = 5;
        if (!this.timerSet.isEmpty()) {
            this.timerThread.register(this);
            this.ping();
        }
        if (this.listenersCompletionLatch != null) {
            for (long l = this.listenersCompletionLatch.getCount(); l > 0L; --l) {
                this.listenersCompletionLatch.countDown();
            }
            this.listenersCompletionLatch = null;
        }
    }

    @Override
    public Timer schedule(TimerListener listener, long delay) {
        return this.schedule(listener, delay, 0L);
    }

    @Override
    public Timer schedule(TimerListener listener, Date time) {
        return this.schedule(listener, time, 0L);
    }

    @Override
    public Timer schedule(TimerListener listener, long delay, long period) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Delay is negative.");
        }
        if (period < 0L) {
            throw new IllegalArgumentException("Period is negative.");
        }
        if (this.state == 2) {
            throw new IllegalStateException("TimerManager is in STOPPED state");
        }
        return this.add(this.timerFactory.createTimerImpl(this, listener, this.normalizeTimeout(delay), -period));
    }

    long normalizeTimeout(long positiveDelay) {
        long now = System.currentTimeMillis();
        long normal = now + positiveDelay;
        if (normal < now) {
            return 9223372036854773807L;
        }
        return normal;
    }

    @Override
    public Timer schedule(TimerListener listener, Date firstTime, long period) {
        if (period < 0L) {
            throw new IllegalArgumentException("Period is negative.");
        }
        if (this.state == 2) {
            throw new IllegalStateException("TimerManager is in STOPPED state");
        }
        return this.add(this.timerFactory.createTimerImpl(this, listener, firstTime.getTime(), -period));
    }

    @Override
    public Timer schedule(TimerListener listener, ScheduleExpression schedule) {
        if (this.state == 2) {
            throw new IllegalStateException("TimerManager is in STOPPED state");
        }
        ScheduleExpressionWrapper scheduleWrapper = ScheduleExpressionWrapper.create(schedule);
        CalendarTimerImpl newTimer = this.timerFactory.createCalendarTimerImpl(this, listener, scheduleWrapper);
        if (newTimer.isExpired() && (schedule.getFirstTimeout() == null || schedule.getFirstTimeout().getTime() != newTimer.getTimeout())) {
            return newTimer;
        }
        return this.add(newTimer);
    }

    @Override
    public Timer scheduleAtFixedRate(TimerListener listener, Date firstTime, long period) {
        if (period < 0L) {
            throw new IllegalArgumentException("Period is negative.");
        }
        return this.add(this.timerFactory.createTimerImpl(this, listener, firstTime.getTime(), period));
    }

    @Override
    public Timer scheduleAtFixedRate(TimerListener listener, long delay, long period) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Delay is negative.");
        }
        if (period < 0L) {
            throw new IllegalArgumentException("Period is negative.");
        }
        return this.add(this.timerFactory.createTimerImpl(this, listener, this.normalizeTimeout(delay), period));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancel(TimerImpl timer) {
        if (timer.isCancelled()) {
            return false;
        }
        timer.setCancelled(true);
        TimerManagerImpl timerManagerImpl = this;
        synchronized (timerManagerImpl) {
            if (!this.timerSet.remove(timer)) {
                return false;
            }
            if (timer.running) {
                return timer.getPeriod() != 0L || timer.isCalendarTimer();
                {
                }
            }
            ++this.executing;
        }
        TimerListener listener = timer.getListener();
        if (listener instanceof CancelTimerListener) {
            try {
                this.executor.execute(timer);
            }
            catch (UnsyncCircularQueue.FullQueueException fqe) {
                this.complete(timer);
            }
        } else {
            this.complete(timer);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer add(TimerImpl timer) {
        timer.setCounter(this.getNextCounter());
        if (this.timerSet.add(timer) && this.state == 5) {
            TimerManagerImpl timerManagerImpl = this;
            synchronized (timerManagerImpl) {
                if (this.state == 5 && this.idx == -1) {
                    this.timerThread.register(this);
                }
            }
            this.ping();
        }
        return timer;
    }

    private void update(TimerImpl timer) {
        timer.setCounter(this.getNextCounter());
        if (this.timerSet.update(timer)) {
            this.ping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(TimerImpl timer) {
        timer.cleanup();
        this.timerSet.remove(timer);
        if (this.timerSet.isEmpty() && this.idx != -1) {
            TimerManagerImpl timerManagerImpl = this;
            synchronized (timerManagerImpl) {
                if (this.timerSet.isEmpty() && this.idx != -1) {
                    this.timerThread.unregister(this);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute() {
        TimerImpl[] timerImplArray = this;
        synchronized (this) {
            if (this.isSuspending()) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            TimerImpl[] timers = this.timerSet.getNotAfter(System.currentTimeMillis());
            this.executing += timers.length;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (TimerImpl timer : timers) {
                if (this.isStopped()) {
                    timer.setStopped();
                }
                try {
                    this.executor.execute(timer);
                }
                catch (QueueFullException qfe) {
                    this.complete(timer);
                }
                catch (UnsyncCircularQueue.FullQueueException fqe) {
                    this.complete(timer);
                }
            }
            super.ping();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void complete(TimerImpl timer) {
        TimerManagerImpl timerManagerImpl = this;
        synchronized (timerManagerImpl) {
            --this.executing;
            if (this.state != 5 && this.listenersCompletionLatch != null) {
                this.listenersCompletionLatch.countDown();
            }
        }
        if (timer.isCancelled()) {
            this.remove(timer);
            return;
        }
        if (!timer.incrementTimeout()) {
            this.remove(timer);
            return;
        }
        if (this.isStopping()) {
            this.remove(timer);
        } else {
            this.update(timer);
        }
    }

    private void ping() {
        long wakeup = this.timerSet.peakMin();
        if (wakeup > 0L) {
            this.timerThread.ping(wakeup);
        }
    }

    long earliestWakeup() {
        return this.timerSet.peakMin();
    }

    Executor getExecutor() {
        return this.executor;
    }

    public String getExecutorName() {
        if (this.executor instanceof WorkManager) {
            return ((WorkManager)((Object)this.executor)).getName();
        }
        return "" + this.executor;
    }

    private long getNextCounter() {
        return this.counter.incrementAndGet();
    }

    public String getName() {
        return this.name;
    }

    TimerImpl[] getTimers() {
        return this.timerSet.getAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimerManagerImpl getTimerManager(String name, Executor exec, TimerFactory timerFactory) {
        Map<String, TimerManagerImpl> timerManagers;
        if (exec == null) {
            throw new IllegalArgumentException("executor == null");
        }
        String domainId = RuntimeDomainSelector.getDomain();
        Map<String, TimerManagerImpl> map = timerManagers = TimerManagerImpl.getTimerManagersMapForDomain(domainId);
        synchronized (map) {
            TimerManagerImpl timerManager = timerManagers.get(name);
            if (timerManager != null) {
                if (timerManager.getExecutor() == null) {
                    return timerManager;
                }
                if (exec.equals(timerManager.getExecutor())) {
                    return timerManager;
                }
                throw new IllegalArgumentException("Existing timer manager has different work manager.\nTimerManager requested: " + name + " in domain: " + domainId + "\nTimerManager  obtained: " + timerManager.getName() + " in domain: " + timerManager.domainId + "\nWorkManager  requested: " + exec + "\nWorkManager   obtained: " + timerManager.getExecutor());
            }
            timerManager = new TimerManagerImpl(TimerThread.getTimerThread(), name, exec, timerFactory);
            timerManagers.put(name, timerManager);
            return timerManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void stopAllTimers() {
        Iterator<Map<String, TimerManagerImpl>> iterator = timerManagers.values().iterator();
        block2: while (iterator.hasNext()) {
            TimerManagerImpl[] byDomainManagers;
            TimerManagerImpl[] timerManagerImplArray = byDomainManagers = iterator.next();
            // MONITORENTER : byDomainManagers
            TimerManagerImpl[] managers = byDomainManagers.values().toArray(new TimerManagerImpl[byDomainManagers.size()]);
            // MONITOREXIT : timerManagerImplArray
            timerManagerImplArray = managers;
            int n = timerManagerImplArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block2;
                TimerManagerImpl timerManager = timerManagerImplArray[n2];
                timerManager.stop();
                ++n2;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TimerManagerImpl[] getAllTimerManagers() {
        Map<String, TimerManagerImpl> timerManagers;
        Map<String, TimerManagerImpl> map = timerManagers = TimerManagerImpl.getTimerManagersMapForDomain(RuntimeDomainSelector.getDomain());
        synchronized (map) {
            return timerManagers.values().toArray(new TimerManagerImpl[timerManagers.size()]);
        }
    }

    private static Map<String, TimerManagerImpl> getTimerManagersMapForDomain(String domainId) {
        Map tmMap = timerManagers.get(domainId);
        if (tmMap != null) {
            return tmMap;
        }
        HashMap<String, TimerManagerImpl> newTmMap = new HashMap<String, TimerManagerImpl>();
        tmMap = timerManagers.putIfAbsent(domainId, newTmMap);
        if (tmMap == null) {
            return newTmMap;
        }
        return tmMap;
    }

    public static void cleanupForPartition() {
        TimerManagerFactory timerManagerFactory;
        String domainId = RuntimeDomainSelector.getDomain();
        Map<String, TimerManagerImpl> tmMap = timerManagers.remove(domainId);
        if (tmMap != null) {
            for (TimerManagerImpl mgrs : tmMap.values()) {
                mgrs.stop();
            }
        }
        if ((timerManagerFactory = TimerManagerFactory.getTimerManagerFactory()) instanceof TimerManagerFactoryImpl) {
            ((TimerManagerFactoryImpl)timerManagerFactory).cleanupForPartition();
        }
    }

    public String toString() {
        return "TimerManager '" + this.getName() + "' that uses WorkManager '" + this.executor + "'";
    }

    public static interface Executor {
        public void execute(Runnable var1);

        public boolean equals(Executor var1);
    }
}

