/*
 * Decompiled with CFR 0.152.
 */
package weblogic.timers.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import weblogic.kernel.KernelStatus;
import weblogic.timers.internal.TimerManagerImpl;

class TimerThread {
    static final int STARTED = 0;
    static final int STOPPED = 1;
    static final int HALTED = 2;
    private static TimerThread singleton;
    private Thread thread;
    private volatile int state;
    private final ArrayList<TimerManagerImpl> managerList;
    private final AtomicLong earliestWakeup;
    private Object waitLock = new Object();
    private long notifyCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerThread() {
        Class<TimerThread> clazz = TimerThread.class;
        synchronized (TimerThread.class) {
            if (singleton != null) {
                throw new IllegalStateException();
            }
            if (!KernelStatus.isInitialized()) {
                String KERNEL_CLAZZ_NAME = "weblogic.kernel.Kernel";
                try {
                    Class.forName(KERNEL_CLAZZ_NAME, true, ClassLoader.getSystemClassLoader());
                    throw new AssertionError((Object)"Kernel needs to be initialized before starting TimerThread.");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
            this.managerList = new ArrayList();
            this.earliestWakeup = new AtomicLong(-1L);
            this.startThread();
            singleton = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void startThread() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWait(long waitMillis, long lastNotifyCount) {
        Object object = this.waitLock;
        synchronized (object) {
            if (this.notifyCount != lastNotifyCount) {
                return;
            }
            try {
                this.waitLock.wait(waitMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotify() {
        ++this.notifyCount;
        Object object = this.waitLock;
        synchronized (object) {
            this.waitLock.notify();
        }
    }

    private long getNotifyCount() {
        return this.notifyCount;
    }

    synchronized void stop() {
        this.state = 1;
    }

    synchronized void start() {
        this.state = 0;
        this.doNotify();
    }

    synchronized void halt() {
        this.state = 2;
        this.doNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(TimerManagerImpl manager) {
        ArrayList<TimerManagerImpl> arrayList = this.managerList;
        synchronized (arrayList) {
            manager.idx = this.managerList.size();
            this.managerList.add(manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister(TimerManagerImpl manager) {
        ArrayList<TimerManagerImpl> arrayList = this.managerList;
        synchronized (arrayList) {
            if (manager.idx == -1) {
                return;
            }
            TimerManagerImpl last = this.managerList.remove(this.managerList.size() - 1);
            if (manager != last) {
                last.idx = manager.idx;
                this.managerList.set(last.idx, last);
            }
            manager.idx = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ping(long firstTimeout) {
        long wakeup;
        do {
            if ((wakeup = this.earliestWakeup.get()) <= 0L || firstTimeout < wakeup) continue;
            return;
        } while (!this.earliestWakeup.compareAndSet(wakeup, firstTimeout));
        TimerThread timerThread = this;
        synchronized (timerThread) {
            if (this.state == 0) {
                this.doNotify();
            }
        }
    }

    boolean isStarted() {
        return this.state == 0;
    }

    boolean isStopped() {
        return this.state == 1;
    }

    boolean isHalted() {
        return this.state == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TimerThread getTimerThread() {
        Class<TimerThread> clazz = TimerThread.class;
        synchronized (TimerThread.class) {
            if (singleton != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return singleton;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return new TimerThread();
        }
    }

    class Thread
    extends java.lang.Thread {
        private TimerThread timerThread;

        public Thread(TimerThread timerThread) {
            this.timerThread = timerThread;
            this.setName("weblogic.timers.TimerThread");
            this.setPriority(9);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long waitMillis = -1L;
            long lastNotifyCount = 0L;
            ArrayList execManagers = new ArrayList();
            while (true) {
                if (waitMillis >= 0L) {
                    this.timerThread.doWait(waitMillis, lastNotifyCount);
                    waitMillis = -1L;
                }
                long currentTime = System.currentTimeMillis();
                boolean isHalted = false;
                Object object = this.timerThread;
                synchronized (object) {
                    lastNotifyCount = this.timerThread.getNotifyCount();
                    if (this.timerThread.isStopped()) {
                        waitMillis = 0L;
                        TimerThread.this.earliestWakeup.set(-1L);
                        continue;
                    }
                    isHalted = this.timerThread.isHalted();
                }
                object = TimerThread.this.managerList;
                synchronized (object) {
                    if (isHalted) {
                        if (TimerThread.this.managerList.isEmpty()) {
                            break;
                        }
                        Iterator iter = TimerThread.this.managerList.iterator();
                        while (iter.hasNext()) {
                            execManagers.add(iter.next());
                        }
                    } else {
                        if (TimerThread.this.managerList.isEmpty()) {
                            waitMillis = 0L;
                            TimerThread.this.earliestWakeup.set(-1L);
                            continue;
                        }
                        long wakeup = TimerThread.this.earliestWakeup.get();
                        if (wakeup > currentTime) {
                            waitMillis = wakeup - currentTime;
                            continue;
                        }
                        long min = -1L;
                        for (TimerManagerImpl manager : TimerThread.this.managerList) {
                            long firstTimeout = manager.earliestWakeup();
                            if (firstTimeout < 0L) continue;
                            if (firstTimeout <= currentTime) {
                                execManagers.add(manager);
                                continue;
                            }
                            if (min >= 0L && min <= firstTimeout) continue;
                            min = firstTimeout;
                        }
                        if (!TimerThread.this.earliestWakeup.compareAndSet(wakeup, min)) {
                            // empty if block
                        }
                    }
                }
                for (TimerManagerImpl manager : execManagers) {
                    if (isHalted) {
                        if (manager.isStopped()) continue;
                        manager.stop();
                        continue;
                    }
                    manager.execute();
                }
                execManagers.clear();
                if (isHalted) {
                    waitMillis = -1L;
                    TimerThread.this.earliestWakeup.set(-1L);
                    continue;
                }
                long wakeup = TimerThread.this.earliestWakeup.get();
                if (wakeup < 0L) {
                    waitMillis = 0L;
                    continue;
                }
                long now = System.currentTimeMillis();
                waitMillis = wakeup > now ? wakeup - now : -1L;
            }
        }
    }
}

