/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction;

import javax.transaction.xa.Xid;
import weblogic.transaction.internal.XidImpl;

public class XIDFactory {
    private static boolean set = false;
    private static int id = 48801;

    public static final Xid createXID(byte[] aGlobalTransactionId, byte[] aBranchQualifier) {
        if (aBranchQualifier == null || aBranchQualifier.length == 0) {
            return new XidImpl(aGlobalTransactionId);
        }
        return new XidImpl(aGlobalTransactionId, aBranchQualifier);
    }

    public static Xid createXID(int aFormatId, byte[] aGlobalTransactionId, byte[] aBranchQualifier) {
        return new XidImpl(aFormatId, aGlobalTransactionId, aBranchQualifier);
    }

    public static Xid createXID(String branch) {
        if (branch == null || branch.equals("")) {
            throw new AssertionError((Object)"Branch should not be empty.");
        }
        XidImpl tmpXid = XidImpl.create();
        return new XidImpl(tmpXid.getFormatId(), tmpXid.getGlobalTransactionId(), tmpXid.getTruncatedBranchQualifier(branch));
    }

    public static String xidToString(Xid xid, boolean includeBranchQualifier) {
        if (xid instanceof XidImpl) {
            return ((XidImpl)xid).toString(includeBranchQualifier);
        }
        return xid.toString();
    }

    public static int getFormatId() {
        if (!set) {
            set = true;
            try {
                Class.forName("weblogic.transaction.ClientTxHelper");
                id = 48801;
            }
            catch (Exception ignore) {
                id = 781006;
            }
        }
        return id;
    }
}

