/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import jakarta.transaction.SystemException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.cluster.ThreadPreferredHost;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.Interceptor;
import weblogic.rmi.spi.InterceptorManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.transaction.ChannelInterface;
import weblogic.transaction.Transaction;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.internal.Channel;
import weblogic.transaction.internal.ClientTransactionManagerImpl;
import weblogic.transaction.internal.CoordinatorDescriptor;
import weblogic.transaction.internal.CoordinatorDescriptorManager;
import weblogic.transaction.internal.JTARecoveryRuntime;
import weblogic.transaction.internal.PlatformHelper;
import weblogic.transaction.internal.PlatformHelperCommon;
import weblogic.transaction.internal.PropagationContext;
import weblogic.transaction.internal.TransactionHelperImpl;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.transaction.internal.TransactionManagerImpl;

public class ClientPlatformHelperImpl
extends PlatformHelperCommon {
    private static final String THICK_SUBJECT_MANAGER = "weblogic.security.service.SubjectManagerImpl";
    private static final String IIOPCLIENT_SUBJECT_MANAGER = "weblogic.corba.client.security.SubjectManagerImpl";
    private static final String T3CLIENT_SUBJECT_MANAGER = "weblogic.security.subject.SubjectManager";
    private static boolean initialized;
    private static final AbstractSubject kernelID;

    private static final AbstractSubject getKernelIdentity() {
        try {
            ClientPlatformHelperImpl.ensureSubjectManagerInitialized();
            return (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
        }
        catch (AccessControlException ace) {
            return null;
        }
    }

    public static void ensureSubjectManagerInitialized() {
        Method ensureInitializedMethod;
        Class<?> subjectManagerImpl;
        block13: {
            if (initialized) {
                return;
            }
            try {
                subjectManagerImpl = Class.forName(THICK_SUBJECT_MANAGER);
            }
            catch (ClassNotFoundException c) {
                try {
                    subjectManagerImpl = Class.forName(IIOPCLIENT_SUBJECT_MANAGER);
                }
                catch (ClassNotFoundException d) {
                    try {
                        subjectManagerImpl = Class.forName(T3CLIENT_SUBJECT_MANAGER);
                    }
                    catch (ClassNotFoundException e) {
                        if (SubjectManager.getSubjectManager() != null) {
                            subjectManagerImpl = SubjectManager.getSubjectManager().getClass();
                            break block13;
                        }
                        throw new AssertionError((Object)e);
                    }
                }
            }
        }
        try {
            ensureInitializedMethod = subjectManagerImpl.getMethod("ensureInitialized", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        try {
            ensureInitializedMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        initialized = true;
    }

    @Override
    public CoordinatorDescriptor findAdminChannel(Object server, Object channel) {
        return null;
    }

    @Override
    public ChannelInterface findAdminChannel(Object server) {
        return null;
    }

    @Override
    public boolean isJNDIEnabled() {
        return true;
    }

    @Override
    public String getRootName() {
        return "weblogic.transaction";
    }

    @Override
    public Context getInitialContext(String serverURL) throws NamingException {
        return this.getInitialContext(serverURL, true);
    }

    @Override
    public Context getInitialContext(String serverURL, boolean replicateBindings) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (serverURL != null) {
            env.put("java.naming.provider.url", serverURL);
        }
        env.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        env.put("weblogic.jndi.createUnderSharable", "true");
        return new InitialContext(env);
    }

    @Override
    public boolean extendCoordinatorURL(String aCoURL) {
        return false;
    }

    private static final String getServerName(String aCoUrl) {
        int plusPos = aCoUrl.indexOf(43);
        return plusPos == -1 ? null : aCoUrl.substring(0, plusPos);
    }

    @Override
    public String getDomainName(String aCoUrl) {
        int plusPos1 = aCoUrl.indexOf(43);
        if (plusPos1 == -1) {
            return null;
        }
        int plusPos2 = aCoUrl.indexOf(43, plusPos1 + 1);
        if (plusPos2 == -1) {
            return null;
        }
        int plusPos3 = aCoUrl.indexOf(43, plusPos2 + 1);
        if (plusPos3 == -1) {
            return null;
        }
        return aCoUrl.substring(plusPos2 + 1, plusPos3);
    }

    private static final String getProtocol(String aCoUrl) {
        int plusPos1 = aCoUrl.indexOf(43);
        if (plusPos1 == -1) {
            return null;
        }
        int plusPos2 = aCoUrl.indexOf(43, plusPos1 + 1);
        if (plusPos2 == -1) {
            return null;
        }
        int plusPos3 = aCoUrl.indexOf(43, plusPos2 + 1);
        if (plusPos3 == -1) {
            return null;
        }
        int plusPos4 = aCoUrl.indexOf(43, plusPos3 + 1);
        if (plusPos4 == -1) {
            return null;
        }
        return aCoUrl.substring(plusPos3 + 1, plusPos4);
    }

    private static final String getExtendedProtocol(String aCoUrl) {
        int plusPos1 = aCoUrl.indexOf(43);
        if (plusPos1 == -1) {
            return null;
        }
        int plusPos2 = aCoUrl.indexOf(43, plusPos1 + 1);
        if (plusPos2 == -1) {
            return null;
        }
        int plusPos3 = aCoUrl.indexOf(43, plusPos2 + 1);
        if (plusPos3 == -1) {
            return null;
        }
        int plusPos4 = aCoUrl.indexOf(43, plusPos3 + 1);
        if (plusPos4 == -1) {
            return null;
        }
        int plusPos5 = aCoUrl.indexOf(43, plusPos4 + 1);
        if (plusPos5 == -1) {
            return null;
        }
        return aCoUrl.substring(plusPos4 + 1, plusPos5);
    }

    private static final String getHostPort(String aCoUrl) {
        int plusPos1 = aCoUrl.indexOf(43);
        int plusPos2 = aCoUrl.indexOf(43, plusPos1 + 1);
        if (plusPos2 > plusPos1) {
            return aCoUrl.substring(plusPos1 + 1, plusPos2);
        }
        return aCoUrl.substring(plusPos1 + 1);
    }

    private static final String getHost(String aCoUrl) {
        String hostPort = ClientPlatformHelperImpl.getHostPort(aCoUrl);
        int colonPos = hostPort.indexOf(58);
        if (colonPos == -1) {
            return null;
        }
        return hostPort.substring(0, colonPos);
    }

    private static final String getAdminProtocol(String aCoUrl) {
        int colonPos = aCoUrl.indexOf(58);
        if (colonPos == -1) {
            return null;
        }
        return aCoUrl.substring(0, colonPos);
    }

    @Override
    public String getAdminPort(String aCoUrl) {
        int colonPos1 = aCoUrl.indexOf(58);
        if (colonPos1 == -1) {
            return null;
        }
        int colonPos2 = aCoUrl.indexOf(58, colonPos1 + 1);
        return aCoUrl.substring(colonPos2 + 1);
    }

    @Override
    public boolean openPrimaryStore(boolean isRetry) {
        throw new AssertionError((Object)"It is not supported");
    }

    @Override
    public void setPrimaryStore(Object store) {
    }

    @Override
    public Object getPrimaryStore() {
        return null;
    }

    @Override
    public Object getStore(String serverName, String arg1) throws Exception {
        throw new AssertionError((Object)"It is not supported");
    }

    @Override
    public void closeStore(Object store) throws Exception {
    }

    @Override
    public int getQOSAdmin() {
        return 0;
    }

    @Override
    public boolean isLocalAdminChannelEnabled() {
        return false;
    }

    @Override
    public String findLocalAdminChannelURL(String aCoURL) {
        return null;
    }

    @Override
    public String findLocalSSLURL(String aCoURL) {
        return null;
    }

    @Override
    public boolean isSSLURL(String aCoURL, boolean secureActionURLFormat) {
        return false;
    }

    @Override
    public boolean isSSLURL(String aCoURL) {
        return ClientPlatformHelperImpl.getProtocol(aCoURL).equalsIgnoreCase("t3s") || ClientPlatformHelperImpl.getProtocol(aCoURL).equalsIgnoreCase("https");
    }

    @Override
    public boolean isCheckpointLLR() {
        return false;
    }

    @Override
    public void dumpTLOG(String tlogPath, String serverName, boolean delete) throws Exception {
    }

    @Override
    public void dumpJDBCTLOG(String serverName, String rootPath, String dataSourceName, String tableRef) throws Exception {
    }

    @Override
    public boolean isTransactionServiceRunning() {
        return false;
    }

    @Override
    public boolean isServerRunning() {
        return false;
    }

    @Override
    public String getDomainName() {
        return null;
    }

    @Override
    public void doTimerLifecycleHousekeeping() {
    }

    @Override
    public JTARecoveryRuntime getJTARecoveryRuntime(String serverName) {
        return null;
    }

    @Override
    public void scheduleFailBack(String serverName) {
    }

    @Override
    public Object createJTATransaction(TransactionImpl current) {
        return null;
    }

    @Override
    public TransactionHelper getTransactionHelper() {
        return new TransactionHelperImpl();
    }

    @Override
    public boolean sendRequest(Object endPoint) {
        EndPoint ep = (EndPoint)endPoint;
        TransactionImpl tx = (TransactionImpl)ClientPlatformHelperImpl.getTM().getTransaction();
        if (ep != null && ep.getHostID() instanceof ServerIdentity) {
            ServerIdentity id = (ServerIdentity)ep.getHostID();
            tx.setPreferredHost(id);
            return tx.setCoordinatorDescriptor(id, new Channel(ep.getRemoteChannel()));
        }
        return false;
    }

    static TransactionManagerImpl getTM() {
        return TransactionManagerImpl.getTransactionManager();
    }

    @Override
    public CoordinatorDescriptorManager getCoordinatorDescriptorManager() {
        return null;
    }

    @Override
    public void associateThreadPreferredHost(TransactionImpl tx, TransactionManagerImpl.TxThreadProperty txp) {
        if (tx != null) {
            if (!txp.preferredHostSetForTx) {
                txp.preTxPreferredHost = ThreadPreferredHost.get();
                txp.preferredHostSetForTx = true;
            }
            tx.setActiveThread(Thread.currentThread());
            ThreadPreferredHost.set((HostID)tx.getPreferredHost());
        } else if (txp.preferredHostSetForTx) {
            ThreadPreferredHost.set((HostID)txp.preTxPreferredHost);
            txp.preferredHostSetForTx = false;
            txp.preTxPreferredHost = null;
        }
    }

    @Override
    public Object getDisconnectMonitor() {
        return DisconnectMonitorListImpl.getDisconnectMonitor();
    }

    @Override
    public Object getRemoteSubject(String url) throws IOException, RemoteException {
        return null;
    }

    @Override
    public final boolean isInCluster() {
        return false;
    }

    Collection<String> getActiveServersInCluster() {
        return null;
    }

    @Override
    public CoordinatorDescriptor findServerInClusterByLocalJNDI(String resName, Collection exceptServerNames) {
        Collection<String> servers = this.getActiveServersInCluster();
        return null;
    }

    @Override
    public XAResource findXAResourceInClusterByRemoteJNDI(String resName, Collection exceptServerNames) {
        return null;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public void registerRMITransactionInterceptor(Object interceptor) {
        InterceptorManager.getManager().setTransactionInterceptor((Interceptor)interceptor);
    }

    @Override
    public boolean isCDSEnabled() {
        return false;
    }

    @Override
    public boolean isDomainExcluded(String domainName) {
        return false;
    }

    @Override
    public int getInteropMode() {
        return 0;
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public Object getCurrentSubject() {
        return SubjectManager.getSubjectManager().getCurrentSubject(kernelID);
    }

    @Override
    public void setSSLURLFromClientInfo(ClientTransactionManagerImpl clientTransactionManagerImpl, Context initialContext) {
        String sslPort = null;
        String sslProtocol = null;
        String sslURL = null;
        try {
            Hashtable<?, ?> env = initialContext.getEnvironment();
            sslURL = (String)env.get("java.naming.provider.url");
            if (sslURL != null) {
                sslProtocol = ClientPlatformHelperImpl.getAdminProtocol(sslURL);
            }
            if (sslProtocol != null && sslURL != null && (sslProtocol.equalsIgnoreCase("t3s") || sslProtocol.equalsIgnoreCase("https"))) {
                sslPort = this.getAdminPort(sslURL);
                clientTransactionManagerImpl.setCoordinatorURL(this.constructSSLURL(sslPort, sslProtocol, clientTransactionManagerImpl.getCoordinatorURL()));
            }
        }
        catch (Exception ae) {
            ae.printStackTrace();
        }
    }

    private String constructSSLURL(String sslPort, String sslProtocol, String aCoURL) {
        String serverName = ClientPlatformHelperImpl.getServerName(aCoURL);
        String domainName = this.getDomainName(aCoURL);
        String host = ClientPlatformHelperImpl.getHost(aCoURL);
        return serverName + "+" + host + ":" + sslPort + "+" + domainName + "+" + sslProtocol + "+";
    }

    @Override
    public Map<String, PlatformHelper.ClusterStatus> getClustersITMXAResources() throws XAException {
        throw new UnsupportedOperationException("getClustersITMXAResources call not valid on ClientPlatformHelperImpl");
    }

    @Override
    public void runAction(PrivilegedExceptionAction privilegedExceptionAction, String coServerURL, String s) throws Exception {
    }

    @Override
    public Object runSecureAction(Object kernelID, PrivilegedExceptionAction privilegedExceptionAction, String scServerURL, String s) throws Exception {
        return null;
    }

    @Override
    public Object runSecureAction(PrivilegedExceptionAction privilegedExceptionAction, String scServerURL, String s) throws Exception {
        return null;
    }

    @Override
    public XAResource refreshITMXAResourceReference(String serverName) throws XAException {
        throw new UnsupportedOperationException("refreshITMXAResourceReference call not valid on ClientPlatformHelperImpl");
    }

    @Override
    public void setServerResume() throws Exception {
    }

    @Override
    public void makeTransactionAware() {
    }

    @Override
    public boolean executeIfIdleOnParallelXAWorkManager(Runnable runnable, String parallelXADispatchPolicy) {
        return false;
    }

    @Override
    public void scheduleCheckStatusRequest(HashMap checkStatusTransactions, Runnable callback) {
    }

    @Override
    public void scheduleWork(Runnable otsER) {
    }

    @Override
    public void timerManagerSchedule(Object wlsTimer) {
    }

    @Override
    public void checkForSSLOnlyServerRetriction(PropagationContext aTxContext, Transaction tx) {
    }

    @Override
    public String getPartitionName() {
        return null;
    }

    @Override
    public String getPartitionName(boolean isAdmin) {
        return null;
    }

    @Override
    public ComponentInvocationContext getCurrentComponentInvocationContext() {
        return null;
    }

    @Override
    public int getTimeoutPartition() {
        return -1;
    }

    @Override
    public int getTimeoutPartition(String partitionName) {
        return -1;
    }

    @Override
    public String[] getDeterminersPartition() {
        return null;
    }

    @Override
    public String[] getDeterminersPartition(String partitionName) {
        return null;
    }

    @Override
    public int getForcedShutdownTimeoutSeconds() {
        return -1;
    }

    @Override
    public String getTransactionServiceHalt() {
        return null;
    }

    @Override
    public void setTransactionServiceHalt(String transactionServiceHalt) {
    }

    @Override
    public JTARecoveryRuntime manageCrossSiteJTARecoveryRuntime(String siteName, String serverName, boolean isRegister) {
        return null;
    }

    @Override
    public void passivateTransactionRecoveryService() {
    }

    @Override
    public void activateTransactionRecoveryService() throws SystemException {
    }

    static {
        kernelID = ClientPlatformHelperImpl.getKernelIdentity();
    }
}

