/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import java.net.URI;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.DisconnectMonitor;
import weblogic.rmi.extensions.DisconnectMonitorUnavailableException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.PeerExchangeTransaction;
import weblogic.transaction.internal.ClientTransactionManagerImpl;
import weblogic.transaction.internal.CoordinatorDescriptor;
import weblogic.transaction.internal.CoordinatorOneway;
import weblogic.transaction.internal.PlatformHelper;
import weblogic.transaction.internal.SecureAction;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.transaction.internal.TransactionManagerImpl;
import weblogic.transaction.internal.TxDebug;

public class CoordinatorFactory {
    private static int contactCoordinatorWaitSecondsMin = 3;
    private static int contactCoordinatorWaitSecondsMax = 20;
    public static final Map cachedStubs = new ConcurrentHashMap();
    private static final Map connectStartTime = new ConcurrentHashMap();
    private static final Map<String, String> cachedURLs = new HashMap<String, String>();
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    private static Context getInitialContext(String serverURL) throws NamingException {
        return PlatformHelper.getPlatformHelper().getInitialContext(serverURL);
    }

    public static CoordinatorOneway getCoordinator(CoordinatorDescriptor aCoDesc, PeerExchangeTransaction tx) {
        return (CoordinatorOneway)CoordinatorFactory.getCachedCoordinator(aCoDesc, tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getCachedCoordinator(CoordinatorDescriptor aCoDesc, PeerExchangeTransaction tx) {
        String coID;
        Object o;
        if (aCoDesc == null) {
            return null;
        }
        String protocol = null;
        String targetURL = PlatformHelper.getPlatformHelper().getTargetChannelURL(aCoDesc);
        if (!PlatformHelper.getPlatformHelper().isServer() && tx != null && tx.getLocalProperty("weblogic.client.handoffCoURL") != null) {
            String handoffCoURL = (String)tx.getLocalProperty("weblogic.client.handoffCoURL");
            targetURL = CoordinatorDescriptor.getServerURL(handoffCoURL);
        }
        protocol = targetURL != null ? URI.create(targetURL).getScheme() : aCoDesc.getProtocol(tx);
        String key = protocol + "+" + aCoDesc.getServerID();
        if (TxDebug.JTANaming.isDebugEnabled() && TxDebug.JTANamingStackTrace.isDebugEnabled()) {
            TxDebug.debugStack(TxDebug.JTANamingStackTrace, "CoordinatorFactory.getCachedCoordinator key:" + key + " Codesc:" + aCoDesc + " tx:" + tx);
        }
        if ((o = cachedStubs.get(key)) != null) {
            return o;
        }
        String string = coID = key.intern();
        synchronized (string) {
            o = cachedStubs.get(coID);
            if (o != null) {
                return o;
            }
            Long startTime = (Long)connectStartTime.get(coID);
            if (startTime != null) {
                int txTimeToLiveSecs = tx == null ? 30 : tx.getTimeToLiveSeconds();
                int timeoutSecs = CoordinatorFactory.getContactCoordinatorWaitSeconds(txTimeToLiveSecs);
                try {
                    coID.wait(timeoutSecs * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                o = cachedStubs.get(coID);
                if (o == null && TxDebug.JTA2PC.isDebugEnabled()) {
                    TxDebug.JTA2PC.debug("Cannot get Coordinator stub after waiting for " + timeoutSecs + " seconds, timeToLive before waiting was " + txTimeToLiveSecs + "seconds");
                }
                return o;
            }
            connectStartTime.put(coID, System.currentTimeMillis());
        }
        String tmpSvrU = null;
        String tmpCo = null;
        try {
            String coURL;
            String serverURL;
            String coName;
            o = cachedStubs.get(coID);
            if (o != null) {
                Object txTimeToLiveSecs = o;
                return txTimeToLiveSecs;
            }
            tmpCo = coName = aCoDesc.getServerName();
            String adminURL = null;
            tmpSvrU = serverURL = aCoDesc.getServerURL(tx);
            if (PlatformHelper.getPlatformHelper().isServer() && !aCoDesc.isCoURLExtendedWithAdminPort(coURL = aCoDesc.getCoordinatorURL())) {
                adminURL = CoordinatorDescriptor.getAdminCoordinatorURL(coURL);
                if (adminURL != null) {
                    serverURL = CoordinatorDescriptor.getServerURL(adminURL);
                }
            }
            if (targetURL != null) {
                serverURL = targetURL;
            }
            if (TxDebug.JTANaming.isDebugEnabled()) {
                TxDebug.JTANaming.debug("CoordinatorFactory.getCachedCoordinator to run action key:" + key + " coName:" + coName + " serverURL:" + serverURL + " thread:" + Thread.currentThread().getName());
            }
            TransactionImpl curTx = CoordinatorFactory.getTM().internalSuspend();
            Context ctx = null;
            try {
                ctx = CoordinatorFactory.getInitialContext(serverURL);
                o = PlatformHelper.getPlatformHelper().isServer() ? PlatformHelper.getPlatformHelper().lookupCoordinator(aCoDesc.getDomainName(), coName, ctx, serverURL) : ctx.lookup("weblogic.transaction.coordinators." + coName);
                if (o instanceof ClientTransactionManagerImpl) {
                    o = ((ClientTransactionManagerImpl)o).getCoordinator();
                }
                cachedStubs.put(coID, o);
                if (TxDebug.JTANaming.isDebugEnabled()) {
                    cachedURLs.put(coID, serverURL);
                    if (TxDebug.JTANamingStackTrace.isDebugEnabled()) {
                        TxDebug.debugStack(TxDebug.JTANamingStackTrace, "CoordinatorFactory.getCachedCoordinator put coID:" + coID + " o:" + o + " tx:" + tx);
                    }
                }
                if (o instanceof Remote) {
                    PlatformHelper.getPlatformHelper().getCoordinatorFactory().addDisconnectListenerToDisconnectMonitor((Remote)o, coID);
                }
            }
            finally {
                CoordinatorFactory.getTM().internalResume(curTx);
                if (ctx != null) {
                    ctx.close();
                }
            }
        }
        catch (Exception ignore) {
            if (TxDebug.JTA2PC.isDebugEnabled()) {
                if (TxDebug.JTA2PCStackTrace.isDebugEnabled()) {
                    TxDebug.JTA2PCStackTrace.debug("Cannot obtain Coordinator: run action key:" + key + " coName:" + tmpCo + " serverURL:" + tmpSvrU + aCoDesc.getCoordinatorURL() + " tx:" + tx, ignore);
                } else {
                    TxDebug.JTA2PC.debug("Cannot obtain Coordinator: " + aCoDesc.getCoordinatorURL());
                }
            }
            Object var10_16 = null;
            return var10_16;
        }
        finally {
            String string2 = coID;
            synchronized (string2) {
                connectStartTime.remove(coID);
                coID.notifyAll();
            }
        }
        return o;
    }

    public static Map<String, String> getCachedURLs() {
        return (Map)((HashMap)cachedURLs).clone();
    }

    static void clearCachedEntries() {
        cachedStubs.clear();
        if (TxDebug.JTANaming.isDebugEnabled()) {
            cachedURLs.clear();
            TxDebug.JTANaming.debug("Cleared cached Coordinator stub entries");
        }
    }

    private static int getContactCoordinatorWaitSeconds(int timeout) {
        timeout = Math.min(timeout, contactCoordinatorWaitSecondsMax);
        return Math.max(timeout, contactCoordinatorWaitSecondsMin);
    }

    protected static TransactionManagerImpl getTM() {
        return TransactionManagerImpl.getTransactionManager();
    }

    public Object runAction(String coName, String serverURL, Context ctx) throws Exception {
        return SecureAction.runAction(kernelID, new JNDILookUpAction(coName, ctx), serverURL, "getCachedCoordinator");
    }

    public void addDisconnectListenerToDisconnectMonitor(Remote o, final String coID) {
        block3: {
            DisconnectMonitor dm = (DisconnectMonitor)PlatformHelper.getPlatformHelper().getDisconnectMonitor();
            try {
                if (dm != null) {
                    dm.addDisconnectListener(o, new DisconnectListener(){

                        @Override
                        public void onDisconnect(DisconnectEvent reason) {
                            cachedStubs.remove(coID);
                            if (TxDebug.JTANaming.isDebugEnabled()) {
                                cachedURLs.remove(coID);
                            }
                        }
                    });
                }
            }
            catch (DisconnectMonitorUnavailableException dmue) {
                cachedStubs.remove(coID);
                if (!TxDebug.JTANaming.isDebugEnabled()) break block3;
                cachedURLs.remove(coID);
            }
        }
    }

    static {
        String val = System.getProperty("weblogic.JTA.ContactCoordinatorWaitSeconds");
        if (val != null) {
            try {
                int i = Integer.parseInt(val);
                if (i > 0) {
                    contactCoordinatorWaitSecondsMin = i;
                    contactCoordinatorWaitSecondsMax = i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected static class JNDILookUpAction
    implements PrivilegedExceptionAction {
        private String objName;
        private Object obj;
        private Context ctx;

        public JNDILookUpAction(String oName, Context context) {
            this.objName = oName;
            this.obj = null;
            this.ctx = context;
        }

        public Object run() throws Exception {
            this.obj = this.ctx.lookup("weblogic.transaction.coordinators." + this.objName);
            return this.obj;
        }
    }
}

