/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import jakarta.transaction.SystemException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.Xid;
import weblogic.transaction.TransactionSystemException;
import weblogic.transaction.internal.IOHelper;
import weblogic.transaction.internal.PlatformHelper;
import weblogic.transaction.internal.ResourceInfo;
import weblogic.transaction.internal.SCInfo;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.transaction.internal.TransactionManagerImpl;
import weblogic.transaction.internal.TxDebug;
import weblogic.transaction.internal.XidImpl;
import weblogic.utils.io.FilteringObjectInputStream;
import weblogic.utils.io.ReadObjectUtils;

public final class PropagationContext
implements Externalizable {
    static final long serialVersionUID = -8597561089762241351L;
    private transient TransactionImpl tx = null;
    private transient Object peerInfo = null;
    private transient boolean infectCoordinatorFirstTime = false;
    private transient boolean readOrWriteRollbackReasonInBytes = true;
    static final int VERSION1 = 1;
    static final int VERSION2 = 2;
    static final int VERSION3 = 3;
    static final int VERSION4 = 4;
    private int inVersion;
    private XidImpl xid;
    private int timeToLiveSec;
    private int timeoutSec;
    private boolean isCancelled;
    private Throwable rollbackReason;
    private byte[] rollbackReasonInBytes = null;
    private String coordinatorURL;
    private String txName;
    private String[] scURLs;
    private byte[] scStates;
    private byte[] scSyncRegs;
    private String[] resNames;
    private String[][] resSCURLs;
    private HashMap txProps;
    private static final boolean m_isDebugCoURL = Boolean.getBoolean("weblogic.transaction.internal.debugcourl");

    static boolean isDebugCoURL() {
        return m_isDebugCoURL;
    }

    public PropagationContext() {
    }

    PropagationContext(TransactionImpl atx) {
        this.tx = atx;
    }

    public String toString() {
        return "PropagationContext[" + (this.tx == null ? "" : this.tx.toString()) + "]";
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        int streamVersion = this.getVersion(oo);
        this.readOrWriteRollbackReasonInBytes = this.useNewMethod(oo);
        if (streamVersion == 2 || streamVersion == 3 || streamVersion == 4) {
            ResourceInfo ri;
            int len;
            IOHelper.writeCompressedInt(oo, streamVersion);
            ((XidImpl)this.tx.getXID()).writeExternal(oo);
            IOHelper.writeCompressedInt(oo, this.tx.getTimeToLiveSeconds());
            IOHelper.writeCompressedInt(oo, this.tx.getTimeoutSeconds());
            boolean isCancelled = this.tx.isCancelled();
            oo.writeBoolean(isCancelled);
            if (isCancelled) {
                this.writeRollbackReason(oo);
            }
            this.writeAbbrevString(oo, this.tx.getCoordinatorURL() == null ? "" : this.tx.getCoordinatorURL());
            String txname = this.tx.getName();
            this.writeAbbrevString(oo, txname == null ? "" : txname);
            List scList = this.tx.getSCInfoList();
            if (scList == null) {
                IOHelper.writeCompressedInt(oo, 0);
            } else {
                int len2 = scList.size();
                IOHelper.writeCompressedInt(oo, len2);
                for (int i = 0; i < len2; ++i) {
                    SCInfo sci = (SCInfo)scList.get(i);
                    this.writeAbbrevString(oo, sci.getScUrl(this.tx));
                    if (PropagationContext.isDebugCoURL()) {
                        new Throwable("PropagationContext writeExternal abbrev getScUrl:" + sci.getScUrl(this.tx)).printStackTrace();
                    }
                    oo.writeByte(sci.getState());
                    if (sci.isSyncRegistered()) {
                        oo.writeByte(1);
                        continue;
                    }
                    oo.writeByte(0);
                }
            }
            ArrayList resourceList = this.tx.getResourceInfoList();
            if (resourceList == null) {
                IOHelper.writeCompressedInt(oo, 0);
            } else if (streamVersion == 2) {
                len = resourceList.size();
                IOHelper.writeCompressedInt(oo, len);
                for (int i = 0; i < len; ++i) {
                    ri = (ResourceInfo)resourceList.get(i);
                    this.writeAbbrevString(oo, ri.getName());
                }
            } else {
                len = resourceList.size();
                IOHelper.writeCompressedInt(oo, len);
                for (int i = 0; i < len; ++i) {
                    ri = (ResourceInfo)resourceList.get(i);
                    this.writeAbbrevString(oo, ri.getName());
                    ArrayList resourceSCList = ri.getSCInfoList();
                    if (resourceSCList == null) {
                        IOHelper.writeCompressedInt(oo, 0);
                        continue;
                    }
                    int sclen = resourceSCList.size();
                    IOHelper.writeCompressedInt(oo, sclen);
                    for (int j = 0; j < sclen; ++j) {
                        SCInfo sci = (SCInfo)resourceSCList.get(j);
                        this.writeAbbrevString(oo, sci.getScUrl(this.tx));
                        if (!PropagationContext.isDebugCoURL()) continue;
                        new Throwable("PropagationContext writeExternal V3 getScUrl:" + sci.getScUrl(this.tx)).printStackTrace();
                    }
                }
            }
            HashMap<String, String> props = this.filterOTSAndWSATProperties(this.tx.getProperties());
            if (streamVersion == 4 && this.infectCoordinatorFirstTime) {
                if (props == null) {
                    props = new HashMap<String, String>();
                }
                props.put("weblogic.transaction.infectCoordinatorFirstTime", "true");
            }
            int len3 = props == null ? 0 : props.size();
            IOHelper.writeCompressedInt(oo, len3);
            if (len3 > 0) {
                for (Map.Entry entry : props.entrySet()) {
                    this.writeAbbrevString(oo, (String)entry.getKey());
                    oo.writeObject(entry.getValue());
                }
            }
        } else if (streamVersion == 1) {
            IOHelper.writeCompressedInt(oo, 1);
            ((XidImpl)this.tx.getXID()).writeExternal(oo);
            IOHelper.writeCompressedInt(oo, this.tx.getTimeToLiveSeconds());
            IOHelper.writeCompressedInt(oo, this.tx.getTimeoutSeconds());
            boolean isCancelled = this.tx.isCancelled();
            oo.writeBoolean(isCancelled);
            if (isCancelled) {
                this.writeRollbackReason(oo);
            }
            oo.writeUTF(this.tx.getCoordinatorURL() == null ? "" : this.tx.getCoordinatorURL());
            String txname = this.tx.getName();
            oo.writeUTF(txname == null ? "" : txname);
            List scList = this.tx.getSCInfoList();
            if (scList == null) {
                IOHelper.writeCompressedInt(oo, 0);
            } else {
                int len = scList.size();
                IOHelper.writeCompressedInt(oo, len);
                for (int i = 0; i < len; ++i) {
                    SCInfo sci = (SCInfo)scList.get(i);
                    oo.writeUTF(sci.getScUrl(this.tx));
                    if (PropagationContext.isDebugCoURL()) {
                        new Throwable("PropagationContext writeExternal UTF scInfo getScUrl:" + sci.getScUrl(this.tx)).printStackTrace();
                    }
                    oo.writeByte(sci.getState());
                }
            }
            ArrayList resourceList = this.tx.getResourceInfoList();
            if (resourceList == null) {
                IOHelper.writeCompressedInt(oo, 0);
            } else {
                int len = resourceList.size();
                IOHelper.writeCompressedInt(oo, len);
                for (int i = 0; i < len; ++i) {
                    ResourceInfo ri = (ResourceInfo)resourceList.get(i);
                    oo.writeUTF(ri.getName());
                    ArrayList resourceSCList = ri.getSCInfoList();
                    if (resourceSCList == null) {
                        IOHelper.writeCompressedInt(oo, 0);
                        continue;
                    }
                    int sclen = resourceSCList.size();
                    IOHelper.writeCompressedInt(oo, sclen);
                    for (int j = 0; j < sclen; ++j) {
                        SCInfo sci = (SCInfo)resourceSCList.get(j);
                        oo.writeUTF(sci.getScUrl(this.tx));
                        if (!PropagationContext.isDebugCoURL()) continue;
                        new Throwable("PropagationContext writeExternal writeUTF getScUrl:" + sci.getScUrl(this.tx)).printStackTrace();
                    }
                }
            }
            Map txprops = this.filterOTSAndWSATProperties(this.tx.getProperties());
            if (txprops == null || txprops.size() == 0) {
                IOHelper.writeCompressedInt(oo, 0);
            } else {
                IOHelper.writeCompressedInt(oo, txprops.size());
                oo.writeObject(txprops);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.readOrWriteRollbackReasonInBytes = this.useNewMethod(oi);
        this.setPeerInfo(oi);
        this.inVersion = IOHelper.readCompressedInt(oi);
        if (this.inVersion == 2 || this.inVersion == 3 || this.inVersion == 4) {
            int i;
            this.xid = new XidImpl();
            this.xid.readExternal(oi);
            this.timeToLiveSec = IOHelper.readCompressedInt(oi);
            this.timeoutSec = IOHelper.readCompressedInt(oi);
            this.isCancelled = oi.readBoolean();
            if (this.isCancelled) {
                this.readRollbackReason(oi);
            }
            this.coordinatorURL = this.readAbbrevString(oi);
            this.txName = this.readAbbrevString(oi);
            int len = IOHelper.readCompressedInt(oi);
            ReadObjectUtils.ensureValidSize(len);
            if (len > 0) {
                this.scURLs = new String[len];
                this.scStates = new byte[len];
                this.scSyncRegs = new byte[len];
                for (i = 0; i < len; ++i) {
                    this.scURLs[i] = this.readAbbrevString(oi);
                    this.scStates[i] = oi.readByte();
                    this.scSyncRegs[i] = oi.readByte();
                    if (!PropagationContext.isDebugCoURL()) continue;
                    new Throwable("PropagationContext scURLs:" + this.scURLs[i]).printStackTrace();
                }
            }
            len = IOHelper.readCompressedInt(oi);
            ReadObjectUtils.ensureValidSize(len);
            if (len > 0) {
                if (this.inVersion == 2) {
                    this.resNames = new String[len];
                    for (i = 0; i < len; ++i) {
                        this.resNames[i] = this.readAbbrevString(oi);
                    }
                } else {
                    this.resNames = new String[len];
                    this.resSCURLs = new String[len][];
                    for (i = 0; i < len; ++i) {
                        this.resNames[i] = this.readAbbrevString(oi);
                        int sclen = IOHelper.readCompressedInt(oi);
                        if (sclen <= 0) continue;
                        this.resSCURLs[i] = new String[sclen];
                        String[] curResSCURLs = this.resSCURLs[i];
                        for (int j = 0; j < sclen; ++j) {
                            curResSCURLs[j] = this.readAbbrevString(oi);
                        }
                    }
                }
            }
            len = IOHelper.readCompressedInt(oi);
            ReadObjectUtils.ensureValidSize(len);
            if (len > 0) {
                this.txProps = new HashMap(len);
                for (i = 0; i < len; ++i) {
                    String key = this.readAbbrevString(oi);
                    Object val = oi.readObject();
                    this.txProps.put(key, val);
                }
                if (this.inVersion == 4 && this.txProps.remove("weblogic.transaction.infectCoordinatorFirstTime") != null) {
                    this.infectCoordinatorFirstTime = true;
                }
            }
        } else if (this.inVersion == 1) {
            int propsLen;
            int i;
            this.xid = new XidImpl();
            this.xid.readExternal(oi);
            this.timeToLiveSec = IOHelper.readCompressedInt(oi);
            this.timeoutSec = IOHelper.readCompressedInt(oi);
            this.isCancelled = oi.readBoolean();
            if (this.isCancelled) {
                this.readRollbackReason(oi);
            }
            this.coordinatorURL = oi.readUTF();
            this.txName = oi.readUTF();
            int len = IOHelper.readCompressedInt(oi);
            ReadObjectUtils.ensureValidSize(len);
            if (len > 0) {
                this.scURLs = new String[len];
                this.scStates = new byte[len];
                this.scSyncRegs = new byte[len];
                for (i = 0; i < len; ++i) {
                    this.scURLs[i] = oi.readUTF();
                    this.scStates[i] = oi.readByte();
                    this.scSyncRegs[i] = 1;
                    if (!PropagationContext.isDebugCoURL()) continue;
                    new Throwable("PropagationCOntext scInfo scURLs" + this.scURLs[i]).printStackTrace();
                }
            }
            len = IOHelper.readCompressedInt(oi);
            ReadObjectUtils.ensureValidSize(len);
            if (len > 0) {
                this.resNames = new String[len];
                this.resSCURLs = new String[len][];
                for (i = 0; i < len; ++i) {
                    this.resNames[i] = oi.readUTF();
                    int sclen = IOHelper.readCompressedInt(oi);
                    if (sclen <= 0) continue;
                    this.resSCURLs[i] = new String[sclen];
                    String[] curResSCURLs = this.resSCURLs[i];
                    for (int j = 0; j < sclen; ++j) {
                        curResSCURLs[j] = oi.readUTF();
                    }
                }
            }
            if ((propsLen = IOHelper.readCompressedInt(oi)) > 0) {
                this.txProps = (HashMap)oi.readObject();
            }
        } else {
            throw new IOException("Unsupported JTA PropagationContext version " + this.inVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionImpl getTransaction() throws TransactionSystemException {
        if (TxDebug.JTAPropagate.isDebugEnabled()) {
            TxDebug.JTAPropagate.debug("PropagationContext.getTransaction: tx=" + this.tx);
        }
        if (this.tx == null) {
            if (this.inVersion < 1 || this.inVersion > 4) {
                throw new TransactionSystemException("Tx context version mismatch. This version =" + PropagationContext.getVersion() + ", incoming version = " + this.inVersion + ", supported versions = " + 1 + ", " + 2 + ", " + 3 + ", " + 4 + ".");
            }
            TransactionManagerImpl tm = PropagationContext.getTM();
            boolean isCoordinator = tm.isLocalCoordinator(this.coordinatorURL);
            Xid foreignXid = null;
            if (isCoordinator && this.txProps != null) {
                foreignXid = (Xid)this.txProps.get("weblogic.transaction.foreignXid");
            }
            if (TxDebug.JTAPropagate.isDebugEnabled()) {
                TxDebug.JTAPropagate.debug("PropagationContext.getTransaction: xid=" + this.xid + ", isCoordinator=" + isCoordinator + ", infectCoordinatorFirstTime=" + this.infectCoordinatorFirstTime + ", txProps=" + this.txProps);
            }
            TransactionManagerImpl transactionManagerImpl = tm;
            synchronized (transactionManagerImpl) {
                this.tx = (TransactionImpl)tm.getTransactionUnsync(this.xid);
                if (this.tx == null) {
                    try {
                        if (isCoordinator && this.inVersion >= 4 && foreignXid == null && !this.infectCoordinatorFirstTime) {
                            return null;
                        }
                        if (isCoordinator && foreignXid != null) {
                            this.tx = tm.createImportedTransaction(this.xid, foreignXid, this.timeoutSec, this.timeToLiveSec);
                            this.tx.setDelayRemoveAfterRollback(true);
                        } else {
                            boolean isSSLURL = PlatformHelper.getPlatformHelper().isSSLURL(this.coordinatorURL);
                            this.tx = tm.createTransaction(this.xid, this.timeoutSec, this.timeToLiveSec, isSSLURL, true);
                            if (isCoordinator && this.inVersion < 4) {
                                this.tx.setDelayRemoveAfterRollback(true);
                            }
                        }
                    }
                    catch (SystemException se) {
                        throw new TransactionSystemException("Unable to create transaction: " + this.xid + ".  " + se);
                    }
                }
            }
            if (this.isCancelled && !this.tx.isOver() && !this.tx.isCancelled()) {
                if (this.rollbackReasonInBytes != null) {
                    this.rollbackReason = this.convertBytesToRollbackReason(this.rollbackReasonInBytes);
                }
                this.tx.setRollbackOnly(this.rollbackReason);
            }
            this.tx.setCoordinatorURL(this.coordinatorURL);
            this.tx.setName(this.txName);
            if (this.scURLs != null) {
                for (int i = 0; i < this.scURLs.length; ++i) {
                    String scURL = this.scURLs[i];
                    if (tm.isLocalCoordinator(scURL)) continue;
                    SCInfo sci = this.tx.getOrCreateSCInfo(scURL);
                    sci.setState(this.scStates[i]);
                    if (this.scSyncRegs[i] != 1) continue;
                    sci.setSyncRegistered(true);
                }
            }
            if (this.txProps != null) {
                this.tx.addProperties(this.txProps);
            }
            if (this.resNames != null) {
                for (int i = 0; i < this.resNames.length; ++i) {
                    String[] curSCURLs;
                    ResourceInfo ri = this.tx.getOrCreateResourceInfo(this.resNames[i], true);
                    if (this.resSCURLs == null || (curSCURLs = this.resSCURLs[i]) == null) continue;
                    for (int j = 0; j < curSCURLs.length; ++j) {
                        ri.addSC(this.tx.getOrCreateSCInfo(curSCURLs[j]));
                    }
                }
            }
            return this.tx;
        }
        if (this.xid == null) {
            return this.tx;
        }
        return (TransactionImpl)PropagationContext.getTM().getTransaction(this.xid);
    }

    Object getPeerInfo() {
        return this.peerInfo;
    }

    private int getVersion(ObjectOutput oo) throws IOException {
        return PlatformHelper.getPlatformHelper().getVersion(oo);
    }

    private void setPeerInfo(ObjectInput oi) throws IOException {
        Object object = PlatformHelper.getPlatformHelper().getPeerInfo(oi);
        if (object != null) {
            this.peerInfo = object;
        }
    }

    private static TransactionManagerImpl getTM() {
        return TransactionManagerImpl.getTransactionManager();
    }

    private void writeAbbrevString(ObjectOutput oo, String s) throws IOException {
        PlatformHelper.getPlatformHelper().writeAbbrevString0(oo, s);
    }

    private String readAbbrevString(ObjectInput oi) throws IOException {
        return PlatformHelper.getPlatformHelper().readAbbrevString(oi);
    }

    static int getVersion() {
        return 4;
    }

    public void infectCoordinatorFirstTime() {
        this.infectCoordinatorFirstTime = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] convertRollbackReasonToBytes(Throwable reason) throws IOException {
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(reason);
            oos.flush();
            byte[] rollbackReasonBytes = baos.toByteArray();
            if (TxDebug.JTAPropagate.isDebugEnabled()) {
                String rollbackReasonString = "";
                if (rollbackReasonBytes != null) {
                    for (byte rollbackReasonByte : rollbackReasonBytes) {
                        rollbackReasonString = rollbackReasonString + rollbackReasonByte;
                    }
                }
                TxDebug.JTAPropagate.debug(" +++ converted rollback reason ('" + reason + "') to bytes : " + rollbackReasonString);
            }
            byte[] byArray = rollbackReasonBytes;
            return byArray;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable convertBytesToRollbackReason(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            ois = new TxObjectInputStream(bais);
            Throwable reason = (Throwable)ois.readObject();
            if (TxDebug.JTAPropagate.isDebugEnabled()) {
                TxDebug.JTAPropagate.debug(" +++ converted bytes to rollback reason : " + reason);
            }
            Throwable throwable = reason;
            return throwable;
        }
        catch (IOException ioe) {
            System.err.println(" Error while reading rollback reason : " + PlatformHelper.getPlatformHelper().throwable2StackTrace(ioe));
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println(" Error while reading rollback reason : " + PlatformHelper.getPlatformHelper().throwable2StackTrace(cnfe));
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ioe) {}
            }
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException ioe) {}
            }
        }
        return null;
    }

    private void readRollbackReason(ObjectInput oi) throws IOException, ClassNotFoundException {
        if (this.readOrWriteRollbackReasonInBytes) {
            if (TxDebug.JTAPropagate.isDebugEnabled()) {
                TxDebug.JTAPropagate.debug(" +++ Using new Method for reading rollback reason....");
            }
            this.rollbackReasonInBytes = (byte[])oi.readObject();
        } else {
            Object o;
            if (TxDebug.JTAPropagate.isDebugEnabled()) {
                TxDebug.JTAPropagate.debug(" +++ Using old Method for reading rollback reason....");
            }
            if ((o = oi.readObject()) instanceof byte[]) {
                if (TxDebug.JTAPropagate.isDebugEnabled()) {
                    TxDebug.JTAPropagate.debug(" +++ Using old Method for reading rollback reason but object was of type byte[]....");
                }
                this.rollbackReasonInBytes = (byte[])o;
            } else {
                this.rollbackReason = (Throwable)o;
            }
        }
    }

    private void writeRollbackReason(ObjectOutput oo) throws IOException {
        if (this.readOrWriteRollbackReasonInBytes) {
            if (TxDebug.JTAPropagate.isDebugEnabled()) {
                TxDebug.JTAPropagate.debug(" +++ Using new Method for writing rollback reason....");
            }
            oo.writeObject(this.convertRollbackReasonToBytes(this.tx.getRollbackReason()));
        } else {
            if (TxDebug.JTAPropagate.isDebugEnabled()) {
                TxDebug.JTAPropagate.debug(" +++ Using old Method for writing rollback reason....");
            }
            oo.writeObject(this.tx.getRollbackReason());
        }
    }

    private boolean useNewMethod(Object obj) {
        return PlatformHelper.getPlatformHelper().useNewMethod(obj);
    }

    private Map filterOTSAndWSATProperties(Map props) {
        if (props != null) {
            props.remove("weblogic.transaction.ots.resources");
            props.remove("weblogic.transaction.ots.ftmCounter");
            props.remove("weblogic.wsee.wstx.foreignContext");
        }
        return props;
    }

    public int getTimeoutSecs() {
        return this.timeoutSec;
    }

    private class TxObjectInputStream
    extends FilteringObjectInputStream {
        private TxObjectInputStream(InputStream is) throws IOException {
            super(is);
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            ClassLoader loader = PlatformHelper.getPlatformHelper().getContextClassLoader();
            if (TxDebug.JTAPropagate.isDebugEnabled()) {
                TxDebug.JTAPropagate.debug(" +++ looking up class : " + v.getName() + " ::  in classloader : " + loader);
            }
            return Class.forName(v.getName(), false, loader);
        }
    }
}

