/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import weblogic.utils.UnsyncStringBuffer;

public final class ArrayUtils {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    private ArrayUtils() {
    }

    public static int hashCode(Object[] oo) {
        int hash = 0;
        for (int i = 0; i < oo.length; ++i) {
            hash ^= oo[i].hashCode();
        }
        return hash;
    }

    public static int hashCode(byte[] oo) {
        if (oo == null) {
            return 0;
        }
        int hash = 1;
        for (int i = 0; i < oo.length; ++i) {
            hash = 31 * hash + i;
        }
        return hash;
    }

    public static String toString(int[] array) {
        int length = array.length;
        if (length < 1) {
            return null;
        }
        UnsyncStringBuffer buf = new UnsyncStringBuffer("int[");
        for (int i = 0; i < length; ++i) {
            buf.append(array[i]);
            if (i >= length - 1) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public static String toString(Object[] array) {
        int length = array.length;
        if (length < 1) {
            return null;
        }
        Class<?> c = array[0].getClass();
        UnsyncStringBuffer buf = new UnsyncStringBuffer(c.getName());
        buf.append('[');
        for (int i = 0; i < length; ++i) {
            buf.append(array[i].toString());
            if (i >= length - 1) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public static boolean addAll(Collection c, Object[] a) {
        boolean b = false;
        for (int i = 0; i < a.length; ++i) {
            b |= c.add(a[i]);
        }
        return b;
    }

    public static boolean removeAll(Collection c, Object[] a) {
        boolean b = false;
        for (int i = 0; i < a.length; ++i) {
            b |= c.remove(a[i]);
        }
        return b;
    }

    public static boolean retainAll(Collection c, Object[] a) {
        boolean b = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (ArrayUtils.contains(a, o)) continue;
            i.remove();
            b = true;
        }
        return b;
    }

    public static boolean containsAll(Collection c, Object ... a) {
        for (Object anA : a) {
            if (c.contains(anA)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(Object[] a, Object o) {
        if (o == null) {
            for (int i = 0; i < a.length; ++i) {
                if (a[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < a.length; ++i) {
                if (!o.equals(a[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> void computeDiff(T[] oldArray, T[] newArray, DiffHandler<T> handler, Comparator<T> comparator) {
        if (comparator == null) {
            ArrayUtils.computeDiff(oldArray, newArray, handler);
            return;
        }
        Arrays.sort(oldArray, comparator);
        Arrays.sort(newArray, comparator);
        int originalIndex = 0;
        int proposedIndex = 0;
        int originalMax = oldArray.length;
        int proposedMax = newArray.length;
        if (originalMax <= 0) {
            for (int lcv = 0; lcv < proposedMax; ++lcv) {
                handler.addObject(newArray[lcv]);
            }
            return;
        }
        if (proposedMax <= 0) {
            for (int lcv = 0; lcv < originalMax; ++lcv) {
                handler.removeObject(oldArray[lcv]);
            }
            return;
        }
        while (originalIndex <= originalMax) {
            int whoGoes = originalIndex >= originalMax ? 1 : (proposedIndex >= proposedMax ? -1 : comparator.compare(oldArray[originalIndex], newArray[proposedIndex]));
            if (whoGoes == 0) {
                ++originalIndex;
                ++proposedIndex;
            } else if (whoGoes < 0) {
                handler.removeObject(oldArray[originalIndex]);
                ++originalIndex;
            } else {
                handler.addObject(newArray[proposedIndex]);
                ++proposedIndex;
            }
            if (proposedIndex < proposedMax || originalIndex < originalMax) continue;
            break;
        }
    }

    public static void computeDiff(Object[] oldArray, Object[] newArray, DiffHandler handler) {
        Object o;
        int i;
        Object[] toAddArray = newArray != null ? (Object[])newArray.clone() : EMPTY_ARRAY;
        for (i = 0; oldArray != null && i < oldArray.length; ++i) {
            int j;
            o = oldArray[i];
            for (j = 0; j < toAddArray.length; ++j) {
                Object o1 = toAddArray[j];
                if (o1 == null || !o1.equals(o)) continue;
                toAddArray[j] = null;
                break;
            }
            if (j != toAddArray.length) continue;
            handler.removeObject(o);
        }
        for (i = 0; i < toAddArray.length; ++i) {
            o = toAddArray[i];
            if (o == null) continue;
            handler.addObject(o);
        }
    }

    public static boolean[] copyAndSort(boolean[] a) {
        int i;
        if (a == null) {
            return null;
        }
        int countTrue = 0;
        for (int i2 = 0; i2 < a.length; ++i2) {
            if (!a[i2]) continue;
            ++countTrue;
        }
        boolean[] b = new boolean[a.length];
        for (i = 0; i < countTrue; ++i) {
            b[i] = true;
        }
        for (i = countTrue; i < a.length; ++i) {
            b[i] = false;
        }
        return b;
    }

    public static byte[] copyAndSort(byte[] a) {
        if (a == null) {
            return null;
        }
        byte[] b = new byte[a.length];
        System.arraycopy(a, 0, b, 0, a.length);
        Arrays.sort(b);
        return b;
    }

    public static char[] copyAndSort(char[] a) {
        if (a == null) {
            return null;
        }
        char[] b = new char[a.length];
        System.arraycopy(a, 0, b, 0, a.length);
        Arrays.sort(b);
        return b;
    }

    public static double[] copyAndSort(double[] a) {
        if (a == null) {
            return null;
        }
        double[] b = new double[a.length];
        System.arraycopy(a, 0, b, 0, a.length);
        Arrays.sort(b);
        return b;
    }

    public static float[] copyAndSort(float[] a) {
        if (a == null) {
            return null;
        }
        float[] b = new float[a.length];
        System.arraycopy(a, 0, b, 0, a.length);
        Arrays.sort(b);
        return b;
    }

    public static int[] copyAndSort(int[] a) {
        if (a == null) {
            return null;
        }
        int[] b = new int[a.length];
        System.arraycopy(a, 0, b, 0, a.length);
        Arrays.sort(b);
        return b;
    }

    public static long[] copyAndSort(long[] a) {
        if (a == null) {
            return null;
        }
        long[] b = new long[a.length];
        System.arraycopy(a, 0, b, 0, a.length);
        Arrays.sort(b);
        return b;
    }

    public static short[] copyAndSort(short[] a) {
        if (a == null) {
            return null;
        }
        short[] b = new short[a.length];
        System.arraycopy(a, 0, b, 0, a.length);
        Arrays.sort(b);
        return b;
    }

    public static Object[] copyAndSort(Object[] a) {
        if (a == null) {
            return null;
        }
        Object[] b = new Object[a.length];
        System.arraycopy(a, 0, b, 0, a.length);
        Arrays.sort(b);
        return b;
    }

    /*
     * Exception decompiling
     */
    public static byte[] objectToByteArray(Object o) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Object byteArrayToObject(byte[] b) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static interface DiffHandler<T> {
        public void addObject(T var1);

        public void removeObject(T var1);
    }
}

