/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class BlockingCircularQueue<E> {
    private static final int DEFAULT_TIMEOUT = 4102;
    private static final int DEFAULT_MAX_CAPACITY = 65536;
    private final ReentrantLock queueLock = new ReentrantLock();
    private final Condition notFull = this.queueLock.newCondition();
    public static final int MAX_CAPACITY = 0x40000000;
    private int size = 0;
    private int producerIndex = 0;
    private int consumerIndex = 0;
    private int capacity = 1;
    private int maxCapacity = 1;
    private int bitmask;
    private transient Object[] queue;
    private int timeout = 4102;

    public BlockingCircularQueue(int c) {
        this(c, 65536, 4102);
    }

    public BlockingCircularQueue(int initialCapacity, int maximumCapacity, int timeout) {
        if (initialCapacity > maximumCapacity) {
            throw new IllegalArgumentException("Capacity greater than maximum");
        }
        if (maximumCapacity > 0x40000000) {
            throw new IllegalArgumentException("Capacity: '" + maximumCapacity + "' greater than maximum: '" + 0x40000000 + '\'');
        }
        this.capacity = 1;
        while (this.capacity < initialCapacity) {
            this.capacity <<= 1;
        }
        this.maxCapacity = 1;
        while (this.maxCapacity < maximumCapacity) {
            this.maxCapacity <<= 1;
        }
        this.bitmask = this.capacity - 1;
        this.queue = new Object[this.capacity];
        this.timeout = timeout;
    }

    private void expandQueue() {
        if (this.capacity == this.maxCapacity) {
            throw new RuntimeException("Queue exceeds maximum capacity of : '1073741824' elements");
        }
        int old_capacity = this.capacity;
        Object[] old_q = this.queue;
        this.capacity += this.capacity;
        this.bitmask = this.capacity - 1;
        this.queue = new Object[this.capacity];
        System.arraycopy(old_q, this.consumerIndex, this.queue, 0, old_capacity - this.consumerIndex);
        if (this.consumerIndex != 0) {
            System.arraycopy(old_q, 0, this.queue, old_capacity - this.consumerIndex, this.consumerIndex);
        }
        this.consumerIndex = 0;
        this.producerIndex = this.size;
    }

    /*
     * Unable to fully structure code
     */
    public final void put(E obj) {
        if (this.size == this.maxCapacity) {
            try {
                if (this.size != this.maxCapacity) ** GOTO lbl15
                this.queueLock.lockInterruptibly();
                this.notFull.await(this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException var2_2) {
            }
            finally {
                this.queueLock.unlock();
            }
        } else if (this.size == this.capacity) {
            this.expandQueue();
        }
lbl15:
        // 6 sources

        ++this.size;
        this.queue[this.producerIndex] = obj;
        this.producerIndex = this.producerIndex + 1 & this.bitmask;
    }

    public final E get() {
        if (this.size == 0) {
            return null;
        }
        --this.size;
        Object obj = this.queue[this.consumerIndex];
        this.queue[this.consumerIndex] = null;
        this.consumerIndex = this.consumerIndex + 1 & this.bitmask;
        if (this.queueLock.getHoldCount() > 0) {
            try {
                this.queueLock.lockInterruptibly();
                this.notFull.signal();
                this.notFull.signalAll();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.queueLock.unlock();
            }
        }
        return (E)obj;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public E peek() {
        if (this.size == 0) {
            return null;
        }
        return (E)this.queue[this.consumerIndex];
    }

    public String toString() {
        StringBuilder s = new StringBuilder(super.toString() + " - capacity: '" + this.capacity() + "' size: '" + this.size() + '\'');
        if (this.size > 0) {
            s.append(" elements:");
            for (int i = 0; i < this.size; ++i) {
                s.append('\n');
                s.append('\t');
                s.append(this.queue[this.consumerIndex + i & this.bitmask].toString());
            }
        }
        return s.toString();
    }
}

