/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

public final class Classpath {
    private static Set paths;
    private static String classpath;
    private static String separator;

    public static ArrayList<String> sanityCheck(String[] jarsToCheck) {
        boolean[] jarsChecked = new boolean[jarsToCheck.length];
        for (int i = 0; i < jarsChecked.length; ++i) {
            jarsChecked[i] = false;
        }
        int toCheck = jarsToCheck.length;
        ArrayList<String> warnings = new ArrayList<String>();
        TreeSet<String> checkedjars = new TreeSet<String>();
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreElements() && toCheck > 0) {
            String jarPath = st.nextToken();
            int index = Classpath.getJarsToCheckIndex(jarPath, jarsToCheck);
            if (index == -1) continue;
            jarsChecked[index] = true;
            --toCheck;
            Classpath.sanityCheck(new File(jarPath), warnings, checkedjars);
        }
        if (toCheck > 0) {
            StringBuffer sbuff = new StringBuffer();
            for (int i = 0; i < jarsChecked.length && toCheck > 0; ++i) {
                if (jarsChecked[i]) continue;
                sbuff.append(jarsToCheck[i]);
                if (--toCheck <= 0) continue;
                sbuff.append(", ");
            }
            warnings.add("The following jars were not found in CLASSPATH: " + sbuff.toString());
        }
        return warnings;
    }

    private static String getCanonicalPath(File f) throws MalformedURLException {
        String p = f.toURI().toURL().getPath();
        if ("\\".equals(File.separator) && p.length() >= 3 && p.charAt(0) == '/' && p.charAt(2) == ':') {
            p = p.substring(1);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sanityCheck(File jarPath, ArrayList<String> warnings, TreeSet<String> checkedjars) {
        ZipFile jarFile = null;
        try {
            String jarPathCanonical = Classpath.getCanonicalPath(jarPath);
            if (checkedjars.contains(jarPathCanonical)) {
                return;
            }
            checkedjars.add(jarPathCanonical);
            jarFile = new JarFile(jarPath);
            Manifest manifest = ((JarFile)jarFile).getManifest();
            String manifestClasspath = null;
            if (manifest != null) {
                manifestClasspath = manifest.getMainAttributes().getValue("Class-Path");
            }
            if (manifestClasspath != null) {
                StringTokenizer st = new StringTokenizer(manifestClasspath);
                while (st.hasMoreElements()) {
                    String token = st.nextToken();
                    Classpath.sanityCheck(new File(jarPath.getParentFile(), token).getCanonicalFile(), warnings, checkedjars);
                }
            }
        }
        catch (IOException ioe) {
            if (ioe.getMessage().contains(jarPath.getName())) {
                warnings.add("IOException: " + ioe.getMessage());
            } else {
                warnings.add("IOException: " + ioe.getMessage() + ", file: " + jarPath);
            }
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static int getJarsToCheckIndex(String jarPath, String[] jarsToCheck) {
        for (int i = 0; i < jarsToCheck.length; ++i) {
            if (!jarPath.contains(jarsToCheck[i])) continue;
            return i;
        }
        return -1;
    }

    public static synchronized void prepend(File file) {
        if (Classpath.alreadySeen(file)) {
            return;
        }
        try {
            String path = Classpath.getCanonicalPath(file);
            classpath = path + separator + classpath;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized void append(File file) {
        if (Classpath.alreadySeen(file)) {
            return;
        }
        try {
            String path = Classpath.getCanonicalPath(file);
            classpath = classpath + separator + path;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized String append(String originalClasspath, String additionalFile) {
        return originalClasspath + separator + additionalFile;
    }

    public static synchronized String get() {
        return classpath;
    }

    private static boolean alreadySeen(File file) {
        if (paths.contains(file)) {
            return true;
        }
        paths.add(file);
        return false;
    }

    static {
        String javaHome;
        String jrtClasspath;
        String javaClasspath;
        paths = new HashSet();
        classpath = null;
        separator = System.getProperty("path.separator");
        classpath = javaClasspath = System.getProperty("java.class.path");
        String sunBootClasspath = System.getProperty("sun.boot.class.path");
        if (sunBootClasspath != null) {
            classpath = sunBootClasspath + separator + classpath;
        }
        if (!System.getProperty("java.version").startsWith("1.") && new File(jrtClasspath = (javaHome = System.getProperty("java.home")) + File.separator + "lib" + File.separator + "jrt-fs.jar").exists()) {
            classpath = jrtClasspath + separator + classpath;
        }
        if ("\\".equals(File.separator)) {
            classpath = classpath.replaceAll("\\\\", "/");
        }
    }
}

