/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.PrintStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import weblogic.utils.DebugCategory;

public final class Debug {
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = Logger.getLogger("weblogic.utils.Debug");
    private static final PrintStream out = System.out;
    public static boolean verboseMethods = false;
    public static boolean showLineNumbers = false;
    public static boolean addTimeStamp = false;
    private static final Hashtable categories;

    private Debug() {
    }

    public static void assertion(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Assertion violated");
        }
    }

    public static void assertion(boolean condition, String message) {
        if (!condition) {
            throw new AssertionError((Object)message);
        }
    }

    public static void say(String msg) {
        out.println((addTimeStamp ? "" + new Date() : "") + new StackTrace().location(0).tag(0) + msg);
    }

    public static void timestamp(String msg) {
        out.println("[" + System.currentTimeMillis() + "] " + msg);
    }

    public static void here() {
        out.println("*** " + new StackTrace().location(0).dump() + " ***");
    }

    public static String notSupported(String feature, String capability) {
        if (feature == null) {
            feature = "unknown feature";
        }
        String exceptionString = capability != null ? "The feature \"" + feature + "\" the capability " + capability + " is not supported in " + new StackTrace().location(0).dump() : "The feature \"" + feature + "\" is not supported in " + new StackTrace().location(0).dump();
        return exceptionString;
    }

    public static void stackdump() {
        Debug.stackdump("Stack dump:");
    }

    public static void stackdump(String msg) {
        new StackTrace().dump(out, msg);
    }

    public static void caller(int level) {
        String caller = null;
        try {
            caller = new StackTrace().location(level).caller();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        out.println("caller(" + level + ") => " + caller);
    }

    public static void begin(String msg) {
        out.print(msg + " ... ");
        out.flush();
    }

    public static void ok() {
        out.println("ok.");
    }

    public static DebugCategory getCategory(String aName) {
        DebugCategory category = (DebugCategory)categories.get(aName);
        if (category != null) {
            return category;
        }
        category = new DebugCategory(aName);
        categories.put(aName, category);
        String envVal = null;
        try {
            String prop = System.getProperty(aName);
            if (prop != null && !prop.equalsIgnoreCase("false")) {
                category.setEnabled(true);
            }
            envVal = System.getProperty("weblogic.Debug");
        }
        catch (Exception prop) {
            // empty catch block
        }
        if (envVal != null) {
            StringTokenizer strtok = new StringTokenizer(envVal, ",");
            while (strtok.hasMoreTokens()) {
                try {
                    String catName = strtok.nextToken().trim();
                    int eqPos = catName.indexOf("=");
                    if (eqPos != -1) {
                        catName = catName.substring(0, eqPos).trim();
                    }
                    if (!catName.equals(aName) || category.isEnabled()) continue;
                    category.setEnabled(true);
                }
                catch (NoSuchElementException noSuchElementException) {
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            }
        }
        return category;
    }

    public static void attributeChangeNotification(String aName, Object aOldValue, Object aNewValue) {
        DebugCategory category = Debug.getCategory(aName);
        if (aNewValue != null && aNewValue instanceof Boolean) {
            category.setEnabled((Boolean)aNewValue);
        }
    }

    static {
        try {
            verboseMethods = Boolean.getBoolean("debug.methodNames");
            showLineNumbers = Boolean.getBoolean("debug.lineNumbers");
            addTimeStamp = Boolean.getBoolean("debug.addTimeStamp");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        categories = new Hashtable();
    }

    static final class StackTrace {
        private final Location[] stack;

        StackTrace() {
            StackTraceElement[] elements = new Exception().getStackTrace();
            this.stack = new Location[elements.length - 2];
            for (int i = 2; i < elements.length; ++i) {
                this.stack[i - 2] = new Location(elements[i]);
            }
        }

        public Location location(int level) throws ArrayIndexOutOfBoundsException {
            return this.stack[level];
        }

        public void dump(PrintStream out, String msg) {
            out.println(msg);
            for (int i = 0; i < this.stack.length; ++i) {
                out.flush();
                out.println("  " + this.location(i).dump());
            }
        }
    }

    static final class Location {
        private static final String UNKNOWN = "<unknown>";
        private final String pkg;
        private final String clazz;
        private final String method;
        private final String linenum;
        private final String fullClass;
        private final String sourcefile;

        Location(StackTraceElement element) {
            this.fullClass = element.getClassName();
            this.method = element.getMethodName();
            int end = this.fullClass.lastIndexOf(".");
            if (end == -1) {
                this.pkg = UNKNOWN;
                this.clazz = this.fullClass;
            } else {
                this.pkg = this.fullClass.substring(0, end);
                this.clazz = this.fullClass.substring(end + 1);
            }
            this.sourcefile = element.getFileName();
            int line = element.getLineNumber();
            this.linenum = line > 0 ? String.valueOf(line) : UNKNOWN;
        }

        public String tag(int level) {
            return "[" + this.clazz + (verboseMethods ? "." + this.method + "()" : "") + (showLineNumbers ? " - " + this.linenum : "") + "] " + (level != 0 ? "(" + level + ")" : "") + ": ";
        }

        public String dump() {
            return this.fullname() + '(' + this.sourcefile + ':' + this.linenum + ')';
        }

        public String caller() {
            return this.fullname() + "(), line " + this.linenum;
        }

        private String fullname() {
            return this.fullClass + '.' + this.method;
        }
    }
}

