/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Executable {
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = Logger.getLogger("weblogic.utils.Executable");
    private Process process;
    private OutputStream stdout = System.out;
    private OutputStream stderr = System.out;
    private InputStream stdin = null;
    private String path = System.getProperty("java.library.path");
    private String pathSeparator = System.getProperty("path.separator");
    private CharArrayWriter outwriter;
    private CharArrayWriter errwriter;
    private static boolean isOpenVMS = false;

    public Executable() {
    }

    public Executable(OutputStream out) {
        this.stdout = out;
        this.stderr = out;
    }

    public Executable(OutputStream out, OutputStream err) {
        this.stdout = out;
        this.stderr = err;
    }

    public final void setStdout(OutputStream os) {
        this.stdout = os;
    }

    public final void setStderr(OutputStream os) {
        this.stderr = os;
    }

    public final void setStdin(InputStream is) {
        this.stdin = is;
    }

    public final void setErrwriter(CharArrayWriter ew) {
        this.errwriter = ew;
    }

    public final void setUseCharWriter(CharArrayWriter ow, CharArrayWriter ew) {
        this.outwriter = ow;
        this.errwriter = ew;
    }

    public final synchronized boolean exec(String[] args) {
        return this.exec(args, null);
    }

    public final synchronized boolean exec(String[] arg, String[] env) {
        return this.exec(arg, env, null);
    }

    public final synchronized boolean exec(String[] arg, String[] env, File workingDir) {
        boolean result;
        try {
            if (isOpenVMS && arg[0].equals("javac")) {
                String vmsArgFileName = "vmsargs" + Double.toString(Math.random()).substring(2) + ".txt";
                PrintWriter out = new PrintWriter(new FileOutputStream("WEBLOGIC_BIN/" + vmsArgFileName, false));
                for (int j = 1; j < arg.length; ++j) {
                    out.println(arg[j]);
                }
                out.close();
                String[] vmsargs = new String[]{"WEBLOGIC_BIN:vms_javac.com", vmsArgFileName};
                this.process = Runtime.getRuntime().exec(vmsargs, env, workingDir);
            } else {
                arg[0] = this.resolveExecutable(arg[0]);
                this.process = Runtime.getRuntime().exec(arg, env, workingDir);
            }
        }
        catch (IOException ioe) {
            try {
                if (this.outwriter == null) {
                    ByteArrayOutputStream ostr = new ByteArrayOutputStream();
                    ioe.printStackTrace(new PrintStream(ostr));
                    this.stdout.write(ostr.toByteArray());
                } else {
                    CharArrayWriter in = new CharArrayWriter();
                    ioe.printStackTrace(new PrintWriter(in));
                    this.outwriter.write(in.toString());
                }
            }
            catch (IOException in) {
                // empty catch block
            }
            return false;
        }
        if (this.stdin != null) {
            OutputStream procOut = this.process.getOutputStream();
            try {
                int c;
                while ((c = this.stdin.read()) != -1) {
                    procOut.write(c);
                }
                procOut.flush();
            }
            catch (IOException e) {
                this.handleIOException(e);
            }
        }
        Drainer outthread = this.outwriter == null ? new Drainer(this.process.getInputStream(), this.stdout) : new Drainer(this.process.getInputStream(), this.outwriter);
        Drainer errthread = this.errwriter == null ? new Drainer(this.process.getErrorStream(), this.stderr) : new Drainer(this.process.getErrorStream(), this.errwriter);
        outthread.start();
        errthread.start();
        try {
            this.process.getOutputStream().close();
        }
        catch (IOException vmsargs) {
            // empty catch block
        }
        try {
            result = this.process.waitFor() == 0;
            outthread.join();
            errthread.join();
        }
        catch (InterruptedException ie) {
            LOGGER.log(Level.WARNING, "", ie);
            result = false;
        }
        return result;
    }

    public int getExitValue() throws InterruptedException {
        return this.process.exitValue();
    }

    public void setPath(String path) {
        this.path = path;
    }

    private String resolveExecutable(String cmd) {
        File f = new File(cmd);
        if (f.exists()) {
            return cmd;
        }
        StringTokenizer st = new StringTokenizer(this.path, this.pathSeparator);
        while (st.hasMoreTokens()) {
            File dir = new File(st.nextToken());
            f = new File(dir, cmd);
            if (f.exists() && f.isFile()) {
                return f.getAbsolutePath();
            }
            f = new File(dir, cmd + ".exe");
            if (!f.exists() || !f.isFile()) continue;
            return f.getAbsolutePath();
        }
        return cmd;
    }

    protected void handleIOException(IOException ioe) {
        ioe.printStackTrace();
    }

    static {
        if (0 == System.getProperty("os.name").compareTo("OpenVMS")) {
            isOpenVMS = true;
        }
    }

    private class Drainer
    extends Thread {
        private OutputStream out;
        private InputStream in;
        private CharArrayWriter writer;

        Drainer(InputStream i, OutputStream o) {
            this.in = i;
            this.out = o;
        }

        Drainer(InputStream i, CharArrayWriter w) {
            this.in = i;
            this.writer = w;
        }

        @Override
        public void run() {
            if (this.writer == null) {
                BufferedInputStream bis = new BufferedInputStream(this.in);
                try {
                    int c;
                    while ((c = bis.read()) != -1) {
                        this.out.write(c);
                    }
                    this.out.flush();
                }
                catch (IOException ioe) {
                    Executable.this.handleIOException(ioe);
                }
            } else {
                InputStreamReader isd = new InputStreamReader(this.in);
                try {
                    int c;
                    while ((c = isd.read()) != -1) {
                        this.writer.write(c);
                    }
                }
                catch (Exception e) {
                    try {
                        if (isd != null) {
                            isd.close();
                        }
                        this.writer.close();
                    }
                    catch (IOException ioe) {
                        Executable.this.handleIOException(ioe);
                    }
                }
            }
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

