/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import weblogic.utils.ArrayUtils;
import weblogic.utils.Hex;
import weblogic.utils.StringUtils;
import weblogic.utils.io.StreamUtils;

public final class FileUtils {
    private static final int SUFFIX_LENGTH = 4;
    private static final int MAX_FILENAME_LENGTH = 100;
    public static final FileFilter STAR = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return true;
        }
    };
    public static final FileFilter DIR = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }
    };
    private static Random rand = new Random();
    private static int counter = rand.nextInt() & 0xFFFF;

    private FileUtils() {
    }

    public static FileFilter makeExtensionFilter(final String extension) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isDirectory() && f.getName().endsWith(extension);
            }
        };
    }

    public static FileFilter makeExtensionFilter(final String[] extensions) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return false;
                }
                for (int i = 0; i < extensions.length; ++i) {
                    if (!f.getName().endsWith(extensions[i])) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static File[] splitPath(String path) {
        String[] dirs = StringUtils.splitCompletely(path, File.pathSeparator);
        File[] pathdirs = new File[dirs.length];
        for (int i = 0; i < dirs.length; ++i) {
            pathdirs[i] = new File(dirs[i]);
        }
        return pathdirs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long computeCRC(File source) throws IOException {
        CRC32 crc = new CRC32();
        try (FilterInputStream cis = null;){
            cis = new CheckedInputStream(new FileInputStream(source), crc);
            byte[] buf = new byte[1024];
            int i = 0;
            while (i != -1) {
                i = cis.read(buf);
            }
            long l = crc.getValue();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(InputStream i, File to) throws IOException {
        String parent = to.getParent();
        if (parent != null) {
            File dir = new File(parent);
            dir.mkdirs();
        }
        try (FileOutputStream o = new FileOutputStream(to);){
            StreamUtils.writeTo(i, o);
            o.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(FileInputStream i, File to) throws IOException {
        String parent = to.getParent();
        if (parent != null) {
            File dir = new File(parent);
            dir.mkdirs();
        }
        try (FileOutputStream o = new FileOutputStream(to);){
            FileChannel inc = i.getChannel();
            FileChannel outc = o.getChannel();
            inc.transferTo(0L, inc.size(), outc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(byte[] bytes, String fileName) throws IOException {
        File dir;
        File to = new File(fileName);
        String path = to.getParent();
        if (path != null && !(dir = new File(path)).exists()) {
            dir.mkdirs();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(to);
            fos.write(bytes);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void copy(File fromFileOrDirectory, File toFileOrDirectory) throws IOException {
        FileUtils.copy(fromFileOrDirectory, toFileOrDirectory, true, null);
    }

    public static void copy(File fromFileOrDirectory, File toFileOrDirectory, Set exclude) throws IOException {
        FileUtils.copy(fromFileOrDirectory, toFileOrDirectory, true, exclude);
    }

    public static void copyPreservePermissions(File fromFileOrDirectory, File toFileOrDirectory) throws IOException {
        FileUtils.copy(fromFileOrDirectory, toFileOrDirectory, true, null, false, true);
    }

    public static void copyPreservePermissions(File fromFileOrDirectory, File toFileOrDirectory, Set exclude) throws IOException {
        FileUtils.copy(fromFileOrDirectory, toFileOrDirectory, true, exclude, false, true);
    }

    public static void copyPreserveTimestamps(File fromFileOrDirectory, File toFileOrDirectory) throws IOException {
        FileUtils.copy(fromFileOrDirectory, toFileOrDirectory, true, null, true, false);
    }

    public static void copyPreserveTimestampsPreservePermissions(File fromFileOrDirectory, File toFileOrDirectory) throws IOException {
        FileUtils.copy(fromFileOrDirectory, toFileOrDirectory, true, null, true, true);
    }

    public static void copyNoOverwrite(File fromFileOrDirectory, File toFileOrDirectory) throws IOException {
        FileUtils.copy(fromFileOrDirectory, toFileOrDirectory, false, null);
    }

    public static void copyNoOverwrite(File fromFileOrDirectory, File toFileOrDirectory, Set exclude) throws IOException {
        FileUtils.copy(fromFileOrDirectory, toFileOrDirectory, false, exclude);
    }

    public static void copyNoOverwritePreservePermissions(File fromFileOrDirectory, File toFileOrDirectory) throws IOException {
        FileUtils.copy(fromFileOrDirectory, toFileOrDirectory, false, null, false, true);
    }

    public static void copyNoOverwritePreservePermissions(File fromFileOrDirectory, File toFileOrDirectory, Set exclude) throws IOException {
        FileUtils.copy(fromFileOrDirectory, toFileOrDirectory, false, exclude, false, true);
    }

    private static void copy(File fromFileOrDirectory, File toFileOrDirectory, boolean overwrite, Set exclude) throws IOException {
        FileUtils.copy(fromFileOrDirectory, toFileOrDirectory, overwrite, exclude, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File fromFileOrDirectory, File toFileOrDirectory, boolean overwrite, Set exclude, boolean preserveTimestamps, boolean preservePermissions) throws IOException {
        if (exclude != null && exclude.contains(fromFileOrDirectory)) {
            return;
        }
        if (!fromFileOrDirectory.isDirectory()) {
            File toFile = null;
            try (InputStream i = null;){
                toFile = toFileOrDirectory;
                if (toFileOrDirectory.isDirectory()) {
                    toFile = new File(toFileOrDirectory, fromFileOrDirectory.getName());
                }
                if (!overwrite && toFile.exists()) {
                    return;
                }
                i = new FileInputStream(fromFileOrDirectory);
                FileUtils.writeToFile(i, toFile);
            }
            if (preservePermissions) {
                FileUtils.setPosixFilePermissions(toFile, FileUtils.getPosixFilePermissions(fromFileOrDirectory));
            }
        } else {
            if (toFileOrDirectory.exists()) {
                if (!toFileOrDirectory.isDirectory()) {
                    throw new IOException("Target for directory copy is a file");
                }
            } else {
                toFileOrDirectory.mkdirs();
            }
            File[] files = FileUtils.listFiles(fromFileOrDirectory);
            for (int i = 0; i < files.length; ++i) {
                File newFrom = files[i];
                File newTo = new File(toFileOrDirectory, newFrom.getName());
                FileUtils.copy(newFrom, newTo, overwrite, exclude, preserveTimestamps, preservePermissions);
            }
        }
        if (preserveTimestamps) {
            toFileOrDirectory.setLastModified(fromFileOrDirectory.lastModified());
        }
    }

    public static boolean remove(File directory, FileFilter match) {
        boolean returnIsSuccess = true;
        if (!directory.exists()) {
            return returnIsSuccess;
        }
        File[] files = directory.listFiles(match);
        if (files == null && !directory.exists()) {
            return returnIsSuccess;
        }
        if (files == null) {
            throw new RuntimeException("Error enumerating directory \"" + directory.getPath() + "\"; please check its ownership and permissions.");
        }
        for (int i = 0; i < files.length; ++i) {
            boolean isEachFileSuccess;
            File f = files[i];
            if (!f.exists()) continue;
            boolean bl = isEachFileSuccess = f.isDirectory() ? FileUtils.remove(f) : f.delete();
            if (!returnIsSuccess || isEachFileSuccess) continue;
            returnIsSuccess = false;
        }
        return returnIsSuccess;
    }

    public static boolean remove(File fileOrDirectory) {
        boolean returnIsSuccess = fileOrDirectory.isDirectory() ? FileUtils.remove(fileOrDirectory, STAR) : true;
        return fileOrDirectory.delete() ? returnIsSuccess : false;
    }

    public static File[] find(File directory, FileFilter match) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " is not a directory.");
        }
        ArrayList<File> result = new ArrayList<File>();
        File[] files = FileUtils.listFiles(directory);
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                ArrayUtils.addAll(result, FileUtils.find(f, match));
            }
            if (!match.accept(f)) continue;
            result.add(f);
        }
        return result.toArray(new File[result.size()]);
    }

    public static long getAbsoluteLastModified(File aFile) {
        long result = aFile.lastModified();
        if (!aFile.isDirectory()) {
            return result;
        }
        File[] children = FileUtils.listFiles(aFile);
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            long childTime = FileUtils.getAbsoluteLastModified(child);
            if (childTime <= result) continue;
            result = childTime;
        }
        return result;
    }

    public static File createTempDir(String prefix) throws IOException {
        return FileUtils.createTempDir(prefix, null);
    }

    public static File createTempDir(String prefix, File directory) throws IOException {
        File f;
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (directory == null) {
            f = File.createTempFile("fileutils", null);
            directory = f.getParentFile();
            f.delete();
        }
        while (!(f = new File(directory, prefix + ++counter)).mkdirs()) {
        }
        return f;
    }

    public static FileLock getFileLock(FileChannel c, long timeoutInMillis) throws IOException {
        long currentTime = System.currentTimeMillis();
        long timeoutTime = currentTime + timeoutInMillis;
        FileLock fileLock = null;
        while (fileLock == null && currentTime <= timeoutTime) {
            try {
                fileLock = c.tryLock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                // empty catch block
            }
            if (fileLock != null) continue;
            long remainingTime = timeoutTime - currentTime;
            try {
                Thread.sleep(remainingTime > 500L ? 500L : remainingTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            currentTime = System.currentTimeMillis();
        }
        return fileLock;
    }

    public static FileLock getSharedFileLock(FileChannel c, long timeoutInMillis) throws IOException {
        long currentTime = System.currentTimeMillis();
        long timeoutTime = currentTime + timeoutInMillis;
        FileLock fileLock = null;
        while (fileLock == null && currentTime <= timeoutTime) {
            try {
                fileLock = c.tryLock(0L, Long.MAX_VALUE, true);
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                // empty catch block
            }
            if (fileLock != null) continue;
            long remainingTime = timeoutTime - currentTime;
            try {
                Thread.sleep(remainingTime > 500L ? 500L : remainingTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            currentTime = System.currentTimeMillis();
        }
        return fileLock;
    }

    public static String mapNameToFileName(String name) {
        return FileUtils.mapNameToFileName(name, true);
    }

    public static String mapNameToFileName(String name, boolean mapUpperCase) {
        byte[] bytes = null;
        try {
            bytes = name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            bytes = name.getBytes();
        }
        byte[] filenameBuf = new byte[1024];
        int pos = 0;
        boolean suffixRequired = false;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] >= 97 && bytes[i] <= 122 || bytes[i] >= 48 && bytes[i] <= 57 || bytes[i] == 45 || bytes[i] == 95 || bytes[i] == 43 || bytes[i] == 36) {
                filenameBuf[pos++] = bytes[i];
                continue;
            }
            if (bytes[i] >= 65 && bytes[i] <= 90) {
                filenameBuf[pos++] = bytes[i];
                if (!mapUpperCase) continue;
                suffixRequired = true;
                continue;
            }
            if (bytes[i] == 32) {
                filenameBuf[pos++] = 95;
                suffixRequired = true;
                continue;
            }
            suffixRequired = true;
            String hex = Hex.asHex(bytes[i]);
            byte[] hexBytes = hex.getBytes();
            System.arraycopy(hexBytes, 0, filenameBuf, pos, hexBytes.length);
            pos += hexBytes.length;
        }
        String filename = new String(filenameBuf, 0, pos);
        if (filename.length() > 100) {
            filename = filename.substring(0, 99);
            suffixRequired = true;
        }
        if (suffixRequired) {
            String hashSuffix = "" + name.hashCode();
            if (hashSuffix.length() > 4) {
                hashSuffix = hashSuffix.substring(hashSuffix.length() - 4);
            }
            return filename + "-" + hashSuffix;
        }
        return filename;
    }

    public static boolean isAbsolute(File f) {
        if (f == null || f.getPath().length() == 0) {
            return false;
        }
        return f.isAbsolute() || f.getPath().startsWith("/") || f.getPath().startsWith("\\") || FileUtils.testDriveSpecifier(f);
    }

    public static long getLastModified(File fileOrDir) {
        long lastModified = fileOrDir.lastModified();
        if (!fileOrDir.isDirectory()) {
            return lastModified;
        }
        File[] allFiles = fileOrDir.listFiles();
        if (allFiles == null || allFiles.length == 0) {
            return lastModified;
        }
        for (int i = 0; i < allFiles.length; ++i) {
            long eachLastModified = FileUtils.getLastModified(allFiles[i]);
            if (eachLastModified <= lastModified) continue;
            lastModified = eachLastModified;
        }
        return lastModified;
    }

    private static boolean testDriveSpecifier(File f) {
        String s = f.getPath();
        return s.length() > 2 && (s.charAt(1) == ':' && s.charAt(2) == '\\' || s.charAt(2) == '/');
    }

    public static String getPosixFilePermissions(File f) {
        if (f == null) {
            return null;
        }
        try {
            Set<PosixFilePermission> sp = Files.getPosixFilePermissions(f.toPath(), new LinkOption[0]);
            if (sp != null) {
                int owner = 0;
                int group = 0;
                int others = 0;
                for (PosixFilePermission fp : sp) {
                    switch (fp) {
                        case OWNER_READ: {
                            owner += 4;
                            break;
                        }
                        case OWNER_WRITE: {
                            owner += 2;
                            break;
                        }
                        case OWNER_EXECUTE: {
                            ++owner;
                            break;
                        }
                        case GROUP_READ: {
                            group += 4;
                            break;
                        }
                        case GROUP_WRITE: {
                            group += 2;
                            break;
                        }
                        case GROUP_EXECUTE: {
                            ++group;
                            break;
                        }
                        case OTHERS_READ: {
                            others += 4;
                            break;
                        }
                        case OTHERS_WRITE: {
                            others += 2;
                            break;
                        }
                        case OTHERS_EXECUTE: {
                            ++others;
                        }
                    }
                }
                StringBuffer perms = new StringBuffer();
                perms.append(String.valueOf(owner));
                perms.append(String.valueOf(group));
                perms.append(String.valueOf(others));
                return perms.toString();
            }
        }
        catch (IOException | UnsupportedOperationException exception) {
            // empty catch block
        }
        return null;
    }

    public static void setPosixFilePermissions(File f, String perms) {
        if (f != null && perms != null) {
            int length = perms.length();
            int others = Integer.parseInt(perms.substring(length - 1));
            int group = Integer.parseInt(perms.substring(length - 2, length - 1));
            int owner = Integer.parseInt(perms.substring(length - 3, length - 2));
            HashSet<PosixFilePermission> sp = new HashSet<PosixFilePermission>();
            switch (owner) {
                case 1: {
                    sp.add(PosixFilePermission.OWNER_EXECUTE);
                    break;
                }
                case 2: {
                    sp.add(PosixFilePermission.OWNER_WRITE);
                    break;
                }
                case 3: {
                    sp.add(PosixFilePermission.OWNER_EXECUTE);
                    sp.add(PosixFilePermission.OWNER_WRITE);
                    break;
                }
                case 4: {
                    sp.add(PosixFilePermission.OWNER_READ);
                    break;
                }
                case 5: {
                    sp.add(PosixFilePermission.OWNER_EXECUTE);
                    sp.add(PosixFilePermission.OWNER_READ);
                    break;
                }
                case 6: {
                    sp.add(PosixFilePermission.OWNER_WRITE);
                    sp.add(PosixFilePermission.OWNER_READ);
                    break;
                }
                case 7: {
                    sp.add(PosixFilePermission.OWNER_EXECUTE);
                    sp.add(PosixFilePermission.OWNER_WRITE);
                    sp.add(PosixFilePermission.OWNER_READ);
                }
            }
            switch (group) {
                case 1: {
                    sp.add(PosixFilePermission.GROUP_EXECUTE);
                    break;
                }
                case 2: {
                    sp.add(PosixFilePermission.GROUP_WRITE);
                    break;
                }
                case 3: {
                    sp.add(PosixFilePermission.GROUP_EXECUTE);
                    sp.add(PosixFilePermission.GROUP_WRITE);
                    break;
                }
                case 4: {
                    sp.add(PosixFilePermission.GROUP_READ);
                    break;
                }
                case 5: {
                    sp.add(PosixFilePermission.GROUP_EXECUTE);
                    sp.add(PosixFilePermission.GROUP_READ);
                    break;
                }
                case 6: {
                    sp.add(PosixFilePermission.GROUP_WRITE);
                    sp.add(PosixFilePermission.GROUP_READ);
                    break;
                }
                case 7: {
                    sp.add(PosixFilePermission.GROUP_EXECUTE);
                    sp.add(PosixFilePermission.GROUP_WRITE);
                    sp.add(PosixFilePermission.GROUP_READ);
                }
            }
            switch (others) {
                case 1: {
                    sp.add(PosixFilePermission.OTHERS_EXECUTE);
                    break;
                }
                case 2: {
                    sp.add(PosixFilePermission.OTHERS_WRITE);
                    break;
                }
                case 3: {
                    sp.add(PosixFilePermission.OTHERS_EXECUTE);
                    sp.add(PosixFilePermission.OTHERS_WRITE);
                    break;
                }
                case 4: {
                    sp.add(PosixFilePermission.OTHERS_READ);
                    break;
                }
                case 5: {
                    sp.add(PosixFilePermission.OTHERS_EXECUTE);
                    sp.add(PosixFilePermission.OTHERS_READ);
                    break;
                }
                case 6: {
                    sp.add(PosixFilePermission.OTHERS_WRITE);
                    sp.add(PosixFilePermission.OTHERS_READ);
                    break;
                }
                case 7: {
                    sp.add(PosixFilePermission.OTHERS_EXECUTE);
                    sp.add(PosixFilePermission.OTHERS_WRITE);
                    sp.add(PosixFilePermission.OTHERS_READ);
                }
            }
            try {
                Files.setPosixFilePermissions(f.toPath(), sp);
            }
            catch (IOException | UnsupportedOperationException e) {
                f.setWritable(sp.contains((Object)PosixFilePermission.OWNER_WRITE), !sp.contains((Object)PosixFilePermission.GROUP_WRITE));
                f.setReadable(sp.contains((Object)PosixFilePermission.OWNER_READ), !sp.contains((Object)PosixFilePermission.GROUP_READ));
                f.setExecutable(sp.contains((Object)PosixFilePermission.OWNER_EXECUTE), !sp.contains((Object)PosixFilePermission.GROUP_EXECUTE));
            }
        }
    }

    public static String normalize(String dir) {
        if (dir == null) {
            return dir;
        }
        if ("/".equals(File.separator)) {
            if (dir.length() >= 2 && dir.charAt(1) == ':') {
                dir = dir.substring(2);
            }
            return dir.replace('\\', File.separatorChar);
        }
        return dir.replace('/', File.separatorChar);
    }

    public static byte[] readBytes(File file) throws IOException {
        try (FileInputStream in = null;){
            in = new FileInputStream(file);
            byte[] byArray = FileUtils.readBytes(in);
            return byArray;
        }
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        byte[] tmpBuf = new byte[8192];
        return FileUtils.readBytes(in, tmpBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream in, byte[] tmpBuf) throws IOException {
        byte[] bytes = null;
        if (in == null) {
            return null;
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int n = 0;
            while ((n = in.read(tmpBuf)) >= 0) {
                if (n <= 0) continue;
                bos.write(tmpBuf, 0, n);
            }
            bos.flush();
            bytes = bos.toByteArray();
        }
        return bytes;
    }

    public static String getParent(String path) throws IOException {
        File file = new File(path);
        return file.getParentFile().getCanonicalPath();
    }

    public static boolean isSameFile(String path1, String path2) {
        File file1 = new File(path1);
        File file2 = new File(path2);
        try {
            String canonicalPath1 = file1.getCanonicalPath();
            String canonicalPath2 = file2.getCanonicalPath();
            if (canonicalPath1 == null) {
                return canonicalPath2 == null;
            }
            return canonicalPath1.equals(canonicalPath2);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private static File[] listFiles(File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            String dirPath;
            try {
                dirPath = directory.getCanonicalPath();
            }
            catch (IOException ioe) {
                dirPath = directory.toString();
            }
            throw new AssertionError((Object)(dirPath + " exists but it's not accessible. Usually, this problem happens when permission is not correct."));
        }
        return files;
    }
}

