/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.util.HashMap;
import java.util.Map;
import weblogic.utils.LocatorUtilities;

public class GenericLocatorUtilities {
    private static Map<String, String> thinT3ClientLocatorMap = new HashMap<String, String>();
    private static boolean isThinT3Client;

    public static <T> T getService(Class<T> serviceClass) {
        if (isThinT3Client) {
            return GenericLocatorUtilities.getService(serviceClass.getName());
        }
        return (T)LocatorUtilities.getService(serviceClass);
    }

    private static <T> T getService(String serviceName) {
        try {
            return (T)Class.forName(thinT3ClientLocatorMap.get(serviceName)).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    static {
        thinT3ClientLocatorMap.put("weblogic.security.acl.SecurityServiceGenerator", "weblogic.common.internal.SecurityServiceGeneratorImpl");
        thinT3ClientLocatorMap.put("weblogic.jndi.Environment", "weblogic.jndi.Environment");
        thinT3ClientLocatorMap.put("weblogic.rmi.facades.RmiInvocationFacade", "weblogic.rmi.facades.ClientRmiInvocationFacade");
        thinT3ClientLocatorMap.put("weblogic.security.shared.RuntimeUtilities", "weblogic.security.notshared.RuntimeUtilitiesImpl");
        try {
            isThinT3Client = Class.forName("weblogic.rmi.internal.wls.WLSClientRMIEnvironment") != null;
        }
        catch (Exception ignore) {
            isThinT3Client = false;
        }
    }
}

