/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import weblogic.utils.AssertionError;
import weblogic.utils.BadOptionException;
import weblogic.utils.StringUtils;
import weblogic.utils.string.Sprintf;

public final class Getopt2
implements Cloneable {
    public static final boolean debug = false;
    private static final int ARG = 0;
    private static final int BOOL_FLAG = 1;
    private static final int ARG_FLAG = 2;
    private static final int COMPOSITE = 3;
    private static final int MULTI_FLAG = 4;
    private static final int ARG_N_FLAG = 5;
    private Hashtable options = new Hashtable();
    private Vector order = new Vector();
    private Hashtable optionNameMap = new Hashtable();
    private Hashtable alias2real = new Hashtable();
    private Hashtable real2alias = new Hashtable();
    private Hashtable values = new Hashtable();
    private String[] args;
    private int numCompound = 0;
    private boolean failOnUnrecognizedOpts = false;
    private static final String EOL = System.getProperty("line.separator");
    private String usageFooter = null;
    private String usageHeader = null;
    private String java = "java";
    private String usageArgs = null;
    private Properties defaults = new Properties();

    public Getopt2() {
        this.addFlag("gui", "Brings up a UI to edit the command line");
        this.markPrivate("gui");
        this.addOption("script", "script filename", "This loads command line arguments from a properties file");
        this.markPrivate("script");
        this.addOption("savescript", "script filename", "This saves command line arguments to a properties file");
        this.markPrivate("savescript");
    }

    public void setFailOnUnrecognizedOpts(boolean v) {
        this.failOnUnrecognizedOpts = v;
    }

    public String asCommandLine() {
        return this.asCommandLine(null, null);
    }

    public String[] asCommandArray() {
        return this.asCommandArray(null, null);
    }

    public String asCommandLine(String desc) {
        return this.asCommandLine(null, desc);
    }

    public String[] asCommandArray(String desc) {
        return this.asCommandArray(null, desc);
    }

    public String argsToString() {
        return StringUtils.join(this.args, " ");
    }

    public Object clone() {
        try {
            Getopt2 returnOpts = (Getopt2)super.clone();
            returnOpts.options = this.options != null ? (Hashtable)this.options.clone() : null;
            returnOpts.order = this.order != null ? (Vector)this.order.clone() : null;
            returnOpts.optionNameMap = this.optionNameMap != null ? (Hashtable)this.optionNameMap.clone() : null;
            returnOpts.alias2real = this.alias2real != null ? (Hashtable)this.alias2real.clone() : null;
            returnOpts.real2alias = this.real2alias != null ? (Hashtable)this.real2alias.clone() : null;
            returnOpts.values = this.values != null ? (Hashtable)this.values.clone() : null;
            returnOpts.numCompound = this.numCompound;
            returnOpts.failOnUnrecognizedOpts = this.failOnUnrecognizedOpts;
            if (this.args != null) {
                returnOpts.args = new String[this.args.length];
                System.arraycopy(this.args, 0, returnOpts.args, 0, this.args.length);
            } else {
                returnOpts.args = null;
            }
            return returnOpts;
        }
        catch (CloneNotSupportedException cnse) {
            throw new AssertionError("Clone not supported due to -- " + cnse.getMessage());
        }
    }

    public Getopt2 grok(String[] argv) throws IllegalArgumentException {
        Vector<String> paramsV = new Vector<String>();
        block14: for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            Option opt = null;
            String key = null;
            String name = null;
            if (arg.startsWith("-")) {
                name = arg.substring(1);
                key = this.resolveName(name);
                if (key != null) {
                    opt = (Option)this.options.get(key);
                } else if (this.failOnUnrecognizedOpts) {
                    throw new IllegalArgumentException("Unrecognized option or flag, " + arg);
                }
            }
            if (opt == null) {
                if (arg.trim().equals("")) continue;
                paramsV.addElement(arg);
                continue;
            }
            switch (opt.type) {
                case 0: {
                    try {
                        opt.value = argv[++i];
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        throw new IllegalArgumentException("Expecting arg after " + arg);
                    }
                    this.values.put(key, opt);
                    continue block14;
                }
                case 1: {
                    opt.value = "true";
                    this.values.put(key, opt);
                    continue block14;
                }
                case 2: {
                    opt.value = name.substring(key.length());
                    this.values.put(key, opt);
                    continue block14;
                }
                case 3: {
                    Option o = (Option)this.values.get("compiler");
                    if (o != null && o.value.indexOf("javac") < 0 && o.value.indexOf("sj") < 0) {
                        Option o2 = (Option)this.values.get(key);
                        opt.value = o2 != null && o2.value != null ? o2.value + " " + name.substring(1) : name.substring(1);
                        this.values.put(key, opt);
                        continue block14;
                    }
                    if (name.length() == key.length()) {
                        throw new IllegalArgumentException(name + " needs a valid option.");
                    }
                    String value = name.substring(key.length());
                    if (!value.startsWith("-")) {
                        value = "-" + value;
                    }
                    opt.subOptArgs.addElement(value);
                    String subKey = opt.subOpt.resolveName(value.substring(1));
                    if (subKey == null) {
                        throw new IllegalArgumentException(name + " isn't a valid flag option.");
                    }
                    Option so = (Option)opt.subOpt.options.get(subKey);
                    if (so != null && so.type == 0) {
                        try {
                            opt.subOptArgs.addElement(argv[++i]);
                        }
                        catch (ArrayIndexOutOfBoundsException aioobe) {
                            throw new IllegalArgumentException("Expecting arg after " + arg);
                        }
                    }
                    this.values.put(key, opt);
                    continue block14;
                }
                case 4: {
                    opt.multiValue.addElement(argv[++i]);
                    continue block14;
                }
                case 5: {
                    try {
                        for (int j = 0; j < opt.multiArgCount; ++j) {
                            opt.multiValue.addElement(argv[++i]);
                        }
                        continue block14;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        throw new IllegalArgumentException("Expecting arg after " + arg);
                    }
                }
            }
        }
        this.args = new String[paramsV.size()];
        paramsV.copyInto(this.args);
        Enumeration kids = this.options.elements();
        while (kids.hasMoreElements()) {
            Option k = (Option)kids.nextElement();
            if (k.type != 3) continue;
            Object[] ss = new String[k.subOptArgs.size()];
            k.subOptArgs.copyInto(ss);
            k.subOpt.grok((String[])ss);
        }
        if (this.hasOption("script")) {
            this.loadScript(this.getOption("script"));
        }
        if (this.hasOption("gui")) {
            this.editor();
        }
        if (this.hasOption("savescript")) {
            this.saveScript(this.getOption("savescript"));
        }
        return this;
    }

    public boolean hasAdvancedOptions() {
        for (Option op : this.options.values()) {
            if (!op.isAdvanced || op.isPrivate) continue;
            return true;
        }
        return false;
    }

    public void addFlag(String name, String doc) {
        if (!this.options.containsKey(name)) {
            this.options.put(name, new Option(1, name, doc));
            this.optionNameMap.put(name.toLowerCase(), name);
            this.order.addElement(name);
        }
    }

    public void addAdvancedFlag(String name, String doc) {
        this.addFlag(name, doc);
        this.markAdvanced(name);
    }

    public void addOption(String name, String param, String doc) {
        if (!this.options.containsKey(name)) {
            this.options.put(name, new Option(0, name, doc, param));
            this.optionNameMap.put(name.toLowerCase(), name);
            this.order.addElement(name);
        }
    }

    public void addAdvancedOption(String name, String param, String doc) {
        this.addOption(name, param, doc);
        this.markAdvanced(name);
    }

    public void addArgFlag(String name, String param, String doc) {
        if (!this.options.containsKey(name)) {
            this.options.put(name, new Option(2, name, doc, param));
            this.optionNameMap.put(name.toLowerCase(), name);
            this.order.addElement(name);
            ++this.numCompound;
        }
    }

    public void addAdvancedArgFlag(String name, String param, String doc) {
        this.addArgFlag(name, param, doc);
        this.markAdvanced(name);
    }

    public void addMultiOption(String name, String param, String doc) {
        if (!this.options.containsKey(name)) {
            this.options.put(name, new Option(4, name, doc, param));
            this.optionNameMap.put(name.toLowerCase(), name);
            this.order.addElement(name);
            ++this.numCompound;
        }
    }

    public void addAdvancedMultiOption(String name, String param, String doc) {
        this.addMultiOption(name, param, doc);
        this.markAdvanced(name);
    }

    public void addNOption(String name, String param, int paramCount, String doc) {
        if (!this.options.containsKey(name)) {
            this.options.put(name, new Option(5, paramCount, name, param, doc));
            this.optionNameMap.put(name.toLowerCase(), name);
            this.order.addElement(name);
            ++this.numCompound;
        }
    }

    public void addAdvancedNOption(String name, String param, int paramCount, String doc) {
        this.addNOption(name, param, paramCount, doc);
        this.markAdvanced(name);
    }

    public void addSubOpt(String name, Getopt2 subOpt, String doc) {
        if (!this.options.containsKey(name)) {
            this.options.put(name, new Option(3, name, doc, null, subOpt));
            this.optionNameMap.put(name.toLowerCase(), name);
            this.order.addElement(name);
            ++this.numCompound;
        }
    }

    public void addAdvancedSubOpt(String name, Getopt2 subOpt, String doc) {
        this.addSubOpt(name, subOpt, doc);
        this.markAdvanced(name);
    }

    public void addAlias(String alias, String real) {
        this.alias2real.put(alias, real);
        this.real2alias.put(real, alias);
        this.optionNameMap.put(alias.toLowerCase(), alias);
    }

    public void markPrivate(String name) {
        ((Option)this.options.get((Object)name)).isPrivate = true;
    }

    public void markAdvanced(String name) {
        ((Option)this.options.get((Object)name)).isAdvanced = true;
    }

    public void addFlagsAndOptions(String[][] spec) {
        for (String[] s : spec) {
            if (s.length == 2) {
                this.addFlag(s[0], s[1]);
                continue;
            }
            this.addOption(s[0], s[1], s[2]);
        }
    }

    public void removeOption(String name) {
        this.optionNameMap.remove(name.toLowerCase());
        Option opt = (Option)this.options.remove(name);
        if (opt.type == 2) {
            --this.numCompound;
        }
        this.order.removeElement(name);
        this.values.remove(name);
        String alias = (String)this.real2alias.remove(name);
        if (alias != null) {
            this.alias2real.remove(alias);
        }
    }

    public void removeAlias(String alias) {
        this.optionNameMap.remove(alias.toLowerCase());
        String real = (String)this.alias2real.remove(alias);
        if (real != null) {
            this.real2alias.remove(real);
        }
    }

    public String[] args() {
        return this.args;
    }

    public boolean hasOption(String name) {
        return this.values.containsKey(this.dealias(name));
    }

    public boolean containsOption(String name) {
        if (this.values.containsKey(name)) {
            return true;
        }
        String alias = (String)this.real2alias.get(name);
        return alias != null && alias.length() > 0 && this.values.containsKey(alias);
    }

    public boolean hasOptions() {
        return !this.values.isEmpty();
    }

    public String getOption(String name) {
        return this.getOption(name, null);
    }

    public String getOption(String name, String defalt) {
        String v = this.getOptValue(name);
        return v != null ? v : defalt;
    }

    public String[] getMultiOption(String name, String[] def) {
        Object[] result = def;
        Option opt = (Option)this.options.get(this.dealias(name));
        Vector v = null;
        if (null != opt && null != (v = opt.multiValue)) {
            result = new String[v.size()];
            v.copyInto(result);
        }
        return result;
    }

    public String[] getNOption(String name, String[] def) {
        return this.getMultiOption(name, def);
    }

    public Getopt2 getSubOpt(String name) throws IllegalArgumentException {
        Option opt = (Option)this.options.get(name);
        return opt == null ? null : opt.subOpt;
    }

    public boolean getBooleanOption(String name) {
        return this.getBooleanOption(name, false);
    }

    public boolean getBooleanOption(String name, boolean defalt) {
        String v = this.getOptValue(name);
        if (v != null) {
            return Boolean.valueOf(v);
        }
        return defalt;
    }

    public int getIntegerOption(String name) throws IllegalArgumentException {
        return this.getIntegerOption(name, 0);
    }

    public int getIntegerOption(String name, int defalt) throws IllegalArgumentException {
        String v = this.getOptValue(name);
        if (v != null) {
            try {
                return Integer.decode(v);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Couldn't get integer value for " + name + ": " + nfe);
            }
        }
        return defalt;
    }

    public void setFlag(String name, boolean value) throws BadOptionException {
        Option opt = (Option)this.options.get(this.dealias(name));
        if (opt == null) {
            throw new BadOptionException("Can't set undeclared option " + name);
        }
        if (opt.type != 1) {
            throw new BadOptionException(name + " isn't a flag option.");
        }
        if (value) {
            opt.value = "true";
            this.values.put(name, opt);
        } else {
            opt.value = null;
            this.values.remove(name);
        }
    }

    public void setOption(String name, String value) throws BadOptionException {
        Option opt = (Option)this.options.get(this.dealias(name));
        if (opt == null) {
            throw new BadOptionException("Can't set undeclared option " + name);
        }
        opt.value = value;
        this.values.put(name, opt);
    }

    public void setUsageHeader(String usageHeader) {
        while (usageHeader.endsWith("\n") || usageHeader.endsWith("\r")) {
            usageHeader = usageHeader.substring(0, usageHeader.length() - 1);
        }
        this.usageHeader = usageHeader;
    }

    public String getUsageHeader() {
        return this.usageHeader;
    }

    public String getUsageArgs() {
        return this.usageArgs;
    }

    public void setUsageFooter(String uf) {
        this.usageFooter = uf;
    }

    public void setJava(String java) {
        this.java = java;
    }

    public void setUsageArgs(String usageArgs) {
        this.usageArgs = usageArgs;
    }

    public void usageError(String program) {
        System.out.println(this.fullUsageMessage(program));
    }

    public void usageError(String program, boolean advanced) {
        System.out.println(this.fullUsageMessage(program, advanced));
    }

    public void usageAndExit(String program) {
        System.err.println(this.fullUsageMessage(program));
        System.exit(1);
    }

    public void usageAndExit(String program, boolean advanced) {
        System.err.println(this.fullUsageMessage(program, advanced));
        System.exit(1);
    }

    public String fullUsageMessage(String program) {
        return this.fullUsageMessage(program, false);
    }

    public String fullUsageMessage(String program, boolean advanced) {
        StringBuffer sb = new StringBuffer();
        if (this.usageHeader != null) {
            sb.append(this.usageHeader).append(EOL).append(EOL);
        }
        sb.append("Usage: ").append(this.java).append(" ").append(program).append(" [options] ");
        if (this.usageArgs != null) {
            sb.append(this.usageArgs);
        }
        sb.append(EOL).append(EOL).append("where options include:").append(EOL).append(this.usageMessage(advanced));
        if (this.usageFooter != null) {
            sb.append(this.usageFooter);
        }
        return sb.toString();
    }

    public String usageMessage() {
        return this.usageMessage(false);
    }

    public String usageMessage(boolean advanced) {
        String eol = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        String line = "    -%-16s %-45s" + eol;
        String line2 = "%-21s %-45s" + eol;
        Object[] args = new Object[2];
        int size = this.order.size();
        for (int i = 0; i < size; ++i) {
            String name = (String)this.order.elementAt(i);
            Option opt = (Option)this.options.get(name);
            if (opt.isPrivate || opt.isAdvanced && !advanced) continue;
            String param = opt.paramName;
            String doc = opt.docString;
            args[0] = name + opt.paramString();
            int l1 = 67 - ((String)args[0]).length();
            if (l1 > 45) {
                l1 = 45;
            }
            line = "    -%-16s %-" + l1 + "s" + eol;
            if (doc.length() <= l1) {
                args[1] = doc;
                sb.append(Sprintf.sprintf(line, args));
                continue;
            }
            String front = this.getFront(doc, l1);
            args[1] = front.trim();
            sb.append(Sprintf.sprintf(line, args));
            args[0] = "";
            while (doc.length() > 0) {
                if ((front = this.getFront(doc = doc.substring(front.length()).trim(), 45)).length() <= 0) continue;
                args[1] = front;
                sb.append(Sprintf.sprintf(line2, args));
            }
        }
        return sb.toString();
    }

    private String getOptValue(String name) {
        Option opt = (Option)this.values.get(this.dealias(name));
        return opt == null ? null : opt.value;
    }

    private String getFront(String str, int len) {
        if (len > str.length()) {
            return str;
        }
        BreakIterator boundary = BreakIterator.getLineInstance();
        boundary.setText(str);
        int start = boundary.first();
        int end = boundary.next();
        while (end != len && end != -1) {
            if (end - start > len) {
                end = boundary.previous();
                break;
            }
            end = boundary.next();
        }
        if (end != 0 && str.charAt(end - 1) == '-') {
            end = boundary.previous();
        }
        return start == end ? str : str.substring(start, end);
    }

    private String resolveName(String name) {
        String lcName = name.toLowerCase();
        String optionName = (String)this.optionNameMap.get(lcName);
        if (optionName != null) {
            if (this.options.containsKey(optionName)) {
                return optionName;
            }
            String real = (String)this.alias2real.get(optionName);
            if (real != null) {
                return real;
            }
        }
        if (this.numCompound > 0) {
            Enumeration opts = this.options.elements();
            while (opts.hasMoreElements()) {
                Option o = (Option)opts.nextElement();
                String n = o.name;
                if (!lcName.startsWith(n.toLowerCase()) || o.type != 2 && o.type != 3 && o.type != 4) continue;
                return n;
            }
        }
        return null;
    }

    private String dealias(String name) {
        if (this.options.containsKey(name)) {
            return name;
        }
        String real = (String)this.alias2real.get(name);
        return real == null ? name : real;
    }

    private String[] asCommandArray(String prefix, String desc) {
        Enumeration<Object> fields = desc != null ? new StringTokenizer(desc, ",") : this.values.keys();
        ArrayList<String> args = new ArrayList<String>();
        while (fields.hasMoreElements()) {
            String name = (String)fields.nextElement();
            Option opt = (Option)this.options.get(name);
            if (prefix != null) {
                args.add("-" + prefix);
            }
            String[] argbits = opt.toArgArray();
            for (int i = 0; i < argbits.length; ++i) {
                args.add(argbits[i]);
            }
        }
        return args.toArray(new String[args.size()]);
    }

    private String asCommandLine(String prefix, String desc) {
        Enumeration<Object> fields = desc != null ? new StringTokenizer(desc, ",") : this.values.keys();
        StringBuffer sb = new StringBuffer();
        while (fields.hasMoreElements()) {
            String name = (String)fields.nextElement();
            Option opt = (Option)this.options.get(name);
            if (prefix != null) {
                sb.append("-").append(prefix);
            }
            sb.append(opt.toCommandLine());
            if (!fields.hasMoreElements()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editor() {
        int windowHeight;
        int windowWidth;
        final JFrame frame = new JFrame("Command-line Options Editor");
        final Object lock = new Object();
        frame.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent we) {
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
                frame.setVisible(false);
            }

            @Override
            public void windowClosed(WindowEvent we) {
                frame.dispose();
            }
        });
        JScrollPane pane = new JScrollPane(this.createEditPane(), 20, 30);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = (int)screen.getWidth();
        int screenHeight = (int)screen.getHeight();
        if (screenWidth >= 1600) {
            windowWidth = 1280;
            windowHeight = 1024;
        } else if (screenWidth >= 1280) {
            windowWidth = 1024;
            windowHeight = 768;
        } else if (screenWidth >= 1024) {
            windowWidth = 800;
            windowHeight = 600;
        } else if (screenWidth >= 800) {
            windowWidth = 640;
            windowHeight = 480;
        } else {
            windowWidth = 320;
            windowHeight = 240;
        }
        frame.setBounds((screenWidth - windowWidth) / 2, (screenHeight - windowHeight) / 2, windowWidth, windowHeight);
        frame.setContentPane(pane);
        frame.setVisible(true);
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.saveDefaults();
        System.out.println("Command line arguments:");
        System.out.println(this.asCommandLine());
    }

    private void loadArguments(Properties p) {
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Option option = (Option)this.options.get(key);
            try {
                if (option == null) continue;
                if (option.type == 1) {
                    this.setFlag(key, Boolean.valueOf(p.getProperty(key)));
                    continue;
                }
                this.setOption(key, p.getProperty(key));
            }
            catch (BadOptionException badOptionException) {}
        }
    }

    private void loadDefaults() {
        File defaultFile;
        File home = new File(System.getProperty("user.home"));
        if (home.exists() && (defaultFile = new File(home, ".getopt_defaults")).exists()) {
            try {
                this.defaults.load(new FileInputStream(defaultFile));
                this.loadArguments(this.defaults);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void saveDefaults() {
        File home = new File(System.getProperty("user.home"));
        if (home.exists()) {
            File defaultFile = new File(home, ".getopt_defaults");
            try {
                FileOutputStream fos = new FileOutputStream(defaultFile);
                this.defaults.store(fos, "# defaults for command-line gui helper");
                fos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void loadScript(String filename) {
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(filename));
            this.loadArguments(p);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveScript(String filename) {
        File scriptFile = new File(filename);
        try {
            Properties p = new Properties();
            Enumeration e1 = this.order.elements();
            while (e1.hasMoreElements()) {
                String name = (String)e1.nextElement();
                Option option = (Option)this.options.get(name);
                if (name.equals("savescript") || name.equals("script")) continue;
                if (option.type == 1) {
                    if (!this.hasOption(name)) continue;
                    p.put(name, "true");
                    continue;
                }
                String value = this.getOption(name);
                if (value == null || value.equals("")) continue;
                p.put(name, value);
            }
            p.store(new FileOutputStream(scriptFile), "argument script");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private JPanel createEditPane() {
        this.loadDefaults();
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        boolean position = true;
        Insets insets = new Insets(3, 3, 3, 3);
        GridBagConstraints cname = new GridBagConstraints();
        cname.weightx = 1.0;
        cname.anchor = 17;
        cname.insets = insets;
        GridBagConstraints centry = new GridBagConstraints();
        centry.weightx = 1.0;
        centry.anchor = 17;
        centry.insets = insets;
        GridBagConstraints cdesc = new GridBagConstraints();
        cdesc.weightx = 1.0;
        cdesc.gridwidth = 0;
        cdesc.anchor = 17;
        cdesc.insets = insets;
        pane.add((Component)new JLabel("Script name:"), cname);
        final JTextField scriptField = new JTextField(10);
        pane.add((Component)scriptField, centry);
        JButton save = new JButton("Save");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String filename = scriptField.getText();
                if (filename != null && !filename.equals("")) {
                    Getopt2.this.saveScript(filename);
                }
            }
        });
        pane.add((Component)save, cdesc);
        Enumeration e1 = this.order.elements();
        while (e1.hasMoreElements()) {
            final String name = (String)e1.nextElement();
            if (name.equals("gui")) {
                try {
                    this.setFlag(name, false);
                }
                catch (BadOptionException badOptionException) {}
                continue;
            }
            if (name.equals("script")) continue;
            final Option option = (Option)this.options.get(name);
            pane.add((Component)new JLabel(name), cname);
            if (option.type == 1) {
                JCheckBox check = new JCheckBox();
                check.setSelected(this.hasOption(name));
                check.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent ie) {
                        boolean flag = ie.getStateChange() == 1;
                        try {
                            Getopt2.this.setFlag(name, flag);
                        }
                        catch (BadOptionException badOptionException) {
                            // empty catch block
                        }
                    }
                });
                pane.add((Component)check, centry);
            } else {
                final JTextField field = name.equals("password") ? new JPasswordField(10) : new JTextField(10);
                String value = this.getOption(name);
                if (value != null) {
                    field.setText(value);
                }
                DocumentListener dl = (DocumentListener)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{DocumentListener.class}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object o, Method m, Object[] args) throws Exception {
                        Getopt2.this.setOption(name, field.getText());
                        return null;
                    }
                });
                field.getDocument().addDocumentListener(dl);
                pane.add((Component)field, centry);
            }
            JCheckBox defaultCheck = new JCheckBox();
            defaultCheck.setSelected(this.defaults.get(name) != null);
            defaultCheck.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    boolean flag;
                    boolean bl = flag = ie.getStateChange() == 1;
                    if (flag) {
                        if (option.type == 1) {
                            Getopt2.this.defaults.setProperty(name, String.valueOf(Getopt2.this.hasOption(name)));
                        } else {
                            Getopt2.this.defaults.setProperty(name, Getopt2.this.getOption(name));
                        }
                    } else {
                        Getopt2.this.defaults.remove(name);
                    }
                }
            });
            pane.add((Component)defaultCheck, centry);
            pane.add((Component)new JLabel("<html><p>" + option.docString + "</p></html>"), cdesc);
        }
        return pane;
    }

    public String toString() {
        return this.asCommandLine();
    }

    private static class Option {
        int type;
        String name;
        String value;
        Vector multiValue = new Vector();
        int multiArgCount = 1;
        String docString;
        String paramName;
        Getopt2 subOpt;
        Vector subOptArgs;
        boolean isPrivate = false;
        boolean isAdvanced = false;

        Option(int type, String name, String docString) {
            this(type, name, docString, null, null);
        }

        Option(int type, int count, String name, String param, String docString) {
            this(type, name, docString, param, null);
            this.multiArgCount = count;
        }

        Option(int type, String name, String docString, String paramName) {
            this(type, name, docString, paramName, null);
        }

        Option(int type, String name, String docString, String paramName, Getopt2 subOpt) {
            this.type = type;
            this.name = name;
            this.docString = docString;
            this.paramName = paramName;
            this.subOpt = subOpt;
            this.subOptArgs = new Vector();
        }

        String paramString() {
            switch (this.type) {
                case 0: {
                    return " <" + this.paramName + ">";
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return "<" + this.paramName + ">";
                }
                case 3: {
                    return "<option>";
                }
            }
            return "";
        }

        public String toCommandLine() {
            if (this.value == null && this.type != 3) {
                return "";
            }
            switch (this.type) {
                case 0: {
                    return "-" + this.name + " " + this.value;
                }
                case 1: {
                    return "-" + this.name;
                }
                case 2: {
                    return "-" + this.name + this.value;
                }
                case 3: {
                    return this.subOpt.asCommandLine(this.name, null);
                }
            }
            return "";
        }

        public String[] toArgArray() {
            if (this.value == null && this.type != 3) {
                return new String[0];
            }
            String[] result = null;
            switch (this.type) {
                case 0: {
                    result = new String[]{"-" + this.name, this.value};
                    return result;
                }
                case 1: {
                    result = new String[]{"-" + this.name};
                    return result;
                }
                case 2: {
                    result = new String[]{"-" + this.name + this.value};
                    return result;
                }
                case 3: {
                    if (this.value != null) {
                        StringTokenizer st = new StringTokenizer(new String(this.value), " ");
                        Vector<Object> v = new Vector<Object>();
                        while (st.hasMoreTokens()) {
                            v.addElement(st.nextElement());
                        }
                        result = new String[v.size()];
                        for (int i = 0; i < result.length; ++i) {
                            result[i] = (String)v.elementAt(i);
                        }
                        return result;
                    }
                    String[] subOptResult = this.subOpt.asCommandArray(this.name, null);
                    result = new String[subOptResult.length / 2];
                    int j = 0;
                    for (int i = 0; i < subOptResult.length / 2; ++i) {
                        result[i] = subOptResult[j] + subOptResult[j + 1];
                        j += 2;
                    }
                    return result;
                }
            }
            return result;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return "-" + this.name + " " + this.value;
                }
                case 1: {
                    return "-" + this.name;
                }
                case 2: {
                    return "-" + this.name + this.value;
                }
                case 3: {
                    return this.subOpt.asCommandLine(this.name, null);
                }
            }
            return "";
        }
    }
}

