/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.MissingResourceException;
import weblogic.utils.NestedThrowable;

public class InteropStackTraceUtils {
    private static String startBanner = "\nStart server side stack trace:\n";
    private static String endBanner = "End  server side stack trace\n";
    private static String marker = "\tat ";

    public static Throwable getThrowableWithStackTrace(Throwable t, boolean forceAppend) {
        String msg = t.getMessage();
        if (msg == null || forceAppend || msg.indexOf(marker) == -1) {
            Class[] parameterTypes;
            String stackTrace = InteropStackTraceUtils.throwable2StackTrace(t);
            String comment = msg == null ? startBanner + stackTrace + endBanner : msg + "\n" + startBanner + stackTrace + endBanner;
            try {
                Field f = Throwable.class.getDeclaredField("detailMessage");
                f.setAccessible(true);
                f.set(t, comment);
                return t;
            }
            catch (NoSuchFieldException f) {
            }
            catch (SecurityException f) {
            }
            catch (IllegalAccessException f) {
            }
            catch (IllegalArgumentException f) {
                // empty catch block
            }
            if (t instanceof NestedThrowable) {
                parameterTypes = new Class[]{String.class, Throwable.class};
                try {
                    Constructor<?> c = t.getClass().getConstructor(parameterTypes);
                    Throwable nested = ((NestedThrowable)((Object)t)).getNested();
                    Object[] initargs = new Object[]{comment, nested};
                    return (Throwable)c.newInstance(initargs);
                }
                catch (NoSuchMethodException c) {
                }
                catch (SecurityException c) {
                }
                catch (InstantiationException c) {
                }
                catch (IllegalAccessException c) {
                }
                catch (IllegalArgumentException c) {
                }
                catch (InvocationTargetException c) {
                    // empty catch block
                }
            }
            try {
                parameterTypes = new Class[]{String.class};
                Constructor<?> c = t.getClass().getConstructor(parameterTypes);
                Object[] initargs = new Object[]{InteropStackTraceUtils.getComment(t, comment)};
                return (Throwable)c.newInstance(initargs);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return t;
    }

    private static String getComment(Throwable t, String comment) {
        PropertyChangeEvent evt;
        Throwable e;
        if (t instanceof ExceptionInInitializerError && (t = ((ExceptionInInitializerError)(e = (ExceptionInInitializerError)t)).getException()) != null) {
            return InteropStackTraceUtils.getThrowableAsString(t, comment);
        }
        if (t instanceof InvocationTargetException && (t = ((InvocationTargetException)(e = (InvocationTargetException)t)).getTargetException()) != null) {
            return InteropStackTraceUtils.getThrowableAsString(t, comment);
        }
        if (t instanceof ParseException) {
            int offSet = ((ParseException)t).getErrorOffset();
            return comment + "\nwith error offset = " + offSet;
        }
        if (t instanceof PropertyVetoException && (evt = ((PropertyVetoException)t).getPropertyChangeEvent()) != null) {
            return comment + "\nwith property change event = [" + evt + "]";
        }
        if (t instanceof MissingResourceException) {
            e = (MissingResourceException)t;
            return comment + "\nwith class name = [" + ((MissingResourceException)e).getClassName() + "]\nand with key = [" + ((MissingResourceException)e).getKey() + "]";
        }
        return comment;
    }

    private static String getThrowableAsString(Throwable t, String comment) {
        t = InteropStackTraceUtils.getThrowableWithStackTrace(t, false);
        return comment + "\nwith nested Throwable:\n" + InteropStackTraceUtils.throwable2StackTrace(t) + "end nested Throwable\n";
    }

    public static String throwable2StackTrace(Throwable th) {
        if (th == null) {
            th = new Throwable("[Null exception passed, creating stack trace for offending caller]");
        }
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        th.printStackTrace(new PrintStream(ostr));
        return ostr.toString();
    }
}

