/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.platform.JDK;
import weblogic.utils.FileUtils;
import weblogic.utils.StringUtils;

public final class JavaExec {
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = Logger.getLogger("weblogic.utils.JavaExec");
    private static final boolean isMSVM = JavaExec.isMicrosoftVM();
    private static boolean isJre = false;
    private static boolean useLocalJre = false;
    private static boolean isWinSys = false;
    private static boolean quoteStrings = false;
    private static String exeName;
    private static String jdkLibDir;
    private static String[] defaultClasspath;
    private static final String NULL = "<null>";
    private static int majorVersion;
    public static final String JDK_LIB = "JDK_LIB_PLACEHOLDER";
    public static final String JDK_LIB_DIR = "JDK_LIB_DIR";
    private String mainClass;
    private ArrayList sysProps = new ArrayList();
    private ArrayList classPath = new ArrayList();
    private ArrayList args = new ArrayList();
    private ArrayList jvmArgs = new ArrayList();
    private boolean forceMSVM = false;

    public JavaExec(String clazz) {
        this(clazz, false);
    }

    public JavaExec(String clazz, boolean forceMSVM) {
        this.mainClass = clazz;
        if (isWinSys && forceMSVM) {
            this.forceMSVM = true;
        }
        if (isMSVM || forceMSVM) {
            exeName = "jview.exe";
        }
    }

    public static JavaExec createCommand(String cmdLine) {
        ArrayList<String> strV = new ArrayList<String>();
        String[] strs = StringUtils.splitCompletely(cmdLine, " \"", true);
        for (int i = 0; i < strs.length; ++i) {
            if (strs[i].equals("\"")) {
                String quotedStr = "";
                ++i;
                while (i < strs.length && !strs[i].equals("\"")) {
                    quotedStr = quotedStr + strs[i++];
                }
                strV.add(quotedStr);
                continue;
            }
            if (strs[i].equals(" ")) continue;
            strV.add(strs[i]);
        }
        strs = new String[strV.size()];
        strV.toArray(strs);
        return new JavaExec(strs);
    }

    public static JavaExec createCommand(String[] cmdLine) {
        return new JavaExec(cmdLine);
    }

    private JavaExec(String[] cmdLine) {
        this.mainClass = null;
        for (int i = 0; i < cmdLine.length; ++i) {
            String arg = cmdLine[i];
            if (arg == null) continue;
            if (this.mainClass == null && arg.startsWith("-classpath")) {
                String[] paths = null;
                if (arg.equals("-classpath")) {
                    if (++i < cmdLine.length) {
                        arg = cmdLine[i];
                        if (arg.charAt(0) == '\"') {
                            arg = arg.substring(1, arg.length() - 1);
                        }
                        paths = StringUtils.splitCompletely(arg, File.pathSeparator, false);
                    }
                } else {
                    if ((arg = arg.substring(11)).charAt(0) == '\"') {
                        arg = arg.substring(1, arg.length() - 1);
                    }
                    paths = StringUtils.splitCompletely(arg, File.pathSeparator, false);
                }
                this.saveClassPath(paths);
                continue;
            }
            if (arg.startsWith("-Dweblogic.class.path")) {
                int idx;
                if (isMSVM) {
                    String[] paths = null;
                    if ((arg = arg.substring(22)).charAt(0) == '\"') {
                        arg = arg.substring(1, arg.length() - 1);
                    }
                    paths = StringUtils.splitCompletely(arg, File.pathSeparator, false);
                    this.saveClassPath(paths);
                    continue;
                }
                int jdkLibIdx = arg.indexOf(JDK_LIB);
                if (jdkLibIdx >= 0) {
                    int jdkLibLen = JDK_LIB.length();
                    String head = arg.substring(0, jdkLibIdx);
                    String tail = null;
                    if (jdkLibIdx + jdkLibLen <= arg.length()) {
                        tail = arg.substring(jdkLibIdx + jdkLibLen + 1);
                    }
                    arg = head;
                    if (tail != null) {
                        arg = arg + tail;
                    }
                }
                if ((idx = arg.indexOf(61)) > 0) {
                    this.addSystemProp(arg.substring(2, idx), arg.substring(idx + 1));
                    continue;
                }
                this.addSystemProp(arg.substring(2), NULL);
                continue;
            }
            if (arg.startsWith("-D")) {
                int idx = arg.indexOf(61);
                if (idx > 0) {
                    this.addSystemProp(arg.substring(2, idx), arg.substring(idx + 1));
                    continue;
                }
                this.addSystemProp(arg.substring(2), NULL);
                continue;
            }
            if (arg.startsWith("-") && this.mainClass == null) {
                this.jvmArgs.add(arg);
                continue;
            }
            if (this.mainClass == null) {
                this.mainClass = arg;
                continue;
            }
            this.addArg(arg);
        }
    }

    private void saveClassPath(String[] paths) {
        if (paths != null) {
            File pathFile;
            int jdkLibIdx = -1;
            for (int i = 0; i < paths.length; ++i) {
                if (!paths[i].equals(JDK_LIB)) continue;
                jdkLibIdx = i;
                break;
            }
            int pathIdx = 0;
            if (jdkLibIdx >= 0) {
                ArrayList<File> newClassPath = new ArrayList<File>();
                while (pathIdx <= jdkLibIdx) {
                    pathFile = new File(paths[pathIdx++]);
                    newClassPath.add(pathFile);
                }
                for (int i = 0; i < this.classPath.size(); ++i) {
                    newClassPath.add((File)this.classPath.get(i));
                }
                this.classPath = newClassPath;
            }
            while (pathIdx < paths.length) {
                pathFile = new File(paths[pathIdx++]);
                this.addClassPath(pathFile);
            }
        }
    }

    public void addSystemProp(String k, String v) {
        if (!v.equals(NULL)) {
            this.sysProps.add(k + '=' + v);
        } else {
            this.sysProps.add(k);
        }
    }

    public void addSystemProps(Properties p) {
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            String v = (String)p.get(k);
            this.addSystemProp(k, v);
        }
    }

    public void addClassPath(File f) {
        this.classPath.add(f);
    }

    public void addDefaultClassPath() {
        String enviroClasspath = System.getProperty("java.class.path");
        File[] enviroClasspathFiles = FileUtils.splitPath(enviroClasspath);
        for (int ii = 0; ii < enviroClasspathFiles.length; ++ii) {
            this.addClassPath(enviroClasspathFiles[ii]);
        }
    }

    public void addArg(String s) {
        this.args.add(s);
    }

    public static void useLocalJre() {
        useLocalJre = true;
    }

    public void addJvmArg(String s) {
        this.jvmArgs.add(s);
    }

    @Deprecated
    public void addJvmArgs(String s) {
        String[] args = StringUtils.splitCompletely(s, " ");
        for (int i = 0; i < args.length; ++i) {
            this.addJvmArg(args[i]);
        }
    }

    public Process getProcess() throws IOException {
        String[] cmd = this.getCommandArray();
        Process process = Runtime.getRuntime().exec(cmd);
        return process;
    }

    public Process getProcess(File workingDir) throws IOException {
        String[] cmd = this.getCommandArray();
        Process process = Runtime.getRuntime().exec(cmd, null, workingDir);
        return process;
    }

    public String getExeName() {
        return exeName;
    }

    public String getCommand() {
        StringBuffer sb = new StringBuffer();
        String[] args = this.getCommandArray();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(args[i]);
        }
        return sb.toString();
    }

    public String[] getCommandArray() {
        boolean hasMore;
        Iterator i;
        StringBuffer classpathStr;
        ArrayList<String> strV = new ArrayList<String>();
        strV.add(exeName);
        ArrayList orgClassPath = (ArrayList)this.classPath.clone();
        if (isMSVM || this.forceMSVM) {
            if (this.classPath.size() > 0) {
                strV.add("/cp");
                classpathStr = new StringBuffer();
                classpathStr.append('\"');
                i = this.classPath.iterator();
                hasMore = i.hasNext();
                while (hasMore) {
                    String relPath;
                    File f = (File)i.next();
                    hasMore = i.hasNext();
                    String pathElement = f.getAbsolutePath();
                    if (pathElement.endsWith("\\")) {
                        pathElement = pathElement.substring(0, pathElement.length() - 1);
                    }
                    if ((relPath = f.getPath()).equals(JDK_LIB)) {
                        pathElement = "%windir%\\Java\\Classes\\classes.zip";
                    } else if (relPath.startsWith(JDK_LIB_DIR)) {
                        pathElement = jdkLibDir + relPath.substring(JDK_LIB_DIR.length());
                    }
                    classpathStr.append(pathElement);
                    if (!hasMore) continue;
                    classpathStr.append(';');
                }
                classpathStr.append('\"');
                strV.add(classpathStr.toString());
            }
        } else {
            if (this.jvmArgs != null) {
                Iterator i2 = this.jvmArgs.iterator();
                while (i2.hasNext()) {
                    strV.add((String)i2.next());
                }
            }
            strV.add("-classpath");
            classpathStr = new StringBuffer();
            if (quoteStrings) {
                classpathStr.append('\"');
            }
            if (!this.classPath.contains(JDK_LIB)) {
                for (int i3 = 0; i3 < defaultClasspath.length; ++i3) {
                    classpathStr.append(defaultClasspath[i3]);
                    if (i3 == defaultClasspath.length - 1 && this.classPath.size() <= 0) continue;
                    classpathStr.append(File.pathSeparatorChar);
                }
            }
            i = this.classPath.iterator();
            hasMore = i.hasNext();
            while (hasMore) {
                Object pathObj = i.next();
                hasMore = i.hasNext();
                if (pathObj.equals(JDK_LIB)) {
                    for (int j = 0; j < defaultClasspath.length; ++j) {
                        classpathStr.append(defaultClasspath[j]);
                        if (j == defaultClasspath.length - 1 && !hasMore) continue;
                        classpathStr.append(File.pathSeparatorChar);
                    }
                    continue;
                }
                classpathStr.append(((File)pathObj).getAbsolutePath());
                if (!hasMore) continue;
                classpathStr.append(File.pathSeparatorChar);
            }
            if (quoteStrings) {
                classpathStr.append('\"');
            }
            strV.add(classpathStr.toString());
        }
        String dashD = "-D";
        if (isMSVM || this.forceMSVM) {
            dashD = "/d:";
        }
        for (String s : this.sysProps) {
            strV.add(dashD + s);
        }
        strV.add(this.mainClass);
        i = this.args.iterator();
        while (i.hasNext()) {
            strV.add(JavaExec.adaptStringForEnvironment((String)i.next()));
        }
        if (orgClassPath != null) {
            this.classPath = orgClassPath;
        }
        String[] strs = new String[strV.size()];
        strV.toArray(strs);
        return strs;
    }

    private static String adaptStringForEnvironment(String str) {
        if (quoteStrings) {
            str = '\"' + str + '\"';
        }
        return str;
    }

    private static void initDefaults() {
        JDK jdk = JDK.getJDK();
        majorVersion = jdk.getMajorVersion();
        if (JavaExec.isWinSystem()) {
            isWinSys = true;
            quoteStrings = true;
        } else {
            quoteStrings = false;
        }
        if (JavaExec.isMicrosoftVM()) {
            exeName = "jview.exe";
            defaultClasspath = new String[0];
            jdkLibDir = "%windir%";
            return;
        }
        File dir = new File(System.getProperty("java.home").replace('/', File.separatorChar));
        exeName = JavaExec.getExeName(dir);
        jdkLibDir = dir.getAbsolutePath();
        if (isJre || majorVersion >= 2) {
            defaultClasspath = new String[2];
            JavaExec.defaultClasspath[0] = new File(dir, "lib" + File.separatorChar + "rt.jar").getAbsolutePath();
            JavaExec.defaultClasspath[1] = new File(dir, "lib" + File.separatorChar + "i18n.jar").getAbsolutePath();
        } else {
            defaultClasspath = new String[1];
            JavaExec.defaultClasspath[0] = new File(dir, "lib" + File.separatorChar + "classes.zip").getAbsolutePath();
        }
    }

    private static boolean isMicrosoftVM() {
        String vend = System.getProperty("java.vendor");
        if (vend == null) {
            return false;
        }
        return vend.toLowerCase().indexOf("icrosoft") != -1;
    }

    private static boolean isWinSystem() {
        return File.pathSeparatorChar == ';';
    }

    private static String getExeName(File jh) {
        File f;
        if (useLocalJre) {
            f = new File(jh, "bin" + File.separatorChar + "jre");
            if (f.exists()) {
                return f.getAbsolutePath();
            }
            f = new File(jh, "bin" + File.separatorChar + "jre.exe");
            if (f.exists()) {
                return f.getAbsolutePath();
            }
        }
        if ((f = new File(jh, "bin" + File.separatorChar + "java")).exists()) {
            return f.getAbsolutePath();
        }
        f = new File(jh, "bin" + File.separatorChar + "javaw.exe");
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        f = new File(jh, "bin" + File.separatorChar + "java.exe");
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        f = new File(jh, "bin" + File.separatorChar + "jre");
        if (f.exists()) {
            isJre = true;
            return f.getAbsolutePath();
        }
        f = new File(jh, "bin" + File.separatorChar + "jre.exe");
        if (f.exists()) {
            isJre = true;
            return f.getAbsolutePath();
        }
        throw new Error("cannot find a suitable java executable");
    }

    public static void startReaderThreads(Process newVMProc) {
        Thread outthread = new Thread(new JaXSubProcess(false, newVMProc.getInputStream()));
        outthread.setDaemon(true);
        outthread.start();
        Thread errthread = new Thread(new JaXSubProcess(true, newVMProc.getErrorStream()));
        errthread.setDaemon(true);
        errthread.start();
    }

    static {
        jdkLibDir = null;
        majorVersion = -1;
        JavaExec.initDefaults();
    }

    static final class JaXSubProcess
    implements Runnable {
        private static final Logger LOGGER = Logger.getLogger("weblogic.utils.JavaExec.JaXSubProcess");
        boolean isErr;
        String subname;
        InputStream isem;

        JaXSubProcess(boolean iser, InputStream is) {
            this.isErr = iser;
            this.subname = this.isErr ? "child stderr" : "child stdout";
            this.isem = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DataInputStream dis = new DataInputStream(this.isem);
            try {
                String line;
                while ((line = dis.readLine()) != null) {
                    if (this.isErr) {
                        LOGGER.warning(line);
                        continue;
                    }
                    LOGGER.info(line);
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "IOException when running JaXSubProcess", ioe);
            }
            finally {
                LOGGER.fine("Stopped draining " + this.subname);
            }
        }
    }
}

