/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class KeyTable {
    private static final Class preload = KeyTableEnumeration.class;
    private static final int[] ALPHA = new int[]{1, 1, 3, 5, 9, 19, 39, 79, 159, 317, 633, 1265, 2531, 5063, 10125, 20251, 40503, 81007, 162013, 324027, 648055, 1296111, 2592223, 5184445, 10368889, 20737779, 41475559, 82951117, 165902235, 331804471, 663608943, 1327217885};
    private Object[] table;
    private int mask;
    private int alpha;
    private int size = 0;
    private int power;

    public KeyTable() {
        this(5);
    }

    public KeyTable(int initialBinaryPower) {
        this.setPower(initialBinaryPower);
    }

    private void setPower(int power) {
        this.power = power;
        this.table = new Object[1 << power];
        this.mask = this.table.length - 1;
        this.alpha = ALPHA[power];
    }

    private final int firstBucket(int key) {
        return (key & this.mask ^ key >> 32 - this.power) & this.mask;
    }

    private final int nextBucket(int bucket) {
        return bucket + this.alpha & this.mask;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Enumeration elements() {
        return new KeyTableEnumeration(this.table);
    }

    public Enumeration keys() {
        return new KeyTableEnumeration(this.table, true);
    }

    public Object get(int key) {
        int i = this.firstBucket(key);
        Object o;
        while ((o = this.table[i]) != null && o.hashCode() != key) {
            i = this.nextBucket(i);
        }
        return o;
    }

    public Object put(Object value) {
        Object o;
        int i;
        if (this.size >= this.table.length * 3 / 4) {
            Object[] oldTable = this.table;
            this.setPower(this.power + 1);
            this.size = 0;
            for (i = 0; i < oldTable.length; ++i) {
                o = oldTable[i];
                if (o == null) continue;
                this.put(o);
            }
        }
        int key = value.hashCode();
        i = this.firstBucket(key);
        while (true) {
            if ((o = this.table[i]) == null) {
                ++this.size;
                this.table[i] = value;
                return o;
            }
            if (o.hashCode() == key) {
                this.table[i] = value;
                return o;
            }
            i = this.nextBucket(i);
        }
    }

    public Object remove(int key) {
        int i = this.firstBucket(key);
        Object o = this.table[i];
        while (o != null && o.hashCode() != key) {
            i = this.nextBucket(i);
            o = this.table[i];
        }
        if (o == null) {
            return null;
        }
        this.table[i] = null;
        --this.size;
        Object ti;
        while ((ti = this.table[i = this.nextBucket(i)]) != null) {
            this.table[i] = null;
            --this.size;
            this.put(ti);
        }
        return o;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer("{");
        Enumeration e = this.elements();
        Enumeration k = this.keys();
        if (e.hasMoreElements()) {
            buf.append("<" + k.nextElement() + "," + e.nextElement() + ">");
        }
        while (e.hasMoreElements()) {
            buf.append(", ").append("<" + k.nextElement() + "," + e.nextElement() + ">");
        }
        return buf.append("}").toString();
    }

    private static final class KeyTableEnumeration
    implements Enumeration {
        private int i = 0;
        private final Object[] table;
        private boolean returnKeys = false;

        public KeyTableEnumeration(Object[] table) {
            this.table = table;
        }

        public KeyTableEnumeration(Object[] table, boolean returnKeys) {
            this.table = table;
            this.returnKeys = returnKeys;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.i < this.table.length && this.table[this.i] == null) {
                ++this.i;
            }
            return this.i < this.table.length;
        }

        public Object nextElement() {
            while (this.i < this.table.length && this.table[this.i] == null) {
                ++this.i;
            }
            if (this.i == this.table.length) {
                throw new NoSuchElementException("KeytableEnumerator");
            }
            if (!this.returnKeys) {
                return this.table[this.i++];
            }
            return new Integer(this.table[this.i++].hashCode());
        }
    }
}

