/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

@Deprecated
public class ObjectFactory {
    private static final boolean DEBUG = false;

    public static Object createObject(String factoryId, String fallbackClassName) throws ConfigurationError {
        return ObjectFactory.createObject(factoryId, null, fallbackClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object createObject(String factoryId, String propertiesFilename, String fallbackClassName) throws ConfigurationError {
        ObjectFactory.debugPrintln("debug is on");
        ClassLoader cl = ObjectFactory.findClassLoader();
        try {
            String systemProp = ObjectFactory.getSystemProperty(factoryId);
            if (systemProp != null) {
                ObjectFactory.debugPrintln("found system property, value=" + systemProp);
                return ObjectFactory.newInstance(systemProp, cl, true);
            }
        }
        catch (SecurityException systemProp) {
            // empty catch block
        }
        try {
            String javah = ObjectFactory.getSystemProperty("java.home");
            String configFile = javah + File.separator + "lib" + File.separator + propertiesFilename;
            FileInputStream fis = ObjectFactory.getFileInputStream(new File(configFile));
            Properties props = new Properties();
            try {
                props.load(fis);
            }
            finally {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
            String factoryClassName = props.getProperty(factoryId);
            if (factoryClassName != null) {
                ObjectFactory.debugPrintln("found in jaxp.properties, value=" + factoryClassName);
                return ObjectFactory.newInstance(factoryClassName, cl, true);
            }
        }
        catch (Exception javah) {
            // empty catch block
        }
        Object provider = ObjectFactory.findJarServiceProvider(factoryId);
        if (provider != null) {
            return provider;
        }
        if (fallbackClassName == null) {
            throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
        }
        ObjectFactory.debugPrintln("using fallback, value=" + fallbackClassName);
        return ObjectFactory.newInstance(fallbackClassName, cl, true);
    }

    private static void debugPrintln(String msg) {
    }

    public static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader cl = ObjectFactory.getContextClassLoader();
        if (cl == null) {
            cl = ObjectFactory.class.getClassLoader();
        }
        return cl;
    }

    public static Object newInstance(String className, ClassLoader cl, boolean doFallback) throws ConfigurationError {
        try {
            Class<?> providerClass;
            if (cl == null) {
                providerClass = Class.forName(className);
            } else {
                try {
                    providerClass = cl.loadClass(className);
                }
                catch (ClassNotFoundException x) {
                    if (doFallback) {
                        cl = ObjectFactory.class.getClassLoader();
                        providerClass = cl.loadClass(className);
                    }
                    throw x;
                }
            }
            Object instance = providerClass.newInstance();
            ObjectFactory.debugPrintln("created new instance of " + providerClass + " using ClassLoader: " + cl);
            return instance;
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    private static Object findJarServiceProvider(String factoryId) throws ConfigurationError {
        BufferedReader rd;
        String serviceId = "META-INF/services/" + factoryId;
        InputStream is = null;
        ClassLoader cl = ObjectFactory.getContextClassLoader();
        if (cl != null) {
            is = ObjectFactory.getResourceAsStream(cl, serviceId);
            if (is == null) {
                cl = ObjectFactory.class.getClassLoader();
                is = ObjectFactory.getResourceAsStream(cl, serviceId);
            }
        } else {
            cl = ObjectFactory.class.getClassLoader();
            is = ObjectFactory.getResourceAsStream(cl, serviceId);
        }
        if (is == null) {
            return null;
        }
        ObjectFactory.debugPrintln("found jar resource=" + serviceId + " using ClassLoader: " + cl);
        try {
            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            rd = new BufferedReader(new InputStreamReader(is));
        }
        String factoryClassName = null;
        try {
            factoryClassName = rd.readLine();
            rd.close();
        }
        catch (IOException x) {
            return null;
        }
        if (factoryClassName != null && !"".equals(factoryClassName)) {
            ObjectFactory.debugPrintln("found in resource, value=" + factoryClassName);
            return ObjectFactory.newInstance(factoryClassName, cl, false);
        }
        return null;
    }

    public static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl;
            }
        });
    }

    public static String getSystemProperty(final String propName) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(propName);
            }
        });
    }

    public static FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    public static InputStream getResourceAsStream(final ClassLoader cl, final String name) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InputStream ris = cl == null ? ClassLoader.getSystemResourceAsStream(name) : cl.getResourceAsStream(name);
                return ris;
            }
        });
    }

    public static class ConfigurationError
    extends Error {
        private Exception exception;

        public ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

