/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

public class PropertyHelper {
    public static boolean getBoolean(String propertyName) {
        try {
            return Boolean.getBoolean(propertyName);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static boolean getBoolean(String propertyName, boolean defaultValueOnFailure) {
        try {
            return Boolean.getBoolean(propertyName);
        }
        catch (SecurityException securityException) {
            return defaultValueOnFailure;
        }
    }

    public static int getInteger(String propertyName, int defaultValue) {
        try {
            Integer theInt = Integer.getInteger(propertyName);
            if (theInt == null) {
                return defaultValue;
            }
            return theInt;
        }
        catch (SecurityException securityException) {
            return defaultValue;
        }
    }

    public static long getLong(String propertyName, long defaultValue) {
        try {
            Long theLong = Long.getLong(propertyName);
            if (theLong == null) {
                return defaultValue;
            }
            return theLong;
        }
        catch (SecurityException securityException) {
            return defaultValue;
        }
    }

    public static String getProperty(String propertyName, String defaultValue) {
        try {
            String theProp = System.getProperty(propertyName, defaultValue);
            return theProp;
        }
        catch (SecurityException securityException) {
            return defaultValue;
        }
    }
}

