/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.util.EmptyStackException;

public abstract class RecursiveDescentParser {
    public static final boolean debug = false;
    protected char[] buf;
    protected int idx;
    protected int peek;
    private final IndexStack idxStack = new IndexStack();
    protected String sval;
    protected Object oval;
    protected int tok_type;
    protected boolean skipWhiteSpace = false;

    public void setSkipWhiteSpace(boolean b) {
        this.skipWhiteSpace = b;
    }

    protected final void startMatch() {
        if (this.skipWhiteSpace) {
            this.skipWhiteSpace = false;
            this.skipWhiteSpace();
            this.skipWhiteSpace = true;
        }
        this.idxStack.push(this.idx);
    }

    protected final void startMatch(String s) {
        if (this.skipWhiteSpace) {
            this.skipWhiteSpace = false;
            this.skipWhiteSpace();
            this.skipWhiteSpace = true;
        }
        this.idxStack.push(this.idx);
    }

    protected String capture(int start, int end) {
        return new String(this.buf, start, end - start);
    }

    protected final boolean success() {
        int start = this.idxStack.pop();
        this.sval = new String(this.buf, start, this.peek - start);
        this.idx = this.peek;
        return true;
    }

    protected final boolean success(String s) {
        this.idxStack.pop();
        this.sval = s;
        this.idx = this.peek;
        return true;
    }

    protected final boolean failure() {
        this.peek = this.idx = this.idxStack.pop();
        return false;
    }

    protected final boolean match(char c) {
        this.startMatch();
        if (this.peek == this.buf.length) {
            return this.failure();
        }
        return this.buf[this.peek++] == c ? this.success() : this.failure();
    }

    protected final boolean notMatch(char c) {
        this.startMatch();
        if (this.peek == this.buf.length) {
            return this.failure();
        }
        return this.buf[this.peek++] != c ? this.success() : this.failure();
    }

    protected final boolean matchIgnoreCase(char c) {
        this.startMatch();
        if (this.peek == this.buf.length) {
            return this.failure();
        }
        return this.lc(this.buf[this.peek++]) == this.lc(c) ? this.success() : this.failure();
    }

    protected final boolean match(String s) {
        String inBuf;
        this.startMatch();
        int len = s.length();
        if (this.peek + len >= this.buf.length) {
            return this.failure();
        }
        if (this.buf[this.peek] == s.charAt(0) && this.buf.length > this.peek + len && (inBuf = new String(this.buf, this.peek, len)).equals(s)) {
            this.peek += len;
            return this.success();
        }
        return this.failure();
    }

    protected final boolean matchIgnoreCase(String s) {
        String inBuf;
        this.startMatch();
        int len = s.length();
        if (this.peek + len >= this.buf.length) {
            return this.failure();
        }
        if (this.lc(this.buf[this.peek]) == this.lc(s.charAt(0)) && this.buf.length > this.peek + len && (inBuf = new String(this.buf, this.peek, len)).equalsIgnoreCase(s)) {
            this.peek += len;
            return this.success();
        }
        return this.failure();
    }

    protected final boolean lookingAt(String s) {
        String inBuf;
        int len = s.length();
        if (this.peek + len >= this.buf.length) {
            return false;
        }
        return this.buf[this.peek] == s.charAt(0) && this.buf.length > this.peek + len && (inBuf = new String(this.buf, this.peek, len)).equals(s);
    }

    protected final boolean lookingAtIgnoreCase(String s) {
        String inBuf;
        int len = s.length();
        if (this.peek + len >= this.buf.length) {
            return false;
        }
        return this.lc(this.buf[this.peek]) == this.lc(s.charAt(0)) && this.buf.length > this.peek + len && (inBuf = new String(this.buf, this.peek, len)).equalsIgnoreCase(s);
    }

    protected final int peek() {
        return this.buf[this.peek];
    }

    protected final boolean eof() {
        if (this.skipWhiteSpace) {
            this.skipWhiteSpace = false;
            this.skipWhiteSpace();
            this.skipWhiteSpace = true;
        }
        return this.idx == this.buf.length;
    }

    protected void skipWhiteSpace() {
        block3: while (this.peek < this.buf.length) {
            switch (this.buf[this.peek]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++this.peek;
                    continue block3;
                }
            }
        }
        this.idx = this.peek;
    }

    private String niceChar(char c) {
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case ' ': {
                return "SPC";
            }
            case '\t': {
                return "\\t";
            }
        }
        return String.valueOf(c);
    }

    private char lc(char c) {
        return Character.toLowerCase(c);
    }

    protected final void say(String s) {
        int level = this.idxStack.depth();
        for (int i = 0; i < level; ++i) {
            System.out.print("| ");
        }
        System.out.println(s);
    }

    private static final class IndexStack {
        private int[] stack;
        private int sp = 0;

        IndexStack() {
            this(10);
        }

        IndexStack(int depth) {
            this.stack = new int[depth];
        }

        public void push(int num) {
            try {
                this.stack[this.sp] = num;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                int len = this.stack.length;
                int[] newstack = new int[len * 2];
                System.arraycopy(this.stack, 0, newstack, 0, len);
                this.stack = newstack;
                this.stack[this.sp] = num;
            }
            ++this.sp;
        }

        public int pop() throws EmptyStackException {
            try {
                return this.stack[--this.sp];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new EmptyStackException();
            }
        }

        public int depth() {
            return this.sp;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("stack: ");
            for (int i = 0; i < this.sp; ++i) {
                sb.append(this.stack[i]).append(",");
            }
            return sb.toString().substring(0, sb.length() - 1);
        }
    }
}

