/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.util.Iterator;
import java.util.Map;
import weblogic.utils.StackTraceUtilsClient;

public class StackTraceUtils
extends StackTraceUtilsClient {
    private static void dumpStack(Thread toDump) {
        StackTraceElement[] elements = toDump.getStackTrace();
        if (elements == null) {
            System.out.println("Stack on thread " + toDump + " is corrupt, no stack trace");
            return;
        }
        System.out.println(toDump + "\n");
        for (int lcv = 0; lcv < elements.length; ++lcv) {
            StackTraceElement element = elements[lcv];
            System.out.println("\tat[" + lcv + "] " + element);
        }
    }

    public static void dumpStack() {
        StackTraceUtils.dumpStack(Thread.currentThread());
    }

    public static void dumpAllStacks() {
        Map<Thread, StackTraceElement[]> allThreads = Thread.getAllStackTraces();
        Iterator<Thread> it = allThreads.keySet().iterator();
        while (it.hasNext()) {
            StackTraceUtils.dumpStack(it.next());
        }
    }
}

