/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public class StackTraceUtilsClient {
    private static final String WEBLOGIC_UTILS_STACK_TRACE_DISABLED = "weblogic.utils.StackTraceDisabled";
    private static final String UNKNOWN_METHOD = "unknownMethod";
    private static StackTraceElement DEFAULT_DISABLED_STACK_ELEMENT = new StackTraceElement("weblogic.utils.StackTraceDisabled", "unknownMethod", "", -1);
    private static final StackTraceElement[] DO_NOT_DISPLAY_STACK = new StackTraceElement[]{DEFAULT_DISABLED_STACK_ELEMENT};
    private static boolean isPostJdk8 = false;

    public static String throwable2StackTrace(Throwable th) {
        if (th == null) {
            th = new Throwable("[Null exception passed, creating stack trace for offending caller]");
        }
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        th.printStackTrace(new PrintStream(ostr));
        return ostr.toString();
    }

    public static String throwable2StackTraceTruncated(Throwable th, int stackTraceDepth) {
        if (th == null) {
            th = new Throwable("[Null exception passed, creating stack trace for offending caller]");
        }
        if (stackTraceDepth == -1) {
            return StackTraceUtilsClient.throwable2StackTrace(th);
        }
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(ostr);
        StackTraceUtilsClient.printStackTrace(th, ps, stackTraceDepth);
        return ostr.toString();
    }

    private static void printStackTrace(Throwable th, PrintStream ps, int stackTraceDepth) {
        Throwable ourCause;
        ps.println(th);
        StackTraceElement[] trace = th.getStackTrace();
        int stackDepth = stackTraceDepth;
        if (stackDepth > trace.length) {
            stackDepth = trace.length;
        }
        for (int i = 0; i < stackDepth; ++i) {
            ps.println("\tat " + trace[i]);
        }
        if (stackDepth < trace.length) {
            ps.println("\tTruncated. see log file for complete stacktrace");
        }
        if ((ourCause = th.getCause()) != null) {
            StackTraceUtilsClient.printStackTrace(ourCause, ps, stackTraceDepth);
        }
    }

    public static Throwable getThrowableWithCause(Throwable throwable) {
        try {
            Class[] parameterTypes = new Class[]{String.class, Throwable.class};
            Constructor<?> constructor = throwable.getClass().getConstructor(parameterTypes);
            Object[] initargs = new Object[]{throwable.getMessage(), throwable.getCause()};
            Throwable cause = (Throwable)constructor.newInstance(initargs);
            cause.setStackTrace(throwable.getStackTrace());
            StackTraceUtilsClient.setThrowableCause(throwable, cause);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throwable.setStackTrace(StackTraceUtilsClient.trimStackTrace(new Throwable().getStackTrace(), 1));
        return throwable;
    }

    public static Throwable getThrowableWithCauseAndNoStack(Throwable throwable) {
        try {
            Class[] parameterTypes = new Class[]{String.class, Throwable.class};
            Constructor<?> constructor = throwable.getClass().getConstructor(parameterTypes);
            Object[] initargs = new Object[]{throwable.getMessage(), throwable.getCause()};
            Throwable newThrowable = (Throwable)constructor.newInstance(initargs);
            newThrowable.setStackTrace(DO_NOT_DISPLAY_STACK);
            StackTraceUtilsClient.setThrowableCause(throwable, newThrowable);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return throwable;
    }

    public static void scrubExceptionStackTrace(Throwable t) {
        for (Throwable iter = t.getCause(); iter != null; iter = iter.getCause()) {
            iter.setStackTrace(DO_NOT_DISPLAY_STACK);
        }
        t.setStackTrace(DO_NOT_DISPLAY_STACK);
    }

    private static StackTraceElement[] trimStackTrace(StackTraceElement[] stackTrace, int framesToTrim) {
        if (stackTrace.length - framesToTrim <= 0) {
            return stackTrace;
        }
        StackTraceElement[] returnStackTrace = new StackTraceElement[stackTrace.length - framesToTrim];
        for (int i = 0; i < returnStackTrace.length; ++i) {
            returnStackTrace[i] = stackTrace[i + framesToTrim];
        }
        return returnStackTrace;
    }

    private static void setThrowableCause(Throwable throwable, Throwable cause) throws IllegalAccessException {
        try {
            throwable.initCause(cause);
        }
        catch (IllegalStateException ise) {
            try {
                Field f = Throwable.class.getDeclaredField("cause");
                boolean set = true;
                if (!isPostJdk8) {
                    f.setAccessible(true);
                    f.set(throwable, cause);
                }
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            throw new IllegalAccessException("Error setting cause");
        }
    }

    public static String throwableToString(Throwable th) {
        StringBuilder sb = new StringBuilder();
        sb.append(th.toString());
        for (Throwable current = th.getCause(); current != null; current = current.getCause()) {
            sb.append(" caused by: ");
            sb.append(current.toString());
        }
        return sb.toString();
    }

    static {
        isPostJdk8 = !System.getProperty("java.version").startsWith("1.");
    }
}

