/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class URIUtils {
    private static boolean isDebug = false;

    public static URI getResourceURI(URL resourceURL) throws IOException {
        String file = resourceURL.getFile();
        if ("jar".equals(resourceURL.getProtocol())) {
            file = file.substring(5);
        }
        return new File(file).getCanonicalFile().toURI();
    }

    public static URI getRelativeURI(URI rootURI, URI resourceURI) {
        URI relativeURI = rootURI.relativize(resourceURI);
        URIUtils.debug("Relativizing " + resourceURI + " to " + rootURI);
        if (relativeURI.equals(resourceURI)) {
            URIUtils.debug("No initial match, schemes are " + resourceURI.getScheme() + " and " + rootURI.getScheme());
            if ((resourceURI.getScheme().equals("jar") || resourceURI.getScheme().equals("zip")) && rootURI.getScheme().equals("file")) {
                URIUtils.debug("Schema mismatch detected");
                String resourceURIAsString = resourceURI.toString();
                String descriptorURI = resourceURIAsString.substring(resourceURIAsString.indexOf("!") + 1);
                URIUtils.debug("Descriptor URI is " + descriptorURI);
                String jarURIAsString = null;
                jarURIAsString = resourceURI.getScheme().equals("zip") ? "file:/" + resourceURIAsString.substring(4, resourceURIAsString.indexOf("!")) : resourceURIAsString.substring(4, resourceURIAsString.indexOf("!"));
                URIUtils.debug("Jar URI is " + jarURIAsString);
                try {
                    URI jarURI = new URI(jarURIAsString);
                    URI relativeJarURI = rootURI.relativize(jarURI);
                    URIUtils.debug("Relative jar URI is " + relativeJarURI.toString());
                    return new URI(relativeJarURI + "!" + descriptorURI);
                }
                catch (URISyntaxException e) {
                    URIUtils.debug("Unable to relativize URI", e);
                    return relativeURI;
                }
            }
        }
        return relativeURI;
    }

    public static URI getRelativeURI(File[] rootFiles, URI resourceURI) {
        if (rootFiles != null) {
            for (int count = 0; count < rootFiles.length; ++count) {
                URI relativeURI = URIUtils.getRelativeURI(rootFiles[count].toURI(), resourceURI);
                if (relativeURI.equals(resourceURI)) continue;
                return relativeURI;
            }
        }
        return resourceURI;
    }

    private static void debug(String msg, Exception e) {
        if (isDebug) {
            System.out.println(msg);
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    private static void debug(String msg) {
        URIUtils.debug(msg, null);
    }
}

