/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

@Deprecated
public class UnsyncCircularQueue {
    private static final int DEFAULT_CAPACITY = 256;
    private static final int DEFAULT_MAX_CAPACITY = 65536;
    public static final int MAX_CAPACITY = 0x40000000;
    private int size = 0;
    private int producerIndex = 0;
    private int consumerIndex = 0;
    private int capacity = 1;
    private int maxCapacity = 1;
    private int bitmask;
    private Object[] q;

    public UnsyncCircularQueue() {
        this(256);
    }

    public UnsyncCircularQueue(int c) {
        this(c, 65536);
    }

    public UnsyncCircularQueue(int c, int mc) {
        if (c > mc) {
            throw new IllegalArgumentException("Capacity greater than maximum");
        }
        if (mc > 0x40000000) {
            throw new IllegalArgumentException("Capacity: '" + mc + "' greater than maximum: '" + 0x40000000 + "'");
        }
        this.capacity = 1;
        while (this.capacity < c) {
            this.capacity <<= 1;
        }
        this.maxCapacity = 1;
        while (this.maxCapacity < mc) {
            this.maxCapacity <<= 1;
        }
        this.bitmask = this.capacity - 1;
        this.q = new Object[this.capacity];
    }

    private void expandQueue() {
        if (this.capacity == this.maxCapacity) {
            throw new FullQueueException(this.maxCapacity);
        }
        int old_capacity = this.capacity;
        Object[] old_q = this.q;
        this.capacity += this.capacity;
        this.bitmask = this.capacity - 1;
        this.q = new Object[this.capacity];
        System.arraycopy(old_q, this.consumerIndex, this.q, 0, old_capacity - this.consumerIndex);
        if (this.consumerIndex != 0) {
            System.arraycopy(old_q, 0, this.q, old_capacity - this.consumerIndex, this.consumerIndex);
        }
        this.consumerIndex = 0;
        this.producerIndex = this.size;
    }

    public final void put(Object obj) {
        if (this.size == this.capacity) {
            this.expandQueue();
        }
        ++this.size;
        this.q[this.producerIndex] = obj;
        this.producerIndex = this.producerIndex + 1 & this.bitmask;
    }

    public final Object get() {
        if (this.size == 0) {
            return null;
        }
        --this.size;
        Object obj = this.q[this.consumerIndex];
        this.q[this.consumerIndex] = null;
        this.consumerIndex = this.consumerIndex + 1 & this.bitmask;
        return obj;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public Object peek() {
        if (this.size == 0) {
            return null;
        }
        return this.q[this.consumerIndex];
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString() + " - capacity: '" + this.capacity() + "' size: '" + this.size() + "'");
        if (this.size > 0) {
            s.append(" elements:");
            for (int i = 0; i < this.size; ++i) {
                s.append('\n');
                s.append('\t');
                s.append(this.q[this.consumerIndex + i & this.bitmask].toString());
            }
        }
        return s.toString();
    }

    public static class FullQueueException
    extends RuntimeException {
        private static final long serialVersionUID = 273708857498202064L;
        int capacity;

        private FullQueueException(int c) {
            this.capacity = c;
        }

        @Override
        public String getMessage() {
            return "Queue exceed maximum capacity of: '" + this.capacity + "' elements";
        }
    }
}

