/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

@Deprecated
public final class UnsyncHashtable
extends Dictionary
implements Cloneable,
Externalizable {
    private transient UnsyncHTEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private static final long serialVersionUID = 1421746759512286392L;

    public UnsyncHashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new UnsyncHTEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public UnsyncHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public UnsyncHashtable() {
        this(101, 0.75f);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new UnsyncHTEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new UnsyncHTEnumerator(this.table, false);
    }

    public boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        UnsyncHTEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            UnsyncHTEntry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object key) {
        UnsyncHTEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        UnsyncHTEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        UnsyncHTEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        UnsyncHTEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        UnsyncHTEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        UnsyncHTEntry[] newTable = new UnsyncHTEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            UnsyncHTEntry old = oldTable[i];
            while (old != null) {
                UnsyncHTEntry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public Object put(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        UnsyncHTEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        UnsyncHTEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        e = new UnsyncHTEntry();
        e.hash = hash;
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
        return null;
    }

    public Object remove(Object key) {
        UnsyncHTEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        UnsyncHTEntry e = tab[index];
        UnsyncHTEntry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public void clear() {
        UnsyncHTEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            UnsyncHashtable t = (UnsyncHashtable)super.clone();
            t.table = new UnsyncHTEntry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                t.table[i] = this.table[i] != null ? (UnsyncHTEntry)this.table[i].clone() : null;
            }
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration k = this.keys();
        Enumeration e = this.elements();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            String s1 = k.nextElement().toString();
            String s2 = e.nextElement().toString();
            buf.append(s1 + "=" + s2);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput s) throws IOException {
        s.writeInt(this.threshold);
        s.writeFloat(this.loadFactor);
        s.writeInt(this.table.length);
        s.writeInt(this.count);
        for (int i = 0; i < this.table.length; ++i) {
            UnsyncHTEntry entry = this.table[i];
            while (entry != null) {
                s.writeObject(entry.key);
                s.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    @Override
    public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
        this.threshold = s.readInt();
        this.loadFactor = s.readFloat();
        int origlength = s.readInt();
        int elements = s.readInt();
        int length = (int)((float)elements * this.loadFactor) + elements / 20 + 3;
        if (length > elements && (length & 1) == 0) {
            --length;
        }
        if (origlength > 0 && length > origlength) {
            length = origlength;
        }
        this.table = new UnsyncHTEntry[length];
        this.count = 0;
        while (elements > 0) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(key, value);
            --elements;
        }
    }

    private static final class UnsyncHTEnumerator
    implements Enumeration {
        boolean keys;
        int index;
        UnsyncHTEntry[] table;
        UnsyncHTEntry entry;

        UnsyncHTEnumerator(UnsyncHTEntry[] table, boolean keys) {
            this.table = table;
            this.keys = keys;
            this.index = table.length;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                UnsyncHTEntry e = this.entry;
                this.entry = e.next;
                return this.keys ? e.key : e.value;
            }
            throw new NoSuchElementException("UnsyncHTEnumerator");
        }
    }

    private static final class UnsyncHTEntry {
        int hash;
        Object key;
        Object value;
        UnsyncHTEntry next;

        private UnsyncHTEntry() {
        }

        protected Object clone() {
            UnsyncHTEntry entry = new UnsyncHTEntry();
            entry.hash = this.hash;
            entry.key = this.key;
            entry.value = this.value;
            entry.next = this.next != null ? (UnsyncHTEntry)this.next.clone() : null;
            return entry;
        }
    }
}

