/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import weblogic.common.internal.PackageInfo;
import weblogic.common.internal.VersionInfo;
import weblogic.utils.StringUtils;

public class Versions {
    private static PackageInfo wlsPackageInfo;

    public static void main(String[] args) {
        String result = Versions.getVersions(args);
        System.out.println("\n" + result);
    }

    public static String getVersions(String[] args) {
        StringBuffer str = new StringBuffer();
        PackageInfo[] packages = VersionInfo.getPackageInfos(args);
        int packageLength = packages.length;
        if (packageLength > 0) {
            for (int i = 0; i < packageLength - 1; ++i) {
                str.append(packages[i].getImplementationTitle() + " ImplVersion: " + packages[i].getImplementationVersion());
                str.append("\n");
            }
            str.append(packages[packageLength - 1].getImplementationTitle() + " ImplVersion: " + packages[packageLength - 1].getImplementationVersion());
        }
        return str.toString();
    }

    public static String getWebLogicServerVersion() {
        String[] wls;
        PackageInfo[] packages;
        if (wlsPackageInfo == null && (packages = VersionInfo.getPackageInfos(wls = new String[]{"WebLogic Server"})).length > 0) {
            wlsPackageInfo = packages[0];
        }
        if (wlsPackageInfo == null) {
            return "1.0.0.0";
        }
        return wlsPackageInfo.getImplementationVersion();
    }

    public static String getWebLogicServerMajorVersion() {
        String wlsVersion = Versions.getWebLogicServerVersion();
        return StringUtils.splitCompletely(wlsVersion, ".", false)[0];
    }

    public static String getWebLogicServerMinorVersion() {
        String wlsVersion = Versions.getWebLogicServerVersion();
        return StringUtils.splitCompletely(wlsVersion, ".", false)[1];
    }
}

