/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import weblogic.utils.FileUtils;
import weblogic.utils.classes.ClassBytes;
import weblogic.utils.classes.ClassBytes102;
import weblogic.utils.classes.ClassFinder;

public class ClassFinder102
implements ClassFinder {
    protected File[] classpath;
    protected boolean[] zips;

    public ClassFinder102() {
        this.classpath = FileUtils.splitPath(System.getProperty("java.class.path"));
        this.zipScan();
    }

    public ClassFinder102(String path) {
        this.classpath = FileUtils.splitPath(path);
        this.zipScan();
    }

    public ClassFinder102(File[] classpath) {
        this.classpath = classpath;
        this.zipScan();
    }

    public void setClasspath(String path) {
        this.classpath = FileUtils.splitPath(path);
        this.zipScan();
    }

    @Override
    public void setClasspath(File[] classpath) {
        this.classpath = classpath;
        this.zipScan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipScan() {
        if (this.classpath == null || this.classpath.length == 0) {
            this.zips = new boolean[0];
            return;
        }
        this.zips = new boolean[this.classpath.length];
        for (int i = 0; i < this.zips.length; ++i) {
            this.zips[i] = false;
            if (!this.classpath[i].exists() || this.classpath[i].isDirectory()) continue;
            InputStream in = null;
            try {
                in = new FileInputStream(this.classpath[i]);
                int a = in.read();
                int b = in.read();
                int c = in.read();
                int d = in.read();
                if (a != 80 || b != 75 || c != 3 || d != 4) continue;
                this.zips[i] = true;
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    @Override
    public ClassBytes find(String clss) {
        for (int i = 0; i < this.classpath.length; ++i) {
            File f;
            if (this.zips[i] || this.classpath[i].getName().endsWith(".zip") || (f = this.findClassInDirectory(clss, this.classpath[i])) == null || !f.exists()) continue;
            return new ClassBytes102(f, this.classpath[i]);
        }
        return null;
    }

    @Override
    public InputStream getResourceStream(String resource) throws IOException {
        resource = resource.replace('/', File.separatorChar);
        resource = resource.replace('.', File.separatorChar);
        for (int i = 0; i < this.classpath.length; ++i) {
            File f;
            if (!this.classpath[i].isDirectory() || !(f = new File(this.classpath[i], resource)).exists()) continue;
            return new FileInputStream(f);
        }
        throw new FileNotFoundException(resource);
    }

    @Override
    public InputStream getClassAsStream(String clss) throws IOException, ClassNotFoundException {
        return this.find(clss).getStream();
    }

    @Override
    public byte[] getClassAsBytes(String clss) throws IOException, ClassNotFoundException {
        ClassBytes cb = this.find(clss);
        if (cb == null) {
            throw new ClassNotFoundException(clss);
        }
        return cb.getBytes();
    }

    protected File findClassInDirectory(String clss, File dir) {
        String fileName = clss.replace('.', File.separatorChar) + ".class";
        File f = new File(dir, fileName);
        return f.exists() ? f : null;
    }
}

