/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.utils.classfile.AttributeParent;
import weblogic.utils.classfile.BadBytecodesException;
import weblogic.utils.classfile.ClassFile;
import weblogic.utils.classfile.ConstantValue_attribute;
import weblogic.utils.classfile.Exceptions_attribute;
import weblogic.utils.classfile.Generic_attribute;
import weblogic.utils.classfile.LineNumberTable_attribute;
import weblogic.utils.classfile.LocalVariableTable_attribute;
import weblogic.utils.classfile.MalformedClassException;
import weblogic.utils.classfile.SourceFile_attribute;
import weblogic.utils.classfile.Unrecognized_attribute;
import weblogic.utils.classfile.attribute_info;
import weblogic.utils.classfile.cp.CPUtf8;
import weblogic.utils.classfile.cp.ConstantPool;

public class AttributeTable {
    private final ConstantPool cp;
    private final AttributeParent parent;
    private final List<attribute_info> attributes = new ArrayList<attribute_info>();

    public AttributeTable(AttributeParent parent, ClassFile classFile) {
        this.parent = parent;
        this.cp = classFile.getConstantPool();
    }

    public void addAttribute(String name, byte[] data) {
        CPUtf8 realname = this.cp.getUtf8(name);
        this.attributes.add(new Generic_attribute(realname, data));
    }

    public void addAttribute(attribute_info attribute) {
        this.attributes.add(attribute);
    }

    public Iterator<attribute_info> getAttributes() {
        return this.attributes.iterator();
    }

    public attribute_info getAttribute(String name) {
        for (attribute_info attr : this.attributes) {
            if (!attr.getAttributeName().toString().equals(name)) continue;
            return attr;
        }
        return null;
    }

    private attribute_info newInstance(String name) {
        if ("ConstantValue".equals(name)) {
            return new ConstantValue_attribute();
        }
        if ("Exceptions".equals(name)) {
            return new Exceptions_attribute();
        }
        if ("LineNumberTable".equals(name)) {
            return new LineNumberTable_attribute();
        }
        if ("LocalVariableTable".equals(name)) {
            return new LocalVariableTable_attribute();
        }
        if ("GenericData".equals(name)) {
            return new Generic_attribute();
        }
        if ("SourceFile".equals(name)) {
            return new SourceFile_attribute();
        }
        return new Unrecognized_attribute();
    }

    private attribute_info getAttribute(int idx) throws MalformedClassException {
        CPUtf8 attribute_name = this.cp.utf8At(idx);
        attribute_info attr = this.newInstance(attribute_name.getValue());
        attr.setAttributeName(attribute_name);
        attr.setConstantPool(this.cp);
        attr.setParent(this.parent);
        return attr;
    }

    public void read(DataInput in) throws IOException, BadBytecodesException {
        try {
            int count = in.readUnsignedShort();
            for (int i = 0; i < count; ++i) {
                int attribute_name_index = in.readUnsignedShort();
                attribute_info attr = this.getAttribute(attribute_name_index);
                attr.read(in);
                this.attributes.add(attr);
            }
        }
        catch (MalformedClassException mce) {
            throw new IOException(String.valueOf(mce));
        }
    }

    public void write(DataOutput out) throws IOException, BadBytecodesException {
        int size = this.attributes.size();
        out.writeShort(size);
        for (int i = 0; i < size; ++i) {
            this.attributes.get(i).write(out);
        }
    }

    public void dump(PrintStream out) throws BadBytecodesException {
        out.println("attributes:");
        int size = this.attributes.size();
        for (int i = 0; i < size; ++i) {
            this.attributes.get(i).dump(out);
        }
    }
}

