/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classfile;

import java.io.IOException;
import java.io.InputStream;
import weblogic.utils.classfile.BadBytecodesException;
import weblogic.utils.classfile.ClassFile;
import weblogic.utils.classfile.ClassFileBean;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.Source;

public class ClassFileLoader {
    private static final boolean DEBUG = false;
    ClassFinder finder;
    ClassFileLoader parent;
    boolean throwClassNotFound;
    private static ClassFileLoader sysLoader;

    public ClassFileLoader(ClassFinder cf) {
        this.finder = cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFileBean loadClass(String orig) throws ClassNotFoundException {
        if (orig == null) {
            if (this.throwClassNotFound) {
                throw new ClassNotFoundException(orig);
            }
            return null;
        }
        String name = orig.replace('.', '/');
        name = name + ".class";
        Source src = this.finder.getSource(name);
        ClassFileBean ret = null;
        if (src == null && this.parent != null) {
            ret = this.parent.loadClass(orig);
            if (ret == null && this.throwClassNotFound) {
                throw new ClassNotFoundException(orig);
            }
            return ret;
        }
        if (src == null) {
            if (this.throwClassNotFound) {
                throw new ClassNotFoundException(orig);
            }
            return null;
        }
        InputStream is = null;
        try {
            is = src.getInputStream();
            ClassFile cf = new ClassFile(is);
            ret = new ClassFileBean(cf);
        }
        catch (BadBytecodesException badBytecodesException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (ret == null && this.throwClassNotFound) {
            throw new ClassNotFoundException(orig);
        }
        return ret;
    }

    public ClassFileLoader getParent() {
        return this.parent;
    }

    public void setParent(ClassFileLoader cf) {
        this.parent = cf;
    }

    public boolean getThrowClassNotFound() {
        return this.throwClassNotFound;
    }

    public void setThrowClassNotFound(boolean b) {
        this.throwClassNotFound = b;
    }

    public static synchronized ClassFileLoader getSystem() {
        if (sysLoader == null) {
            sysLoader = new ClassFileLoader(new ClasspathClassFinder2());
        }
        return sysLoader;
    }
}

