/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import weblogic.utils.classfile.Bytecodes;
import weblogic.utils.classfile.ops.BipushOp;
import weblogic.utils.classfile.ops.BranchOp;
import weblogic.utils.classfile.ops.ConstPoolOp;
import weblogic.utils.classfile.ops.IndexAndConstOp;
import weblogic.utils.classfile.ops.InvokeInterfaceOp;
import weblogic.utils.classfile.ops.LdcOp;
import weblogic.utils.classfile.ops.LocalVarOp;
import weblogic.utils.classfile.ops.LookupswitchOp;
import weblogic.utils.classfile.ops.MultinewarrayOp;
import weblogic.utils.classfile.ops.NewarrayOp;
import weblogic.utils.classfile.ops.SipushOp;
import weblogic.utils.classfile.ops.TableswitchOp;
import weblogic.utils.classfile.ops.WideOp;

public class Op {
    static final boolean debug = false;
    public static final int[] operand_bytes = new int[256];
    public static final int VARIABLE = -1;
    protected int op_code;
    private int pc;
    public static final int AALOAD = 50;
    public static final int AASTORE = 83;
    public static final int ACONST_NULL = 1;
    public static final int ALOAD = 25;
    public static final int ALOAD_0 = 42;
    public static final int ALOAD_1 = 43;
    public static final int ALOAD_2 = 44;
    public static final int ALOAD_3 = 45;
    public static final int ANEWARRAY = 189;
    public static final int ARETURN = 176;
    public static final int ARRAYLENGTH = 190;
    public static final int ASTORE = 58;
    public static final int ASTORE_0 = 75;
    public static final int ASTORE_1 = 76;
    public static final int ASTORE_2 = 77;
    public static final int ASTORE_3 = 78;
    public static final int ATHROW = 191;
    public static final int BALOAD = 51;
    public static final int BASTORE = 84;
    public static final int BIPUSH = 16;
    public static final int CALOAD = 52;
    public static final int CASTORE = 85;
    public static final int CHECKCAST = 192;
    public static final int D2F = 144;
    public static final int D2I = 142;
    public static final int D2L = 143;
    public static final int DADD = 99;
    public static final int DALOAD = 49;
    public static final int DASTORE = 82;
    public static final int DCMPG = 152;
    public static final int DCMPL = 151;
    public static final int DCONST_0 = 14;
    public static final int DCONST_1 = 15;
    public static final int DDIV = 111;
    public static final int DLOAD = 24;
    public static final int DLOAD_0 = 38;
    public static final int DLOAD_1 = 39;
    public static final int DLOAD_2 = 40;
    public static final int DLOAD_3 = 41;
    public static final int DMUL = 107;
    public static final int DNEG = 119;
    public static final int DREM = 115;
    public static final int DRETURN = 175;
    public static final int DSTORE = 57;
    public static final int DSTORE_0 = 71;
    public static final int DSTORE_1 = 72;
    public static final int DSTORE_2 = 73;
    public static final int DSTORE_3 = 74;
    public static final int DSUB = 103;
    public static final int DUP = 89;
    public static final int DUP2 = 92;
    public static final int DUP2_X1 = 93;
    public static final int DUP2_X2 = 94;
    public static final int DUP_X1 = 90;
    public static final int DUP_X2 = 91;
    public static final int F2D = 141;
    public static final int F2I = 139;
    public static final int F2L = 140;
    public static final int FADD = 98;
    public static final int FALOAD = 48;
    public static final int FASTORE = 81;
    public static final int FCMPG = 150;
    public static final int FCMPL = 149;
    public static final int FCONST_0 = 11;
    public static final int FCONST_1 = 12;
    public static final int FCONST_2 = 13;
    public static final int FDIV = 110;
    public static final int FLOAD = 23;
    public static final int FLOAD_0 = 34;
    public static final int FLOAD_1 = 35;
    public static final int FLOAD_2 = 36;
    public static final int FLOAD_3 = 37;
    public static final int FMUL = 106;
    public static final int FNEG = 118;
    public static final int FREM = 114;
    public static final int FRETURN = 174;
    public static final int FSTORE = 56;
    public static final int FSTORE_0 = 67;
    public static final int FSTORE_1 = 68;
    public static final int FSTORE_2 = 69;
    public static final int FSTORE_3 = 70;
    public static final int FSUB = 102;
    public static final int GETFIELD = 180;
    public static final int GETSTATIC = 178;
    public static final int GOTO = 167;
    public static final int GOTO_W = 200;
    public static final int I2B = 145;
    public static final int I2C = 146;
    public static final int I2D = 135;
    public static final int I2F = 134;
    public static final int I2L = 133;
    public static final int I2S = 147;
    public static final int IADD = 96;
    public static final int IALOAD = 46;
    public static final int IAND = 126;
    public static final int IASTORE = 79;
    public static final int ICONST_0 = 3;
    public static final int ICONST_1 = 4;
    public static final int ICONST_2 = 5;
    public static final int ICONST_3 = 6;
    public static final int ICONST_4 = 7;
    public static final int ICONST_5 = 8;
    public static final int ICONST_M1 = 2;
    public static final int IDIV = 108;
    public static final int IF_ACMPEQ = 165;
    public static final int IF_ACMPNE = 166;
    public static final int IF_ICMPEQ = 159;
    public static final int IF_ICMPGE = 162;
    public static final int IF_ICMPGT = 163;
    public static final int IF_ICMPLE = 164;
    public static final int IF_ICMPLT = 161;
    public static final int IF_ICMPNE = 160;
    public static final int IFEQ = 153;
    public static final int IFGE = 156;
    public static final int IFGT = 157;
    public static final int IFLE = 158;
    public static final int IFLT = 155;
    public static final int IFNE = 154;
    public static final int IFNONULL = 199;
    public static final int IFNULL = 198;
    public static final int IINC = 132;
    public static final int ILOAD = 21;
    public static final int ILOAD_0 = 26;
    public static final int ILOAD_1 = 27;
    public static final int ILOAD_2 = 28;
    public static final int ILOAD_3 = 29;
    public static final int IMUL = 104;
    public static final int INEG = 116;
    public static final int INSTANCEOF = 193;
    public static final int INVOKEINTERFACE = 185;
    public static final int INVOKESPECIAL = 183;
    public static final int INVOKESTATIC = 184;
    public static final int INVOKEVIRTUAL = 182;
    public static final int IOR = 128;
    public static final int IREM = 112;
    public static final int IRETURN = 172;
    public static final int ISHL = 120;
    public static final int ISHR = 122;
    public static final int ISTORE = 54;
    public static final int ISTORE_0 = 59;
    public static final int ISTORE_1 = 60;
    public static final int ISTORE_2 = 61;
    public static final int ISTORE_3 = 62;
    public static final int ISUB = 100;
    public static final int IUSHR = 124;
    public static final int IXOR = 130;
    public static final int JSR = 168;
    public static final int JSR_W = 201;
    public static final int L2D = 138;
    public static final int L2F = 137;
    public static final int L2I = 136;
    public static final int LADD = 97;
    public static final int LALOAD = 47;
    public static final int LAND = 127;
    public static final int LASTORE = 80;
    public static final int LCMP = 148;
    public static final int LCONST_0 = 9;
    public static final int LCONST_1 = 10;
    public static final int LDC = 18;
    public static final int LDC2_W = 20;
    public static final int LDC_W = 19;
    public static final int LDIV = 109;
    public static final int LLOAD = 22;
    public static final int LLOAD_0 = 30;
    public static final int LLOAD_1 = 31;
    public static final int LLOAD_2 = 32;
    public static final int LLOAD_3 = 33;
    public static final int LMUL = 105;
    public static final int LNEG = 117;
    public static final int LOOKUPSWITCH = 171;
    public static final int LOR = 129;
    public static final int LREM = 113;
    public static final int LRETURN = 173;
    public static final int LSHL = 121;
    public static final int LSHR = 123;
    public static final int LSTORE = 55;
    public static final int LSTORE_0 = 63;
    public static final int LSTORE_1 = 64;
    public static final int LSTORE_2 = 65;
    public static final int LSTORE_3 = 66;
    public static final int LSUB = 101;
    public static final int LUSHR = 125;
    public static final int LXOR = 131;
    public static final int MONITORENTER = 194;
    public static final int MONITOREXIT = 195;
    public static final int MULTIANEWARRAY = 197;
    public static final int NEW = 187;
    public static final int NEWARRAY = 188;
    public static final int NOP = 0;
    public static final int POP = 87;
    public static final int POP2 = 88;
    public static final int PUTFIELD = 181;
    public static final int PUTSTATIC = 179;
    public static final int RET = 169;
    public static final int RETURN = 177;
    public static final int SALOAD = 53;
    public static final int SASTORE = 86;
    public static final int SIPUSH = 17;
    public static final int SWAP = 95;
    public static final int TABLESWITCH = 170;
    public static final int WIDE = 196;
    public static final int XXXUNUSEDXXX = 186;

    public Op(int op_code) {
        this.op_code = op_code;
    }

    void setPC(int pc) {
        this.pc = pc;
    }

    int getPC() {
        return this.pc;
    }

    public void read(DataInput in) throws IOException {
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.op_code);
    }

    public void dump(PrintStream out) {
        out.println(this.toString());
    }

    public String toString() {
        return ByteCodeNames.names[this.op_code];
    }

    public int length() {
        return 1 + operand_bytes[this.op_code];
    }

    public static Op getOp(DataInput in, Bytecodes code, int pc) throws IOException {
        Op op;
        int op_code = in.readUnsignedByte();
        switch (op_code) {
            case 16: {
                op = new BipushOp(op_code);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: 
            case 200: 
            case 201: {
                op = new BranchOp(op_code);
                break;
            }
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                op = new ConstPoolOp(op_code, code.constant_pool);
                break;
            }
            case 18: 
            case 19: {
                op = new LdcOp(op_code, code.constant_pool);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                op = new LocalVarOp(op_code);
                break;
            }
            case 132: {
                op = new IndexAndConstOp(op_code);
                break;
            }
            case 185: {
                op = new InvokeInterfaceOp(op_code, code.constant_pool);
                break;
            }
            case 171: {
                op = new LookupswitchOp(op_code, pc);
                break;
            }
            case 197: {
                op = new MultinewarrayOp(op_code, code.constant_pool);
                break;
            }
            case 188: {
                op = new NewarrayOp(op_code);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 186: 
            case 190: 
            case 191: 
            case 194: 
            case 195: {
                op = new Op(op_code);
                break;
            }
            case 17: {
                op = new SipushOp(op_code);
                break;
            }
            case 170: {
                op = new TableswitchOp(op_code, pc);
                break;
            }
            case 196: {
                op = new WideOp(op_code);
                break;
            }
            default: {
                throw new IOException("Unrecognized op_code: " + Integer.toHexString(op_code));
            }
        }
        ((Op)op).read(in);
        return op;
    }

    static {
        Op.operand_bytes[50] = 0;
        Op.operand_bytes[83] = 0;
        Op.operand_bytes[1] = 0;
        Op.operand_bytes[25] = 1;
        Op.operand_bytes[42] = 0;
        Op.operand_bytes[43] = 0;
        Op.operand_bytes[44] = 0;
        Op.operand_bytes[45] = 0;
        Op.operand_bytes[189] = 2;
        Op.operand_bytes[176] = 0;
        Op.operand_bytes[190] = 0;
        Op.operand_bytes[58] = 1;
        Op.operand_bytes[75] = 0;
        Op.operand_bytes[76] = 0;
        Op.operand_bytes[77] = 0;
        Op.operand_bytes[78] = 0;
        Op.operand_bytes[191] = 0;
        Op.operand_bytes[51] = 0;
        Op.operand_bytes[84] = 0;
        Op.operand_bytes[16] = 1;
        Op.operand_bytes[52] = 0;
        Op.operand_bytes[85] = 0;
        Op.operand_bytes[192] = 2;
        Op.operand_bytes[144] = 0;
        Op.operand_bytes[142] = 0;
        Op.operand_bytes[143] = 0;
        Op.operand_bytes[99] = 0;
        Op.operand_bytes[49] = 0;
        Op.operand_bytes[82] = 0;
        Op.operand_bytes[152] = 0;
        Op.operand_bytes[151] = 0;
        Op.operand_bytes[14] = 0;
        Op.operand_bytes[15] = 0;
        Op.operand_bytes[111] = 0;
        Op.operand_bytes[24] = 1;
        Op.operand_bytes[38] = 0;
        Op.operand_bytes[39] = 0;
        Op.operand_bytes[40] = 0;
        Op.operand_bytes[41] = 0;
        Op.operand_bytes[107] = 0;
        Op.operand_bytes[119] = 0;
        Op.operand_bytes[115] = 0;
        Op.operand_bytes[175] = 0;
        Op.operand_bytes[57] = 1;
        Op.operand_bytes[71] = 0;
        Op.operand_bytes[72] = 0;
        Op.operand_bytes[73] = 0;
        Op.operand_bytes[74] = 0;
        Op.operand_bytes[103] = 0;
        Op.operand_bytes[92] = 0;
        Op.operand_bytes[93] = 0;
        Op.operand_bytes[94] = 0;
        Op.operand_bytes[89] = 0;
        Op.operand_bytes[90] = 0;
        Op.operand_bytes[91] = 0;
        Op.operand_bytes[141] = 0;
        Op.operand_bytes[139] = 0;
        Op.operand_bytes[140] = 0;
        Op.operand_bytes[98] = 0;
        Op.operand_bytes[48] = 0;
        Op.operand_bytes[81] = 0;
        Op.operand_bytes[150] = 0;
        Op.operand_bytes[149] = 0;
        Op.operand_bytes[11] = 0;
        Op.operand_bytes[12] = 0;
        Op.operand_bytes[13] = 0;
        Op.operand_bytes[110] = 0;
        Op.operand_bytes[23] = 1;
        Op.operand_bytes[34] = 0;
        Op.operand_bytes[35] = 0;
        Op.operand_bytes[36] = 0;
        Op.operand_bytes[37] = 0;
        Op.operand_bytes[106] = 0;
        Op.operand_bytes[118] = 0;
        Op.operand_bytes[114] = 0;
        Op.operand_bytes[174] = 0;
        Op.operand_bytes[56] = 1;
        Op.operand_bytes[67] = 0;
        Op.operand_bytes[68] = 0;
        Op.operand_bytes[69] = 0;
        Op.operand_bytes[70] = 0;
        Op.operand_bytes[102] = 0;
        Op.operand_bytes[180] = 2;
        Op.operand_bytes[178] = 2;
        Op.operand_bytes[167] = 2;
        Op.operand_bytes[200] = 4;
        Op.operand_bytes[145] = 0;
        Op.operand_bytes[146] = 0;
        Op.operand_bytes[135] = 0;
        Op.operand_bytes[134] = 0;
        Op.operand_bytes[133] = 0;
        Op.operand_bytes[147] = 0;
        Op.operand_bytes[96] = 0;
        Op.operand_bytes[46] = 0;
        Op.operand_bytes[126] = 0;
        Op.operand_bytes[79] = 0;
        Op.operand_bytes[3] = 0;
        Op.operand_bytes[4] = 0;
        Op.operand_bytes[5] = 0;
        Op.operand_bytes[6] = 0;
        Op.operand_bytes[7] = 0;
        Op.operand_bytes[8] = 0;
        Op.operand_bytes[2] = 0;
        Op.operand_bytes[108] = 0;
        Op.operand_bytes[153] = 2;
        Op.operand_bytes[156] = 2;
        Op.operand_bytes[157] = 2;
        Op.operand_bytes[158] = 2;
        Op.operand_bytes[155] = 2;
        Op.operand_bytes[154] = 2;
        Op.operand_bytes[199] = 2;
        Op.operand_bytes[198] = 2;
        Op.operand_bytes[165] = 2;
        Op.operand_bytes[166] = 2;
        Op.operand_bytes[159] = 2;
        Op.operand_bytes[162] = 2;
        Op.operand_bytes[163] = 2;
        Op.operand_bytes[164] = 2;
        Op.operand_bytes[161] = 2;
        Op.operand_bytes[160] = 2;
        Op.operand_bytes[132] = 2;
        Op.operand_bytes[21] = 1;
        Op.operand_bytes[26] = 0;
        Op.operand_bytes[27] = 0;
        Op.operand_bytes[28] = 0;
        Op.operand_bytes[29] = 0;
        Op.operand_bytes[104] = 0;
        Op.operand_bytes[116] = 0;
        Op.operand_bytes[193] = 2;
        Op.operand_bytes[185] = 4;
        Op.operand_bytes[183] = 2;
        Op.operand_bytes[184] = 2;
        Op.operand_bytes[182] = 2;
        Op.operand_bytes[128] = 0;
        Op.operand_bytes[112] = 0;
        Op.operand_bytes[172] = 0;
        Op.operand_bytes[120] = 0;
        Op.operand_bytes[122] = 0;
        Op.operand_bytes[54] = 1;
        Op.operand_bytes[59] = 0;
        Op.operand_bytes[60] = 0;
        Op.operand_bytes[61] = 0;
        Op.operand_bytes[62] = 0;
        Op.operand_bytes[100] = 0;
        Op.operand_bytes[124] = 0;
        Op.operand_bytes[130] = 0;
        Op.operand_bytes[168] = 2;
        Op.operand_bytes[201] = 4;
        Op.operand_bytes[138] = 0;
        Op.operand_bytes[137] = 0;
        Op.operand_bytes[136] = 0;
        Op.operand_bytes[97] = 0;
        Op.operand_bytes[47] = 0;
        Op.operand_bytes[127] = 0;
        Op.operand_bytes[80] = 0;
        Op.operand_bytes[148] = 0;
        Op.operand_bytes[9] = 0;
        Op.operand_bytes[10] = 0;
        Op.operand_bytes[20] = 2;
        Op.operand_bytes[18] = 1;
        Op.operand_bytes[19] = 2;
        Op.operand_bytes[109] = 0;
        Op.operand_bytes[22] = 1;
        Op.operand_bytes[30] = 0;
        Op.operand_bytes[31] = 0;
        Op.operand_bytes[32] = 0;
        Op.operand_bytes[33] = 0;
        Op.operand_bytes[105] = 0;
        Op.operand_bytes[117] = 0;
        Op.operand_bytes[171] = -1;
        Op.operand_bytes[129] = 0;
        Op.operand_bytes[113] = 0;
        Op.operand_bytes[173] = 0;
        Op.operand_bytes[121] = 0;
        Op.operand_bytes[123] = 0;
        Op.operand_bytes[55] = 1;
        Op.operand_bytes[63] = 0;
        Op.operand_bytes[64] = 0;
        Op.operand_bytes[65] = 0;
        Op.operand_bytes[66] = 0;
        Op.operand_bytes[101] = 0;
        Op.operand_bytes[125] = 0;
        Op.operand_bytes[131] = 0;
        Op.operand_bytes[194] = 0;
        Op.operand_bytes[195] = 0;
        Op.operand_bytes[197] = 3;
        Op.operand_bytes[188] = 1;
        Op.operand_bytes[187] = 2;
        Op.operand_bytes[0] = 0;
        Op.operand_bytes[88] = 0;
        Op.operand_bytes[87] = 0;
        Op.operand_bytes[181] = 2;
        Op.operand_bytes[179] = 2;
        Op.operand_bytes[177] = 0;
        Op.operand_bytes[169] = 1;
        Op.operand_bytes[53] = 0;
        Op.operand_bytes[86] = 0;
        Op.operand_bytes[17] = 2;
        Op.operand_bytes[95] = 0;
        Op.operand_bytes[170] = -1;
        Op.operand_bytes[196] = -1;
        Op.operand_bytes[186] = 0;
    }

    private static final class ByteCodeNames {
        static final String[] names = new String[256];

        private ByteCodeNames() {
        }

        static {
            ByteCodeNames.names[50] = "AALOAD";
            ByteCodeNames.names[83] = "AASTORE";
            ByteCodeNames.names[1] = "ACONST_NULL";
            ByteCodeNames.names[25] = "ALOAD";
            ByteCodeNames.names[42] = "ALOAD_0";
            ByteCodeNames.names[43] = "ALOAD_1";
            ByteCodeNames.names[44] = "ALOAD_2";
            ByteCodeNames.names[45] = "ALOAD_3";
            ByteCodeNames.names[189] = "ANEWARRAY";
            ByteCodeNames.names[176] = "ARETURN";
            ByteCodeNames.names[190] = "ARRAYLENGTH";
            ByteCodeNames.names[58] = "ASTORE";
            ByteCodeNames.names[75] = "ASTORE_0";
            ByteCodeNames.names[76] = "ASTORE_1";
            ByteCodeNames.names[77] = "ASTORE_2";
            ByteCodeNames.names[78] = "ASTORE_3";
            ByteCodeNames.names[191] = "ATHROW";
            ByteCodeNames.names[51] = "BALOAD";
            ByteCodeNames.names[84] = "BASTORE";
            ByteCodeNames.names[16] = "BIPUSH";
            ByteCodeNames.names[52] = "CALOAD";
            ByteCodeNames.names[85] = "CASTORE";
            ByteCodeNames.names[192] = "CHECKCAST";
            ByteCodeNames.names[144] = "D2F";
            ByteCodeNames.names[142] = "D2I";
            ByteCodeNames.names[143] = "D2L";
            ByteCodeNames.names[99] = "DADD";
            ByteCodeNames.names[49] = "DALOAD";
            ByteCodeNames.names[82] = "DASTORE";
            ByteCodeNames.names[152] = "DCMPG";
            ByteCodeNames.names[151] = "DCMPL";
            ByteCodeNames.names[14] = "DCONST_0";
            ByteCodeNames.names[15] = "DCONST_1";
            ByteCodeNames.names[111] = "DDIV";
            ByteCodeNames.names[24] = "DLOAD";
            ByteCodeNames.names[38] = "DLOAD_0";
            ByteCodeNames.names[39] = "DLOAD_1";
            ByteCodeNames.names[40] = "DLOAD_2";
            ByteCodeNames.names[41] = "DLOAD_3";
            ByteCodeNames.names[107] = "DMUL";
            ByteCodeNames.names[119] = "DNEG";
            ByteCodeNames.names[115] = "DREM";
            ByteCodeNames.names[175] = "DRETURN";
            ByteCodeNames.names[57] = "DSTORE";
            ByteCodeNames.names[71] = "DSTORE_0";
            ByteCodeNames.names[72] = "DSTORE_1";
            ByteCodeNames.names[73] = "DSTORE_2";
            ByteCodeNames.names[74] = "DSTORE_3";
            ByteCodeNames.names[103] = "DSUB";
            ByteCodeNames.names[89] = "DUP";
            ByteCodeNames.names[92] = "DUP2";
            ByteCodeNames.names[93] = "DUP2_X1";
            ByteCodeNames.names[94] = "DUP2_X2";
            ByteCodeNames.names[90] = "DUP_X1";
            ByteCodeNames.names[91] = "DUP_X2";
            ByteCodeNames.names[141] = "F2D";
            ByteCodeNames.names[139] = "F2I";
            ByteCodeNames.names[140] = "F2L";
            ByteCodeNames.names[98] = "FADD";
            ByteCodeNames.names[48] = "FALOAD";
            ByteCodeNames.names[81] = "FASTORE";
            ByteCodeNames.names[150] = "FCMPG";
            ByteCodeNames.names[149] = "FCMPL";
            ByteCodeNames.names[11] = "FCONST_0";
            ByteCodeNames.names[12] = "FCONST_1";
            ByteCodeNames.names[13] = "FCONST_2";
            ByteCodeNames.names[110] = "FDIV";
            ByteCodeNames.names[23] = "FLOAD";
            ByteCodeNames.names[34] = "FLOAD_0";
            ByteCodeNames.names[35] = "FLOAD_1";
            ByteCodeNames.names[36] = "FLOAD_2";
            ByteCodeNames.names[37] = "FLOAD_3";
            ByteCodeNames.names[106] = "FMUL";
            ByteCodeNames.names[118] = "FNEG";
            ByteCodeNames.names[114] = "FREM";
            ByteCodeNames.names[174] = "FRETURN";
            ByteCodeNames.names[56] = "FSTORE";
            ByteCodeNames.names[67] = "FSTORE_0";
            ByteCodeNames.names[68] = "FSTORE_1";
            ByteCodeNames.names[69] = "FSTORE_2";
            ByteCodeNames.names[70] = "FSTORE_3";
            ByteCodeNames.names[102] = "FSUB";
            ByteCodeNames.names[180] = "GETFIELD";
            ByteCodeNames.names[178] = "GETSTATIC";
            ByteCodeNames.names[167] = "GOTO";
            ByteCodeNames.names[200] = "GOTO_W";
            ByteCodeNames.names[145] = "I2B";
            ByteCodeNames.names[146] = "I2C";
            ByteCodeNames.names[135] = "I2D";
            ByteCodeNames.names[134] = "I2F";
            ByteCodeNames.names[133] = "I2L";
            ByteCodeNames.names[147] = "I2S";
            ByteCodeNames.names[96] = "IADD";
            ByteCodeNames.names[46] = "IALOAD";
            ByteCodeNames.names[126] = "IAND";
            ByteCodeNames.names[79] = "IASTORE";
            ByteCodeNames.names[3] = "ICONST_0";
            ByteCodeNames.names[4] = "ICONST_1";
            ByteCodeNames.names[5] = "ICONST_2";
            ByteCodeNames.names[6] = "ICONST_3";
            ByteCodeNames.names[7] = "ICONST_4";
            ByteCodeNames.names[8] = "ICONST_5";
            ByteCodeNames.names[2] = "ICONST_M1";
            ByteCodeNames.names[108] = "IDIV";
            ByteCodeNames.names[165] = "IF_ACMPEQ";
            ByteCodeNames.names[166] = "IF_ACMPNE";
            ByteCodeNames.names[159] = "IF_ICMPEQ";
            ByteCodeNames.names[162] = "IF_ICMPGE";
            ByteCodeNames.names[163] = "IF_ICMPGT";
            ByteCodeNames.names[164] = "IF_ICMPLE";
            ByteCodeNames.names[161] = "IF_ICMPLT";
            ByteCodeNames.names[160] = "IF_ICMPNE";
            ByteCodeNames.names[153] = "IFEQ";
            ByteCodeNames.names[156] = "IFGE";
            ByteCodeNames.names[157] = "IFGT";
            ByteCodeNames.names[158] = "IFLE";
            ByteCodeNames.names[155] = "IFLT";
            ByteCodeNames.names[154] = "IFNE";
            ByteCodeNames.names[199] = "IFNONULL";
            ByteCodeNames.names[198] = "IFNULL";
            ByteCodeNames.names[132] = "IINC";
            ByteCodeNames.names[21] = "ILOAD";
            ByteCodeNames.names[26] = "ILOAD_0";
            ByteCodeNames.names[27] = "ILOAD_1";
            ByteCodeNames.names[28] = "ILOAD_2";
            ByteCodeNames.names[29] = "ILOAD_3";
            ByteCodeNames.names[104] = "IMUL";
            ByteCodeNames.names[116] = "INEG";
            ByteCodeNames.names[193] = "INSTANCEOF";
            ByteCodeNames.names[185] = "INVOKEINTERFACE";
            ByteCodeNames.names[183] = "INVOKESPECIAL";
            ByteCodeNames.names[184] = "INVOKESTATIC";
            ByteCodeNames.names[182] = "INVOKEVIRTUAL";
            ByteCodeNames.names[128] = "IOR";
            ByteCodeNames.names[112] = "IREM";
            ByteCodeNames.names[172] = "IRETURN";
            ByteCodeNames.names[120] = "ISHL";
            ByteCodeNames.names[122] = "ISHR";
            ByteCodeNames.names[54] = "ISTORE";
            ByteCodeNames.names[59] = "ISTORE_0";
            ByteCodeNames.names[60] = "ISTORE_1";
            ByteCodeNames.names[61] = "ISTORE_2";
            ByteCodeNames.names[62] = "ISTORE_3";
            ByteCodeNames.names[100] = "ISUB";
            ByteCodeNames.names[124] = "IUSHR";
            ByteCodeNames.names[130] = "IXOR";
            ByteCodeNames.names[168] = "JSR";
            ByteCodeNames.names[201] = "JSR_W";
            ByteCodeNames.names[138] = "L2D";
            ByteCodeNames.names[137] = "L2F";
            ByteCodeNames.names[136] = "L2I";
            ByteCodeNames.names[97] = "LADD";
            ByteCodeNames.names[47] = "LALOAD";
            ByteCodeNames.names[127] = "LAND";
            ByteCodeNames.names[80] = "LASTORE";
            ByteCodeNames.names[148] = "LCMP";
            ByteCodeNames.names[9] = "LCONST_0";
            ByteCodeNames.names[10] = "LCONST_1";
            ByteCodeNames.names[18] = "LDC";
            ByteCodeNames.names[20] = "LDC2_W";
            ByteCodeNames.names[19] = "LDC_W";
            ByteCodeNames.names[109] = "LDIV";
            ByteCodeNames.names[22] = "LLOAD";
            ByteCodeNames.names[30] = "LLOAD_0";
            ByteCodeNames.names[31] = "LLOAD_1";
            ByteCodeNames.names[32] = "LLOAD_2";
            ByteCodeNames.names[33] = "LLOAD_3";
            ByteCodeNames.names[105] = "LMUL";
            ByteCodeNames.names[117] = "LNEG";
            ByteCodeNames.names[171] = "LOOKUPSWITCH";
            ByteCodeNames.names[129] = "LOR";
            ByteCodeNames.names[113] = "LREM";
            ByteCodeNames.names[173] = "LRETURN";
            ByteCodeNames.names[121] = "LSHL";
            ByteCodeNames.names[123] = "LSHR";
            ByteCodeNames.names[55] = "LSTORE";
            ByteCodeNames.names[63] = "LSTORE_0";
            ByteCodeNames.names[64] = "LSTORE_1";
            ByteCodeNames.names[65] = "LSTORE_2";
            ByteCodeNames.names[66] = "LSTORE_3";
            ByteCodeNames.names[101] = "LSUB";
            ByteCodeNames.names[125] = "LUSHR";
            ByteCodeNames.names[131] = "LXOR";
            ByteCodeNames.names[194] = "MONITORENTER";
            ByteCodeNames.names[195] = "MONITOREXIT";
            ByteCodeNames.names[197] = "MULTIANEWARRAY";
            ByteCodeNames.names[187] = "NEW";
            ByteCodeNames.names[188] = "NEWARRAY";
            ByteCodeNames.names[0] = "NOP";
            ByteCodeNames.names[87] = "POP";
            ByteCodeNames.names[88] = "POP2";
            ByteCodeNames.names[181] = "PUTFIELD";
            ByteCodeNames.names[179] = "PUTSTATIC";
            ByteCodeNames.names[169] = "RET";
            ByteCodeNames.names[177] = "RETURN";
            ByteCodeNames.names[53] = "SALOAD";
            ByteCodeNames.names[86] = "SASTORE";
            ByteCodeNames.names[17] = "SIPUSH";
            ByteCodeNames.names[95] = "SWAP";
            ByteCodeNames.names[170] = "TABLESWITCH";
            ByteCodeNames.names[196] = "WIDE";
            ByteCodeNames.names[186] = "XXXUNUSEDXXX";
        }
    }
}

