/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classfile.expr;

import java.util.LinkedList;
import weblogic.utils.classfile.Bytecodes;
import weblogic.utils.classfile.CodeAttribute;
import weblogic.utils.classfile.expr.Statement;

public class CompoundStatement
implements Statement {
    private LinkedList statements = new LinkedList();

    public void add(Statement statement) {
        this.statements.add(statement);
    }

    @Override
    public void code(CodeAttribute ca, Bytecodes code) {
        for (Statement s : this.statements) {
            s.code(ca, code);
        }
    }

    void codeAllButLast(CodeAttribute ca, Bytecodes code) {
        int size = this.statements.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size - 1; ++i) {
            Statement s = (Statement)this.statements.get(i);
            s.code(ca, code);
        }
        Statement s = (Statement)this.statements.get(size - 1);
        if (s instanceof CompoundStatement) {
            ((CompoundStatement)s).codeAllButLast(ca, code);
        }
    }

    Statement getLastStatement() {
        if (this.statements.size() > 0) {
            Statement s = (Statement)this.statements.get(this.statements.size() - 1);
            if (s instanceof CompoundStatement) {
                return ((CompoundStatement)s).getLastStatement();
            }
            return s;
        }
        return null;
    }

    @Override
    public int getMaxStack() {
        int maxStack = 0;
        for (Statement s : this.statements) {
            if (s.getMaxStack() <= maxStack) continue;
            maxStack = s.getMaxStack();
        }
        return maxStack;
    }
}

