/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.MultiClassFinder;

public class AugmentableClassLoaderManager {
    private static final Map classLoaderCache = Collections.synchronizedMap(new WeakHashMap(11));

    public static GenericClassLoader getAugmentableSystemClassLoader() {
        return AugmentableSingletonMaker.singleton;
    }

    public static final GenericClassLoader getAugmentableClassLoader(ClassLoader cl) {
        if (cl instanceof GenericClassLoader) {
            GenericClassLoader gcl = (GenericClassLoader)cl;
            return gcl;
        }
        if (cl == null || cl == AugmentableClassLoaderManager.class.getClassLoader()) {
            return AugmentableSingletonMaker.singleton;
        }
        WeakReference<GenericClassLoader> ref = (WeakReference<GenericClassLoader>)classLoaderCache.get(cl);
        GenericClassLoader gcl = null;
        if (ref == null || ref.get() == null) {
            gcl = new GenericClassLoader(new MultiClassFinder(), cl);
            ref = new WeakReference<GenericClassLoader>(gcl);
            classLoaderCache.put(cl, ref);
        } else {
            gcl = (GenericClassLoader)ref.get();
        }
        return gcl;
    }

    private static final class AugmentableSingletonMaker {
        static final GenericClassLoader singleton;

        private AugmentableSingletonMaker() {
        }

        static {
            ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
            if (contextCL == null) {
                contextCL = AugmentableClassLoaderManager.class.getClassLoader();
            }
            singleton = new GenericClassLoader(new MultiClassFinder(), contextCL);
            singleton.setAnnotation(Annotation.createNonAppAnnotation("System:Augmentable"));
            classLoaderCache.put(contextCL, new WeakReference<GenericClassLoader>(singleton));
        }
    }
}

