/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClassFinderWalker;
import weblogic.utils.classloaders.PackageIndexedClassFinder;
import weblogic.utils.classloaders.index.PackageIndices;

public abstract class ClassFinderIndex
implements ClassFinderWalker {
    private final List<ClassFinder> finders;
    private final Map<String, PackageIndices> map;
    private int[] unindexable = null;

    protected ClassFinderIndex(List<ClassFinder> finders) {
        this(finders, new HashMap<String, PackageIndices>());
    }

    protected ClassFinderIndex(List<ClassFinder> finders, Map<String, PackageIndices> map) {
        this.finders = finders;
        this.map = map;
    }

    public abstract void update(ClassFinder var1, int var2);

    public void build(Runnable onFinishOptimization) {
        int size = this.finders.size();
        for (int i = 0; i < size; ++i) {
            ClassFinder finder = this.finders.get(i);
            this.update(finder, i);
        }
        if (onFinishOptimization != null) {
            onFinishOptimization.run();
        }
    }

    @Override
    public Iterator<ClassFinder> iterator(String packageName) {
        return new Iterator<ClassFinder>(){
            List<ClassFinder> list;
            private final int count;
            private int currentIndex;
            {
                this.list = ClassFinderIndex.this.getList();
                this.count = this.list.size();
                this.currentIndex = -1;
            }

            @Override
            public boolean hasNext() {
                return this.currentIndex + 1 < this.count;
            }

            @Override
            public ClassFinder next() {
                ++this.currentIndex;
                if (this.currentIndex < this.count) {
                    return this.list.get(this.currentIndex);
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public Map<String, PackageIndices> getMap() {
        return this.map;
    }

    public int[] getUnindexable() {
        return this.unindexable;
    }

    protected void index(ClassFinder finder, int codeSourceIndex) {
        Map<String, PackageIndices> index = this.getMap();
        if (finder instanceof PackageIndexedClassFinder) {
            Collection<String> packs = ((PackageIndexedClassFinder)finder).getPackageNames();
            if (packs != null) {
                for (String packageName : packs) {
                    PackageIndices created;
                    PackageIndices indices = index.get(packageName);
                    if (indices == null && (indices = this.putIfAbsent(index, packageName, created = this.createPackageIndices())) == null) {
                        indices = created;
                    }
                    indices.append(codeSourceIndex);
                }
            } else {
                this.addUnindexable(codeSourceIndex);
            }
        } else {
            this.addUnindexable(codeSourceIndex);
        }
    }

    protected PackageIndices createPackageIndices() {
        return new PackageIndices();
    }

    protected PackageIndices putIfAbsent(Map<String, PackageIndices> index, String packageName, PackageIndices indices) {
        return index.put(packageName, indices);
    }

    protected void addUnindexable(int codeSourceIndex) {
        if (this.unindexable == null) {
            this.unindexable = new int[1];
            this.unindexable[0] = codeSourceIndex;
        } else {
            int[] copy = new int[this.unindexable.length + 1];
            System.arraycopy(this.unindexable, 0, copy, 0, this.unindexable.length);
            copy[this.unindexable.length] = codeSourceIndex;
            this.unindexable = copy;
        }
    }

    public boolean canPersist() {
        return false;
    }

    protected List<ClassFinder> getList() {
        return this.finders;
    }
}

