/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.ClassLoadersLogger;
import weblogic.utils.classloaders.debug.ClassLoaderDebugger;

public interface ClassPreProcessor {
    public static final String CLASSNAME_PROPERTY = "weblogic.classloader.preprocessor";
    public static final String SEPARATOR = ",";

    public void initialize(Hashtable var1);

    public byte[] preProcess(String var1, byte[] var2);

    public static class ClassPreProcessorSupport {
        private final List<ClassPreProcessor> processors = new CopyOnWriteArrayList<ClassPreProcessor>();
        private static final DebugLogger vDebugLogger = DebugLogger.getDebugLogger("DebugClassLoadingVerbose");

        public ClassPreProcessorSupport() {
            this(true);
        }

        public ClassPreProcessorSupport(boolean loadingExternal) {
            if (!loadingExternal) {
                return;
            }
            String arg = System.getProperty(ClassPreProcessor.CLASSNAME_PROPERTY);
            if (arg == null) {
                return;
            }
            String[] classes = StringUtils.splitCompletely(arg, ClassPreProcessor.SEPARATOR);
            if (classes == null) {
                return;
            }
            for (int i = 0; i < classes.length; ++i) {
                String className = classes[i];
                if (className == null) continue;
                this.addClassPreProcessor(className);
                if (!vDebugLogger.isDebugEnabled()) continue;
                ClassLoaderDebugger.verbose(this, "ClassPreProcessorSupport", Boolean.toString(loadingExternal), "Pre-processor " + className + " loaded and initialized");
            }
        }

        public void addClassPreProcessor(String className) {
            try {
                Class<?> clazz = Class.forName(className.trim());
                ClassPreProcessor cpp = (ClassPreProcessor)clazz.newInstance();
                this.addClassPreProcessor(cpp);
            }
            catch (ClassNotFoundException e) {
                ClassLoadersLogger.preProcessorClassNotFound(className, e);
            }
            catch (Throwable t) {
                ClassLoadersLogger.errorInitializingPreProcessorClass(className, t);
            }
        }

        public void addClassPreProcessor(ClassPreProcessor cpp) {
            cpp.initialize(null);
            this.processors.add(cpp);
        }

        public byte[] preProcess(String name, byte[] bytes) {
            for (int i = 0; i < this.processors.size(); ++i) {
                try {
                    bytes = this.processors.get(i).preProcess(name, bytes);
                    continue;
                }
                catch (Throwable t) {
                    String preProcessorDescription = "<error printing preprocessor>";
                    try {
                        preProcessorDescription = this.processors.get(i).toString();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ClassLoadersLogger.errorPreProcessingClass(name, preProcessorDescription, t);
                }
            }
            return bytes;
        }
    }
}

