/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import weblogic.utils.PlatformConstants;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinderInt;
import weblogic.utils.classloaders.JarClassFinder;
import weblogic.utils.classloaders.MultiClassFinder;

public class ClasspathClassFinder2
extends MultiClassFinder
implements ClasspathClassFinderInt {
    private static final String JRE_INSTALL_DIR;

    public ClasspathClassFinder2() {
        this(System.getProperty("java.class.path"));
    }

    public ClasspathClassFinder2(String cpath) {
        this(cpath, new HashSet<String>());
    }

    public ClasspathClassFinder2(String cpath, Set<String> exclude) {
        if (exclude == null) {
            throw new IllegalArgumentException("Null exclude set");
        }
        this.setClasspath(cpath, exclude);
    }

    public final void setClasspath(String cpath) {
        this.setClasspath(cpath, new HashSet<String>());
    }

    protected boolean validatePathElement(String element) {
        return !element.startsWith(JRE_INSTALL_DIR);
    }

    private void setClasspath(String cpath, Set<String> exclude) {
        this.close();
        String[] pathElements = StringUtils.splitCompletely(cpath, File.pathSeparator);
        for (int i = 0; i < pathElements.length; ++i) {
            String s = pathElements[i];
            try {
                File f = new File(s);
                if (!f.exists()) continue;
                s = f.getCanonicalPath();
                f = new File(s);
                if (!this.validatePathElement(s) || exclude.contains(s)) continue;
                exclude.add(s);
                ClassFinder cf = this.getClassFinder(f, exclude);
                this.addFinder(cf);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected ClassFinder getClassFinder(File f, Set<String> exclude) throws IOException {
        return new JarClassFinder(f, exclude);
    }

    @Override
    public final String getNoDupExpandedClassPath() {
        StringBuffer sb = new StringBuffer();
        for (ClassFinder finder : this.getClassFinders()) {
            String mf;
            if (!(finder instanceof JarClassFinder)) continue;
            JarClassFinder jar = (JarClassFinder)finder;
            if (sb.length() > 0) {
                sb.append(PlatformConstants.PATH_SEP);
            }
            sb.append(jar.getDelegate().getClassPath());
            ClassFinder manifestFinder = jar.getManifestFinder();
            if (manifestFinder == null || !(manifestFinder instanceof ClasspathClassFinderInt) || (mf = ((ClasspathClassFinderInt)manifestFinder).getNoDupExpandedClassPath()).equals("")) continue;
            sb.append(PlatformConstants.PATH_SEP);
            sb.append(mf);
        }
        return sb.toString();
    }

    static {
        try {
            String javahome = System.getProperty("java.home");
            if (javahome == null) {
                throw new AssertionError((Object)"java.home is null");
            }
            JRE_INSTALL_DIR = new File(javahome).getCanonicalPath();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static final class ExistingScanningLimits
    extends ClasspathClassFinder2 {
        public ExistingScanningLimits(String path, Set<String> exclude) {
            super(path, exclude);
        }

        @Override
        public ClassFinder[] getClassFindersForAnnotationScan() {
            ClassFinder[] fs = this.getClassFinders();
            ArrayList<ClassFinder> finders = new ArrayList<ClassFinder>();
            for (ClassFinder f : fs) {
                finders.add(((JarClassFinder)f).getDelegate());
            }
            return finders.toArray(new ClassFinder[finders.size()]);
        }
    }

    public static final class NoValidate
    extends ClasspathClassFinder2 {
        public NoValidate(String path) {
            super(path);
        }

        @Override
        protected boolean validatePathElement(String element) {
            return true;
        }
    }
}

