/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import com.oracle.classloader.SymLinkDetectorFilenameFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import weblogic.utils.classloaders.AbstractClassFinder;
import weblogic.utils.classloaders.ClassLoadersLogger;
import weblogic.utils.classloaders.DirectoryIndex;
import weblogic.utils.classloaders.FileSource;
import weblogic.utils.classloaders.Source;
import weblogic.utils.classloaders.debug.ClassLoaderDebugger;
import weblogic.utils.enumerations.FileEnumeration;
import weblogic.utils.io.FilenameEncoder;

public class DirectoryClassFinder
extends AbstractClassFinder {
    protected static final boolean WIN_32 = System.getProperty("os.name", "unknown").toLowerCase().indexOf("windows") >= 0;
    private final boolean enforceCase;
    private final String path;
    private volatile DirectoryIndex dirIndex = null;

    public DirectoryClassFinder(File f) throws IOException {
        this(f, false);
    }

    public DirectoryClassFinder(File f, boolean enforceCase) throws IOException {
        this.path = f.getCanonicalPath();
        this.enforceCase = enforceCase;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public Source getSource(String name) {
        if (WIN_32 && (name.indexOf(File.separator) != -1 || name.toLowerCase().endsWith("::$data"))) {
            return null;
        }
        String fileName = name.replace('/', File.separatorChar);
        try {
            File f = FilenameEncoder.getSafeFile(this.path, fileName);
            if (this.dirIndex != null && !this.dirIndex.contains(fileName)) {
                return null;
            }
            if (!f.exists()) {
                return null;
            }
            if (this.enforceCase && !this.matchCase(f, fileName)) {
                return null;
            }
            return new FileSource(this.path, f);
        }
        catch (FilenameEncoder.UnsafeFilenameException unsafeFilenameException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private boolean matchCase(File f, String fileName) throws IOException {
        if (fileName.length() < 1) {
            return true;
        }
        String canonicalPath = f.getCanonicalPath();
        if (canonicalPath == null) {
            return false;
        }
        if ((fileName = this.trimTrailingSlashes(fileName)).length() < 1) {
            return true;
        }
        fileName = FilenameEncoder.resolveRelativeFilePath(fileName);
        return canonicalPath.endsWith(fileName);
    }

    private String trimTrailingSlashes(String fileName) {
        int last;
        int endIndex;
        for (endIndex = last = fileName.length() - 1; endIndex >= 0 && fileName.charAt(endIndex) == File.separatorChar; --endIndex) {
        }
        if (endIndex == last) {
            return fileName;
        }
        fileName = fileName.substring(0, endIndex + 1);
        return fileName;
    }

    @Override
    public String getClassPath() {
        return this.path;
    }

    public String toString() {
        return super.toString() + " - path: '" + this.path + "'";
    }

    protected FilenameFilter getFilenameFilter() {
        boolean skipFilenameFilter = !ClassLoaderDebugger.checkConsistency();
        SymLinkDetectorFilenameFilter filenameFilter = skipFilenameFilter ? null : new SymLinkDetectorFilenameFilter(new SymLinkDetectorFilenameFilter.Reporter(){

            @Override
            public void symlinkCycleDetected(String suspectedSymlinkPath, String cannonicalPath) {
                ClassLoadersLogger.symlinkCycleDetected(suspectedSymlinkPath, cannonicalPath);
            }
        });
        return filenameFilter;
    }

    @Override
    public Enumeration<Source> entries() {
        try {
            return new FileEnumeration(new File(this.path), this.getFilenameFilter(), true){

                @Override
                public Object nextElement() {
                    return new FileSource(DirectoryClassFinder.this.path, (File)super.nextElement());
                }
            };
        }
        catch (FileNotFoundException fileNotFoundException) {
            return super.entries();
        }
    }

    public synchronized void indexFiles() throws IOException {
        this.dirIndex = new DirectoryIndex(this.path);
    }
}

