/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Map;
import org.jvnet.hk2.annotations.Service;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.collections.ConcurrentWeakHashMap;

@Service
@Singleton
public final class GenericClassLoaderRegistry {
    private static final Object PLACEHOLDER = new Object();
    private final Map<GenericClassLoader, Object> allGenericClassLoaders = new ConcurrentWeakHashMap<GenericClassLoader, Object>();

    public Collection<GenericClassLoader> listGenericClassLoaders() {
        return this.allGenericClassLoaders.keySet();
    }

    void registerGenericClassLoader(GenericClassLoader gcl) {
        this.allGenericClassLoaders.put(gcl, PLACEHOLDER);
    }

    void unregisterGenericClassLoader(GenericClassLoader gcl) {
        this.allGenericClassLoaders.remove(gcl);
    }
}

