/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.io.File;
import weblogic.utils.classloaders.BeaHomeHolder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.FileSource;
import weblogic.utils.classloaders.Source;
import weblogic.utils.classloaders.ZipSource;

public class Home {
    private final String path;

    public Home() {
        String p = System.getProperty("weblogic.home");
        Object version = null;
        if (p == null) {
            int fileIndex;
            String file = this.getFileSource("weblogic.utils.classloaders.Home");
            if (file != null) {
                if (file.endsWith(".jar")) {
                    File f = new File(file).getParentFile().getParentFile().getParentFile();
                    p = f.getPath();
                    p = (p = p.replace('\\', '/')).endsWith("/wlserver") ? p + "/server" : p + "/wlserver/server";
                }
                file = null;
            }
            if (file != null && (fileIndex = (file = file.replace('\\', '/')).lastIndexOf("/wlserver/modules/")) > -1) {
                p = file.substring(0, fileIndex) + "/wlserver/server";
            }
        }
        this.path = p;
    }

    private String getClassPath() {
        return System.getProperty("java.class.path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileSource(String name) {
        try (ClasspathClassFinder2 finder = null;){
            finder = new ClasspathClassFinder2(this.getClassPath());
            Source source = finder.getClassSource(name);
            if (source instanceof FileSource) {
                String string = ((FileSource)source).getFile().toString().replace(File.separatorChar, '/');
                return string;
            }
            if (source instanceof ZipSource) {
                String string = ((ZipSource)source).getFile().getName().replace(File.separatorChar, '/');
                return string;
            }
            String string = null;
            return string;
        }
    }

    private static Home getInstance() {
        Home home = HomeSingleton.SINGLETON;
        if (home.path == null) {
            throw new RuntimeException("error in finding weblogic.Home");
        }
        return home;
    }

    public static String getPath() {
        Home home = Home.getInstance();
        return home.path;
    }

    public static File getFile() {
        return new File(Home.getPath());
    }

    public static String getMiddlewareHomePath() {
        return BeaHomeHolder.getBeaHome();
    }

    public String toString() {
        return Home.getPath();
    }

    public static void main(String[] argv) {
        System.out.println(Home.getPath());
    }

    private static final class HomeSingleton {
        private static final Home SINGLETON = new Home();

        private HomeSingleton() {
        }
    }
}

