/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import weblogic.utils.classloaders.DirectoryClassFinder;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.classloaders.PackageIndexedClassFinder;
import weblogic.utils.enumerations.FileEnumeration;

public class IndexedDirectoryClassFinder
extends DirectoryClassFinder
implements PackageIndexedClassFinder {
    public IndexedDirectoryClassFinder(File f) throws IOException {
        super(f);
    }

    public IndexedDirectoryClassFinder(File f, boolean enforceCase) throws IOException {
        super(f, enforceCase);
    }

    @Override
    public Collection<String> getPackageNames() {
        FilenameFilter filenameFilter = this.getFilenameFilter();
        try {
            File root = new File(this.getPath());
            String absoluteRoot = root.getAbsolutePath();
            FileEnumeration files = new FileEnumeration(root, filenameFilter, true);
            HashSet<String> set = new HashSet<String>();
            while (files.hasMoreElements()) {
                File f = (File)files.nextElement();
                String absolute = f.getAbsolutePath();
                if (!absolute.startsWith(absoluteRoot)) continue;
                set.add(MultiClassFinder.getResourceDirectoryPackageName(this.toRelative(absolute, absoluteRoot)));
            }
            return set;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private String toRelative(String absolute, String absoluteRoot) {
        String relative = absolute.substring(absoluteRoot.length());
        if (WIN_32) {
            return relative.replace(File.separatorChar, '/');
        }
        return relative;
    }
}

