/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import weblogic.utils.classloaders.ClassArchiveFile;
import weblogic.utils.classloaders.JarSource;
import weblogic.utils.classloaders.Source;
import weblogic.utils.jars.JarFileUtils2;

class JarArchiveFile
implements ClassArchiveFile {
    private final JarFile jarFile;

    JarArchiveFile(File file) throws IOException {
        this.jarFile = JarFileUtils2.openJarFile(file);
    }

    @Override
    public String getName() {
        return this.jarFile.getName();
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        return (Iterator)((Object)this.jarFile.entries());
    }

    @Override
    public ZipEntry getEntry(String path) {
        return this.jarFile.getJarEntry(path);
    }

    @Override
    public Source createSource(ZipEntry entry) {
        return new JarSource(this.jarFile, (JarEntry)entry);
    }

    @Override
    public InputStream getInputStream(ZipEntry entry) throws IOException {
        return this.jarFile.getInputStream(entry);
    }

    @Override
    public void close() throws IOException {
        this.jarFile.close();
    }

    @Override
    public ZipFile getZipFile() {
        return this.jarFile;
    }
}

