/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.io.File;
import weblogic.utils.FileUtils;
import weblogic.utils.PlatformConstants;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.io.ExtensionFilter;

public final class LibDirClassFinder
extends ClasspathClassFinder2 {
    public LibDirClassFinder(File root, String classesPath, String libPath) {
        super(LibDirClassFinder.getClassPath(root, classesPath, libPath));
    }

    private static String getClassPath(File root, String classesPath, String libPath) {
        StringBuffer cp = new StringBuffer();
        if (root.exists()) {
            File libRoot;
            File classesRoot = new File(root, classesPath);
            if (classesRoot.exists() && classesRoot.isDirectory()) {
                LibDirClassFinder.appendToPath(classesRoot, cp);
            }
            if ((libRoot = new File(root, libPath)).exists() && libRoot.isDirectory()) {
                File[] jars = FileUtils.find(libRoot, new ExtensionFilter("jar"));
                for (int i = 0; i < jars.length; ++i) {
                    LibDirClassFinder.appendToPath(jars[i], cp);
                }
            }
        }
        return cp.toString();
    }

    private static void appendToPath(File f, StringBuffer cp) {
        if (cp.length() > 0) {
            cp.append(PlatformConstants.PATH_SEP);
        }
        cp.append(f.getPath());
    }
}

