/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.net.URL;
import java.net.URLClassLoader;
import weblogic.utils.Classpath;
import weblogic.utils.PlatformConstants;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;

public class OSGIwlsURLClassLoader
extends URLClassLoader {
    public OSGIwlsURLClassLoader(URL[] urls) {
        super(urls);
    }

    public OSGIwlsURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public String getClassPath() {
        StringBuilder sb = new StringBuilder();
        ClassLoader parent = this.getParent();
        String parentClasspath = parent instanceof GenericClassLoader ? ((GenericClassLoader)parent).getClassPath() : OSGIwlsURLClassLoader.getExpanded();
        if (parentClasspath != null && !parentClasspath.equals("")) {
            if (sb.length() > 0) {
                sb.append(PlatformConstants.PATH_SEP);
            }
            sb.append(parentClasspath);
        }
        return sb.toString();
    }

    private static String getExpanded() {
        try (ClasspathClassFinder2.NoValidate cf = null;){
            cf = new ClasspathClassFinder2.NoValidate(Classpath.get());
            String string = cf.getNoDupExpandedClassPath();
            return string;
        }
    }

    public String toString() {
        ClassLoader parent = this.getParent();
        if (parent != null) {
            return "OSGIwlsURLClassLoader(" + super.toString() + "," + this.getParent().toString() + "," + System.identityHashCode(this) + ")";
        }
        return "OSGIwlsURLClassLoader(" + super.toString() + "," + System.identityHashCode(this) + ")";
    }
}

