/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import weblogic.utils.classloaders.ClassFinderUtils;
import weblogic.utils.classloaders.Source;
import weblogic.utils.io.DataIO;
import weblogic.utils.zip.Handler;

public class ZipSource
implements Source {
    private final ZipFile zf;
    private final ZipEntry ze;
    private boolean isFailureLogged = false;

    public ZipSource(ZipFile zf, ZipEntry ze) {
        this.zf = zf;
        this.ze = ze;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.zf.getInputStream(this.ze);
    }

    @Override
    public URL getURL() {
        String zipFileName = this.zf.getName().replace(File.separatorChar, '/').replaceAll("#", "%23");
        String zipurl = zipFileName + '!' + '/' + this.ze.getName();
        try {
            return new URL("zip", "", zipurl);
        }
        catch (MalformedURLException mue) {
            try {
                return new URL("jar", "", new File(zipurl).toURL().toString());
            }
            catch (MalformedURLException muee) {
                return null;
            }
        }
    }

    @Override
    public URL getCodeSourceURL() {
        try {
            File zip = new File(this.zf.getName());
            return zip.toURL();
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    public void getBytes(byte[] b) throws IOException {
        try {
            InputStream in = this.getInputStream();
            DataIO.readFully(in, b, 0, (int)this.length());
            in.close();
        }
        catch (IOException ioe) {
            if (this.isFailureLogged) {
                throw ioe;
            }
            this.isFailureLogged = true;
            ClassFinderUtils.checkArchive(new File(this.zf.getName()).getCanonicalPath(), ioe);
            throw ioe;
        }
    }

    @Override
    public byte[] getBytes() throws IOException {
        try {
            byte[] buf = new byte[(int)this.length()];
            InputStream in = this.getInputStream();
            DataIO.readFully(in, buf);
            in.close();
            return buf;
        }
        catch (IOException ioe) {
            if (this.isFailureLogged) {
                throw ioe;
            }
            this.isFailureLogged = true;
            ClassFinderUtils.checkArchive(new File(this.zf.getName()).getCanonicalPath(), ioe);
            throw ioe;
        }
    }

    @Override
    public long lastModified() {
        return this.ze.getTime();
    }

    @Override
    public long length() {
        return this.ze.getSize();
    }

    public String toString() {
        if (this.zf != null) {
            return this.zf.getName();
        }
        return "ZIP file " + this.getURL();
    }

    public ZipEntry getEntry() {
        return this.ze;
    }

    public ZipFile getFile() {
        return this.zf;
    }

    static {
        try {
            Handler.init();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

