/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders.debug;

import java.security.SecureClassLoader;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.debug.MessageRecord;
import weblogic.utils.classloaders.debug.MethodInvocationRecord;
import weblogic.utils.classloaders.debug.Record;
import weblogic.utils.classloaders.debug.RecordTrace;
import weblogic.utils.classloaders.debug.SuccessfulInvocationRecord;
import weblogic.utils.classloaders.debug.SupportedClassLoader;
import weblogic.utils.classloaders.debug.Trigger;

public class ClassLoaderDebugger {
    private static final DebugLogger vDebugLogger = DebugLogger.getDebugLogger("DebugClassLoadingVerbose");
    private static final DebugLogger ctDebugLogger = DebugLogger.getDebugLogger("DebugClassLoadingContextualTrace");
    private static final DebugLogger consistencyDebugLogger = DebugLogger.getDebugLogger("DebugClassLoadingConsistencyChecker");
    private static final DebugLogger archiveDebugLogger = DebugLogger.getDebugLogger("DebugClassLoadingArchiveChecker");
    private static RecordTrace recordTrace = new RecordTrace();
    private static Trigger trigger = new Trigger(recordTrace);

    private static boolean doTrace() {
        return ctDebugLogger.isDebugEnabled();
    }

    private static boolean beVerbose() {
        return vDebugLogger.isDebugEnabled();
    }

    public static boolean checkConsistency() {
        return consistencyDebugLogger.isDebugEnabled();
    }

    public static boolean checkArchive() {
        return archiveDebugLogger.isDebugEnabled();
    }

    public static void debug(GenericClassLoader instance, SupportedClassLoader clz, String methodName, String arg) {
        if (!SupportedClassLoader.isSupported(instance.getClass())) {
            return;
        }
        MethodInvocationRecord r = null;
        if (ClassLoaderDebugger.beVerbose()) {
            r = new MethodInvocationRecord(instance, clz, methodName, arg);
            vDebugLogger.debug(r.toString());
        }
        if (ClassLoaderDebugger.doTrace() && !ClassLoaderDebugger.filterRecording(instance.getAnnotation().getAnnotationString())) {
            if (r == null) {
                r = new MethodInvocationRecord(instance, clz, methodName, arg);
            }
            recordTrace.add(r);
        }
    }

    public static void debug(GenericClassLoader instance, SupportedClassLoader clz, String methodName, String arg, Object returnValue) {
        if (!SupportedClassLoader.isSupported(instance.getClass())) {
            return;
        }
        SuccessfulInvocationRecord r = null;
        if (ClassLoaderDebugger.beVerbose()) {
            r = new SuccessfulInvocationRecord(instance, clz, methodName, arg, returnValue);
            vDebugLogger.debug(r.toString());
        }
        if (ClassLoaderDebugger.doTrace() && !ClassLoaderDebugger.filterRecording(instance.getAnnotation().getAnnotationString())) {
            if (r == null) {
                r = new SuccessfulInvocationRecord(instance, clz, methodName, arg, returnValue);
            }
            recordTrace.add(r);
        }
    }

    public static void debug(GenericClassLoader instance, Throwable t) {
        if (!SupportedClassLoader.isSupported(instance.getClass())) {
            return;
        }
        if (ClassLoaderDebugger.beVerbose()) {
            vDebugLogger.debug("Exception " + t.getClass().getName() + " with a message " + t.getMessage());
        }
        if (ClassLoaderDebugger.doTrace()) {
            StringBuilder builder;
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            String invokerClassName = stackTrace[3].getClassName();
            if (!ClassLoaderDebugger.filterTriggering(instance.getAnnotation().getAnnotationString()) && !ClassLoaderDebugger.isClassLoaderClass(invokerClassName) && trigger.checkAndDump(t, builder = new StringBuilder(), stackTrace, 2)) {
                ctDebugLogger.debug(builder.toString());
            }
        }
    }

    public static void debug(GenericClassLoader instance, String resourceName) {
        if (!SupportedClassLoader.isSupported(instance.getClass())) {
            return;
        }
        if (ClassLoaderDebugger.beVerbose()) {
            vDebugLogger.debug("Resource lookup failure, null returned for resource " + resourceName);
        }
        if (ClassLoaderDebugger.doTrace()) {
            StringBuilder builder;
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            String invokerClassName = stackTrace[3].getClassName();
            if (!ClassLoaderDebugger.filterTriggering(instance.getAnnotation().getAnnotationString()) && !ClassLoaderDebugger.isClassLoaderClass(invokerClassName) && trigger.checkAndDump(resourceName, builder = new StringBuilder(), stackTrace, 2)) {
                ctDebugLogger.debug(builder.toString());
            }
        }
    }

    public static void verbose(GenericClassLoader instance, SupportedClassLoader clz, String methodName, String arg, String message, Object ... params) {
        if (!SupportedClassLoader.isSupported(instance.getClass())) {
            return;
        }
        vDebugLogger.debug(new MessageRecord(instance, clz, methodName, arg, message, params).toString());
    }

    public static void verbose(Object instance, String methodName, String arg, String message) {
        StringBuilder builder = ClassLoaderDebugger.createBasicRecord(instance);
        builder.append("." + methodName + "(" + arg + "): " + message);
        vDebugLogger.debug(builder.toString());
    }

    public static void verbose(Object instance, String methodName, String arg, String message, Throwable t) {
        StringBuilder builder = ClassLoaderDebugger.createBasicRecord(instance);
        builder.append("." + methodName + "(" + arg + "): " + message);
        vDebugLogger.debug(builder.toString(), t);
    }

    private static StringBuilder createBasicRecord(Object instance) {
        StringBuilder builder = new StringBuilder();
        Record.fillBasicRecord(builder, instance.getClass().getSimpleName(), instance.hashCode(), System.currentTimeMillis());
        return builder;
    }

    private static boolean filterRecording(String annotation) {
        if (annotation.length() == 0) {
            return false;
        }
        return ClassLoaderDebugger._filter(annotation);
    }

    private static boolean filterTriggering(String annotation) {
        return ClassLoaderDebugger._filter(annotation);
    }

    private static boolean _filter(String annotation) {
        String application = ctDebugLogger.getDebugParameters().get("Application");
        if (application != null && application.length() > 0 && !annotation.startsWith(application)) {
            return true;
        }
        String module = ctDebugLogger.getDebugParameters().get("Module");
        return module != null && module.length() > 0 && !annotation.endsWith(module);
    }

    private static boolean isClassLoaderClass(String className) {
        return SupportedClassLoader.isSupported(className) || className.equals(SecureClassLoader.class.getName()) || className.equals(ClassLoader.class.getName());
    }
}

