/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders.debug;

import weblogic.utils.classloaders.ByteArraySource;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.FileSource;
import weblogic.utils.classloaders.JarSource;
import weblogic.utils.classloaders.Source;
import weblogic.utils.classloaders.URLSource;
import weblogic.utils.classloaders.debug.ClasspathElement;
import weblogic.utils.classloaders.debug.ClasspathElementImpl;

public class ClasspathHelper {
    public static ClasspathElement getClasspathElements(ClassFinder finder) {
        return new ClasspathElementImpl(finder, null);
    }

    public static void printFormattedClasspath(ClassFinder finder, StringBuilder builder) {
        ClasspathHelper.printFormattedClasspath(ClasspathHelper.getClasspathElements(finder), builder, "  ");
    }

    private static void printFormattedClasspath(ClasspathElement root, StringBuilder builder, String indent) {
        ClasspathHelper.printFormattedClasspath(root, builder, indent, 0);
    }

    private static void printFormattedClasspath(ClasspathElement root, StringBuilder builder, String indent, int level) {
        block5: {
            block4: {
                if (root.getPath() == null) break block4;
                for (int index = 0; index < level; ++index) {
                    builder.append(indent);
                }
                builder.append(root.getPath()).append('\n');
                if (root.getChildren() == null) break block5;
                for (ClasspathElement child : root.getChildren()) {
                    ClasspathHelper.printFormattedClasspath(child, builder, indent, level + 1);
                }
                break block5;
            }
            if (root.getChildren() != null) {
                for (ClasspathElement child : root.getChildren()) {
                    ClasspathHelper.printFormattedClasspath(child, builder, indent, level);
                }
            }
        }
    }

    public static String getDeploymentLocation(String className, ClassFinder cf) {
        Source s = cf.getClassSource(className);
        if (s instanceof FileSource) {
            return ((FileSource)s).getCodeBase();
        }
        if (s instanceof JarSource) {
            return ((JarSource)s).getFile().getName();
        }
        if (s instanceof URLSource) {
            return ((URLSource)s).getURL().getFile();
        }
        if (s instanceof ByteArraySource) {
            return null;
        }
        return s.getURL().getFile();
    }
}

