/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders.index;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClassFinderIndex;
import weblogic.utils.classloaders.index.PackageIndices;

public class EagerClassFinderIndex
extends ClassFinderIndex {
    private volatile List<PostFreezeAddition> postFreezeAdditions = new ArrayList<PostFreezeAddition>();

    public EagerClassFinderIndex(List<ClassFinder> finders) {
        super(finders);
    }

    public EagerClassFinderIndex(List<ClassFinder> finders, Map<String, PackageIndices> index) {
        super(finders, index);
    }

    @Override
    public void update(ClassFinder finder, int codeSourceIndex) {
        this.index(finder, codeSourceIndex);
    }

    @Override
    public Iterator<ClassFinder> iterator(String packageName) {
        List<PostFreezeAddition> pFA = this.postFreezeAdditions;
        return pFA.isEmpty() ? new PackageIndexedIterator(packageName) : new PackageIndexedPlusPostFreezeAddition(packageName, pFA);
    }

    @Override
    public boolean canPersist() {
        return true;
    }

    @Override
    public synchronized void handlePostFreezeAddition(int effectiveIndex, ClassFinder finder) {
        ArrayList<PostFreezeAddition> changed = new ArrayList<PostFreezeAddition>(this.postFreezeAdditions);
        ListIterator<PostFreezeAddition> it = changed.listIterator(changed.size());
        boolean isAdded = false;
        while (it.hasPrevious()) {
            PostFreezeAddition prev = (PostFreezeAddition)it.previous();
            if (effectiveIndex < prev.effectiveIndex) continue;
            it.add(new PostFreezeAddition(effectiveIndex, finder));
            isAdded = true;
            break;
        }
        if (!isAdded) {
            changed.add(0, new PostFreezeAddition(effectiveIndex, finder));
        }
        this.postFreezeAdditions = changed;
    }

    private static final class PostFreezeAddition {
        final int effectiveIndex;
        final ClassFinder finder;

        PostFreezeAddition(int effectiveIndex, ClassFinder finder) {
            this.effectiveIndex = effectiveIndex;
            this.finder = finder;
        }
    }

    protected class PackageIndexedPlusPostFreezeAddition
    extends PackageIndexedIterator {
        private final Iterator<PostFreezeAddition> iPostFreeze;
        private PostFreezeAddition nextPostFreeze;

        public PackageIndexedPlusPostFreezeAddition(String packageName, List<PostFreezeAddition> pFA) {
            super(packageName);
            this.iPostFreeze = pFA.iterator();
            this.nextPostFreeze = this.iPostFreeze.next();
        }

        @Override
        public boolean hasNext() {
            if (this.iterationIndex < this.iterationSize) {
                return true;
            }
            return this.nextPostFreeze != null || this.iPostFreeze.hasNext();
        }

        @Override
        public ClassFinder next() {
            if (this.iterationIndex < this.iterationSize) {
                int tmp = this.its[this.iterationIndex++];
                if (this.nextPostFreeze == null && this.iPostFreeze.hasNext()) {
                    this.nextPostFreeze = this.iPostFreeze.next();
                }
                if (this.nextPostFreeze != null && tmp >= this.nextPostFreeze.effectiveIndex) {
                    this.currentIndex = this.nextPostFreeze.effectiveIndex;
                    --this.iterationIndex;
                    ClassFinder finder = this.nextPostFreeze.finder;
                    this.nextPostFreeze = null;
                    return finder;
                }
                this.currentIndex = tmp;
                return (ClassFinder)this.list.get(this.currentIndex);
            }
            if (this.nextPostFreeze == null && this.iPostFreeze.hasNext()) {
                this.nextPostFreeze = this.iPostFreeze.next();
            }
            if (this.nextPostFreeze != null) {
                this.currentIndex = this.nextPostFreeze.effectiveIndex;
                ClassFinder finder = this.nextPostFreeze.finder;
                this.nextPostFreeze = null;
                return finder;
            }
            return null;
        }
    }

    protected class PackageIndexedIterator
    implements Iterator<ClassFinder> {
        private final PackageIndices iteration;
        protected final List<ClassFinder> list;
        protected int currentIndex;
        protected int iterationIndex;
        protected final int iterationSize;
        protected final int[] its;

        public PackageIndexedIterator(String packageName) {
            this.list = EagerClassFinderIndex.this.getList();
            this.currentIndex = -1;
            this.iteration = PackageIndices.merge(EagerClassFinderIndex.this.getMap().get(packageName), EagerClassFinderIndex.this.getUnindexable());
            this.iterationSize = this.iteration.size();
            this.its = this.iteration.rawAccess();
            this.iterationIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.iteration != null && this.iterationIndex < this.iterationSize;
        }

        @Override
        public ClassFinder next() {
            if (this.iterationIndex < this.iterationSize) {
                this.currentIndex = this.its[this.iterationIndex++];
                return this.list.get(this.currentIndex);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public boolean shouldDefineCurrentPackage() {
            if (this.iteration.getPackageDefinedIndex() < 0) {
                this.iteration.setPackageDefinedIndex(this.currentIndex);
                return true;
            }
            return false;
        }
    }
}

