/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class ArrayMap<K, V>
extends AbstractMap<K, V> {
    private static final Object NULL = new Object();
    private static final int[] ALPHA = new int[]{1, 1, 3, 5, 9, 19, 39, 79, 159, 317, 633, 1265, 2531, 5063, 10125, 20251, 40503, 81007, 162013, 324027, 648055, 1296111, 2592223, 5184445, 10368889, 20737779, 41475559, 82951117, 165902235, 331804471, 663608943, 1327217885};
    private Object[] table;
    private int mask;
    private int alpha;
    private int size = 0;
    private int power;
    private int modCount;

    public ArrayMap() {
        this(16);
    }

    public ArrayMap(int size) {
        int pow = 0;
        while (1 << pow < size) {
            ++pow;
        }
        this.setPower(pow);
    }

    private void setPower(int pow) {
        this.power = pow;
        this.table = new Object[1 << this.power + 1];
        this.mask = this.table.length / 2 - 1;
        this.alpha = ALPHA[this.power];
    }

    private int firstBucket(int key) {
        return ((key & this.mask ^ key >> 32 - this.power) & this.mask) * 2;
    }

    private int nextBucket(int bucket) {
        return (bucket / 2 + this.alpha & this.mask) * 2;
    }

    private static boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private int getIndex(Object key) {
        if (key == null) {
            key = NULL;
        }
        int i = this.firstBucket(key.hashCode());
        Object o = this.table[i];
        while (o != null && !ArrayMap.eq(key, o)) {
            i = this.nextBucket(i);
            o = this.table[i];
        }
        if (o == null) {
            return -1;
        }
        return i;
    }

    private Object internalGet(Object key) {
        int i = this.getIndex(key);
        return i == -1 ? null : this.table[i + 1];
    }

    @Override
    public V get(Object key) {
        Object retVal = this.internalGet(key);
        if (retVal == null) {
            return null;
        }
        if (NULL.equals(retVal)) {
            return null;
        }
        return (V)retVal;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getIndex(key) >= 0;
    }

    public K getKey(Object key) {
        Object retVal;
        int i = this.getIndex(key);
        Object object = retVal = i == -1 ? null : this.table[i];
        if (retVal == null) {
            return null;
        }
        if (NULL.equals(retVal)) {
            return null;
        }
        return (K)retVal;
    }

    @Override
    public V put(K key, V value) {
        Object retVal = this.internalPut(key, value);
        if (retVal == null) {
            return null;
        }
        if (NULL.equals(retVal)) {
            return null;
        }
        return (V)retVal;
    }

    private Object internalPut(Object key, Object value) {
        if (key == null) {
            key = NULL;
        }
        if (this.size >= this.table.length / 2 * 3 / 4) {
            Object[] oldTable = this.table;
            this.setPower(this.power + 1);
            this.size = 0;
            for (int i = 0; i < oldTable.length; i += 2) {
                Object o = oldTable[i];
                if (o == null) continue;
                this.internalPut(o, oldTable[i + 1]);
            }
        }
        int i = this.firstBucket(key.hashCode());
        while (true) {
            Object oldKey;
            if ((oldKey = this.table[i]) == null) {
                ++this.size;
                ++this.modCount;
                this.table[i] = key;
                this.table[i + 1] = value;
                return null;
            }
            if (ArrayMap.eq(oldKey, key)) {
                Object oldValue = this.table[i + 1];
                this.table[i + 1] = value;
                return oldValue;
            }
            i = this.nextBucket(i);
        }
    }

    @Override
    public V remove(Object key) {
        Object retVal = this.internalRemove(key);
        if (retVal == null) {
            return null;
        }
        if (NULL.equals(retVal)) {
            return null;
        }
        return (V)retVal;
    }

    private Object internalRemove(Object key) {
        if (key == null) {
            key = NULL;
        }
        int i = this.firstBucket(key.hashCode());
        Object o = this.table[i];
        while (o != null && !ArrayMap.eq(key, o)) {
            i = this.nextBucket(i);
            o = this.table[i];
        }
        if (o == null) {
            return null;
        }
        Object oldValue = this.table[i + 1];
        this.table[i] = null;
        this.table[i + 1] = null;
        --this.size;
        ++this.modCount;
        Object tk;
        while ((tk = this.table[i = this.nextBucket(i)]) != null) {
            Object tv = this.table[i + 1];
            this.table[i] = null;
            this.table[i + 1] = null;
            --this.size;
            this.internalPut(tk, tv);
        }
        return oldValue;
    }

    @Override
    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new ArrayMapIterator<K>(){

                    @Override
                    public K next() {
                        if (this.expectedModCount != ArrayMap.this.modCount) {
                            throw new ConcurrentModificationException();
                        }
                        if (this.hasNext()) {
                            Object result = this.next;
                            this.next = null;
                            if (result == null) {
                                return null;
                            }
                            if (NULL.equals(result)) {
                                return null;
                            }
                            return result;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }

            @Override
            public int size() {
                return ArrayMap.this.size();
            }

            @Override
            public boolean contains(Object k) {
                return ArrayMap.this.containsKey(k);
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new ArrayMapIterator<V>(){

                    @Override
                    public V next() {
                        if (this.expectedModCount != ArrayMap.this.modCount) {
                            throw new ConcurrentModificationException();
                        }
                        if (this.hasNext()) {
                            this.next = null;
                            return ArrayMap.this.table[this.index + 1];
                        }
                        throw new NoSuchElementException();
                    }
                };
            }

            @Override
            public int size() {
                return ArrayMap.this.size();
            }

            @Override
            public boolean contains(Object v) {
                return ArrayMap.this.containsValue(v);
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return ArrayMap.this.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new ArrayMapIterator<Map.Entry<K, V>>(){

                    @Override
                    public Map.Entry<K, V> next() {
                        if (this.expectedModCount != ArrayMap.this.modCount) {
                            throw new ConcurrentModificationException();
                        }
                        if (this.hasNext()) {
                            Map.Entry me = new Map.Entry<K, V>(){
                                private final K key;
                                private final V value;
                                {
                                    this.key = NULL.equals(next) ? null : next;
                                    this.value = ArrayMap.this.table[index + 1];
                                }

                                @Override
                                public K getKey() {
                                    return this.key;
                                }

                                @Override
                                public V getValue() {
                                    return this.value;
                                }

                                @Override
                                public V setValue(V value) {
                                    throw new UnsupportedOperationException();
                                }

                                @Override
                                public boolean equals(Object o) {
                                    if (!(o instanceof Map.Entry)) {
                                        return false;
                                    }
                                    Map.Entry e = (Map.Entry)o;
                                    if (this.key != null ? !this.key.equals(e.getKey()) : e.getKey() != null) {
                                        return false;
                                    }
                                    if (this.value != null) {
                                        return this.value.equals(e.getValue());
                                    }
                                    return e.getValue() == null;
                                }

                                @Override
                                public int hashCode() {
                                    return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
                                }
                            };
                            this.next = null;
                            return me;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }
        };
    }

    private abstract class ArrayMapIterator<E>
    implements Iterator<E> {
        protected final int expectedModCount;
        protected int index;
        protected Object next;

        private ArrayMapIterator() {
            this.expectedModCount = ArrayMap.this.modCount;
            this.index = ArrayMap.this.table.length;
            this.next = null;
        }

        @Override
        public final boolean hasNext() {
            while (this.next == null && this.index > 0) {
                this.index -= 2;
                this.next = ArrayMap.this.table[this.index];
            }
            return this.next != null;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

