/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class ConcurrentPool<T> {
    private final T[] el;
    private volatile long w;
    private volatile long r;
    private volatile int limit;
    private static final AtomicLongFieldUpdater<ConcurrentPool> rPos = AtomicLongFieldUpdater.newUpdater(ConcurrentPool.class, "r");

    public ConcurrentPool(int sz) {
        this.el = new Object[1 << ConcurrentPool.log2(sz)];
        this.limit = this.el.length;
    }

    private static int log2(int n) {
        if (--n < 0 || (n <<= 1) < 0) {
            throw new IllegalArgumentException("pool size must be between 1 and 0x40000000");
        }
        int b = 16;
        int pow = 0;
        do {
            int p;
            if ((p = n >>> b) == 0) continue;
            pow += b;
            n = p;
        } while ((b >>>= 1) != 0);
        return pow;
    }

    public void setLimit(int value) {
        this.limit = value > this.el.length ? this.el.length : (value < 0 ? 0 : value);
    }

    public synchronized boolean offer(T v) {
        return this.offerAlone(v);
    }

    private int indexOf(long p) {
        return (int)p & this.el.length - 1;
    }

    public boolean offerAlone(T v) {
        long wp = this.w;
        if (wp - this.r >= (long)this.limit) {
            return false;
        }
        this.el[this.indexOf((long)wp)] = v;
        this.w = wp + 1L;
        return true;
    }

    public T poll() {
        T v;
        long rp;
        do {
            if ((rp = this.r) == this.w) {
                return null;
            }
            v = this.el[this.indexOf(rp)];
        } while (!rPos.compareAndSet(this, rp, rp + 1L));
        return v;
    }

    public int size() {
        long diff;
        long rp;
        do {
            rp = this.r;
            diff = this.w - rp;
        } while (rp != this.r);
        return (int)diff;
    }

    public synchronized void remove(T v) {
        for (int i = 0; i < this.el.length; ++i) {
            if (this.el[i] != v) continue;
            this.el[i] = null;
        }
    }
}

