/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.enumerations.IteratorEnumerator;

public final class ConcurrentProperties
extends Properties {
    private static final long serialVersionUID = 1433129056809878876L;
    private ConcurrentHashMap map = new ConcurrentHashMap();

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public String getProperty(String key) {
        Object oval = this.get(key);
        String sval = oval instanceof String ? (String)oval : null;
        return sval == null && this.defaults != null ? this.defaults.getProperty(key) : sval;
    }

    @Override
    public Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Object clone() {
        ConcurrentProperties clone = (ConcurrentProperties)super.clone();
        clone.map = (ConcurrentHashMap)this.map.clone();
        return clone;
    }

    @Override
    public Set keySet() {
        return this.map.keySet();
    }

    @Override
    public Enumeration keys() {
        return new IteratorEnumerator(this.keySet().iterator());
    }

    @Override
    public Set entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Collection values() {
        return this.map.values();
    }

    @Override
    public Enumeration elements() {
        return new IteratorEnumerator(this.values().iterator());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConcurrentProperties) {
            return this.map.equals(((ConcurrentProperties)o).map);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

