/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public final class CopyOnWriteArrayList<E>
implements List<E>,
RandomAccess,
Cloneable {
    private volatile transient Object[] array;

    public CopyOnWriteArrayList() {
        this.array = new Object[0];
    }

    public CopyOnWriteArrayList(Collection<E> c) {
        this.array = new Object[c.size()];
        int size = 0;
        for (E element : c) {
            this.array[size++] = element;
        }
    }

    public CopyOnWriteArrayList(E[] toCopyIn) {
        this.array = new Object[toCopyIn.length];
        System.arraycopy(toCopyIn, 0, this.array, 0, toCopyIn.length);
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object elem) {
        Object[] elementData = this.array;
        int len = elementData.length;
        return CopyOnWriteArrayList.indexOf(elem, elementData, len) >= 0;
    }

    @Override
    public int indexOf(Object elem) {
        Object[] elementData = this.array;
        int len = elementData.length;
        return CopyOnWriteArrayList.indexOf(elem, elementData, len);
    }

    private static int indexOf(Object elem, Object[] elementData, int len) {
        if (elem == null) {
            for (int i = 0; i < len; ++i) {
                if (elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (!elem.equals(elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(Object elem, int index) {
        Object[] elementData = this.array;
        int elementCount = elementData.length;
        if (elem == null) {
            for (int i = index; i < elementCount; ++i) {
                if (elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i < elementCount; ++i) {
                if (!elem.equals(elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        Object[] elementData = this.array;
        int len = elementData.length;
        return CopyOnWriteArrayList.lastIndexOf(elem, elementData, len);
    }

    private static int lastIndexOf(Object elem, Object[] elementData, int len) {
        if (elem == null) {
            for (int i = len - 1; i >= 0; --i) {
                if (elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = len - 1; i >= 0; --i) {
                if (!elem.equals(elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object elem, int index) {
        Object[] elementData = this.array;
        if (elem == null) {
            for (int i = index; i >= 0; --i) {
                if (elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i >= 0; --i) {
                if (!elem.equals(elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            Object[] elementData = this.array;
            CopyOnWriteArrayList v = (CopyOnWriteArrayList)super.clone();
            v.array = new Object[elementData.length];
            System.arraycopy(elementData, 0, v.array, 0, elementData.length);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] elementData = this.array;
        Object[] result = new Object[elementData.length];
        System.arraycopy(elementData, 0, result, 0, elementData.length);
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] elementData = this.array;
        if (a.length < elementData.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), elementData.length);
        }
        System.arraycopy(elementData, 0, a, 0, elementData.length);
        if (a.length > elementData.length) {
            a[elementData.length] = null;
        }
        return a;
    }

    @Override
    public E get(int index) {
        Object[] elementData = this.array;
        CopyOnWriteArrayList.rangeCheck(index, elementData.length);
        return (E)elementData[index];
    }

    @Override
    public synchronized E set(int index, E element) {
        boolean same;
        int len = this.array.length;
        CopyOnWriteArrayList.rangeCheck(index, len);
        Object oldValue = this.array[index];
        boolean bl = same = oldValue == element || element != null && element.equals(oldValue);
        if (!same) {
            Object[] newArray = new Object[len];
            System.arraycopy(this.array, 0, newArray, 0, len);
            newArray[index] = element;
            this.array = newArray;
        }
        return (E)oldValue;
    }

    @Override
    public synchronized boolean add(E element) {
        int len = this.array.length;
        Object[] newArray = new Object[len + 1];
        System.arraycopy(this.array, 0, newArray, 0, len);
        newArray[len] = element;
        this.array = newArray;
        return true;
    }

    @Override
    public synchronized void add(int index, E element) {
        int len = this.array.length;
        if (index > len || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
        }
        Object[] newArray = new Object[len + 1];
        System.arraycopy(this.array, 0, newArray, 0, index);
        newArray[index] = element;
        System.arraycopy(this.array, index, newArray, index + 1, len - index);
        this.array = newArray;
    }

    @Override
    public synchronized E remove(int index) {
        int len = this.array.length;
        CopyOnWriteArrayList.rangeCheck(index, len);
        Object oldValue = this.array[index];
        Object[] newArray = new Object[len - 1];
        System.arraycopy(this.array, 0, newArray, 0, index);
        int numMoved = len - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.array, index + 1, newArray, index, numMoved);
        }
        this.array = newArray;
        return (E)oldValue;
    }

    @Override
    public synchronized boolean remove(Object o) {
        int len = this.array.length;
        if (len == 0) {
            return false;
        }
        int newlen = len - 1;
        Object[] newArray = new Object[newlen];
        for (int i = 0; i < newlen; ++i) {
            if (o == this.array[i] || o != null && o.equals(this.array[i])) {
                for (int k = i + 1; k < len; ++k) {
                    newArray[k - 1] = this.array[k];
                }
                this.array = newArray;
                return true;
            }
            newArray[i] = this.array[i];
        }
        if (o == this.array[newlen] || o != null && o.equals(this.array[newlen])) {
            this.array = newArray;
            return true;
        }
        return false;
    }

    private synchronized void removeRange(int fromIndex, int toIndex) {
        int len = this.array.length;
        if (fromIndex < 0 || fromIndex >= len || toIndex > len || toIndex < fromIndex) {
            throw new IndexOutOfBoundsException();
        }
        int numMoved = len - toIndex;
        int newlen = len - (toIndex - fromIndex);
        Object[] newArray = new Object[newlen];
        System.arraycopy(this.array, 0, newArray, 0, fromIndex);
        System.arraycopy(this.array, toIndex, newArray, fromIndex, numMoved);
        this.array = newArray;
    }

    public synchronized boolean addIfAbsent(E element) {
        int len = this.array.length;
        Object[] newArray = new Object[len + 1];
        for (int i = 0; i < len; ++i) {
            if (element == this.array[i] || element != null && element.equals(this.array[i])) {
                return false;
            }
            newArray[i] = this.array[i];
        }
        newArray[len] = element;
        this.array = newArray;
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Object[] elementData = this.array;
        int len = elementData.length;
        for (Object cElem : c) {
            if (CopyOnWriteArrayList.indexOf(cElem, elementData, len) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        Object[] elementData = this.array;
        int len = elementData.length;
        if (len == 0) {
            return false;
        }
        Object[] temp = new Object[len];
        int newlen = 0;
        for (int i = 0; i < len; ++i) {
            Object element = elementData[i];
            if (c.contains(element)) continue;
            temp[newlen++] = element;
        }
        if (newlen == len) {
            return false;
        }
        Object[] newArray = new Object[newlen];
        System.arraycopy(temp, 0, newArray, 0, newlen);
        this.array = newArray;
        return true;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        Object[] elementData = this.array;
        int len = elementData.length;
        if (len == 0) {
            return false;
        }
        Object[] temp = new Object[len];
        int newlen = 0;
        for (int i = 0; i < len; ++i) {
            Object element = elementData[i];
            if (!c.contains(element)) continue;
            temp[newlen++] = element;
        }
        if (newlen == len) {
            return false;
        }
        Object[] newArray = new Object[newlen];
        System.arraycopy(temp, 0, newArray, 0, newlen);
        this.array = newArray;
        return true;
    }

    public synchronized int addAllAbsent(Collection<? extends E> c) {
        int numNew = c.size();
        if (numNew == 0) {
            return 0;
        }
        Object[] elementData = this.array;
        int len = elementData.length;
        Object[] temp = new Object[numNew];
        int added = 0;
        for (E element : c) {
            if (CopyOnWriteArrayList.indexOf(element, elementData, len) >= 0 || CopyOnWriteArrayList.indexOf(element, temp, added) >= 0) continue;
            temp[added++] = element;
        }
        if (added == 0) {
            return 0;
        }
        Object[] newArray = new Object[len + added];
        System.arraycopy(elementData, 0, newArray, 0, len);
        System.arraycopy(temp, 0, newArray, len, added);
        this.array = newArray;
        return added;
    }

    @Override
    public synchronized void clear() {
        this.array = new Object[0];
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        int numNew = c.size();
        if (numNew == 0) {
            return false;
        }
        int len = this.array.length;
        Object[] newArray = new Object[len + numNew];
        System.arraycopy(this.array, 0, newArray, 0, len);
        for (E element : c) {
            newArray[len++] = element;
        }
        this.array = newArray;
        return true;
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends E> c) {
        int len = this.array.length;
        if (index > len || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
        }
        int numNew = c.size();
        if (numNew == 0) {
            return false;
        }
        Object[] newArray = new Object[len + numNew];
        System.arraycopy(this.array, 0, newArray, 0, len);
        int numMoved = len - index;
        if (numMoved > 0) {
            System.arraycopy(this.array, index, newArray, index + numNew, numMoved);
        }
        for (E element : c) {
            newArray[index++] = element;
        }
        this.array = newArray;
        return true;
    }

    private static void rangeCheck(int index, int length) {
        if (index >= length || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + length);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator<E> e = this.iterator();
        buf.append("[");
        int maxIndex = this.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            buf.append(String.valueOf(e.next()));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l2 = (List)o;
        if (this.size() != l2.size()) {
            return false;
        }
        ListIterator<E> e1 = this.listIterator();
        ListIterator e2 = l2.listIterator();
        while (e1.hasNext()) {
            E o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E obj : this) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    public Iterator<E> iterator() {
        return new COWIterator(this.array, 0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new COWIterator(this.array, 0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        Object[] elementData = this.array;
        int len = elementData.length;
        if (index < 0 || index > len) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new COWIterator(this.array, index);
    }

    private static final boolean safeEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        if (!a.getClass().isAssignableFrom(b.getClass())) {
            return false;
        }
        return a.equals(b);
    }

    @Override
    public synchronized List<E> subList(int fromIndex, int toIndex) {
        int len = this.array.length;
        if (fromIndex < 0 || toIndex > len || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        return new COWSubList(this, fromIndex, toIndex);
    }

    private static final class COWSubListIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> i;
        private final int offset;
        private final int size;

        private COWSubListIterator(List<E> l, int index, int offset, int size) {
            this.offset = offset;
            this.size = size;
            this.i = l.listIterator(index + offset);
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() < this.size;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.i.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        @Override
        public E previous() {
            if (this.hasPrevious()) {
                return this.i.previous();
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex() - this.offset;
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex() - this.offset;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E o) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class COWSubList<E>
    extends AbstractList<E> {
        private final COWSubList<E> parent;
        private final CopyOnWriteArrayList<E> l;
        private final int offset;
        private Object[] localArray;
        private int localSize;

        private COWSubList(CopyOnWriteArrayList<E> list, int fromIndex, int toIndex) {
            this(null, list, fromIndex, toIndex);
        }

        private COWSubList(COWSubList<E> paramParent, CopyOnWriteArrayList<E> list, int fromIndex, int toIndex) {
            this.parent = paramParent;
            this.l = list;
            this.offset = fromIndex;
            this.localSize = toIndex - fromIndex;
            this.localArray = this.parent == null ? ((CopyOnWriteArrayList)this.l).array : null;
        }

        private void incrementSize() {
            ++this.localSize;
            if (this.parent != null) {
                super.incrementSize();
            }
        }

        private void decrementSize() {
            --this.localSize;
            if (this.parent != null) {
                super.decrementSize();
            }
        }

        private void decrementSize(int howMany) {
            this.localSize -= howMany;
            if (this.parent != null) {
                super.decrementSize(howMany);
            }
        }

        private void clearSize() {
            int previousSize = this.localSize;
            this.localSize = 0;
            if (this.parent != null) {
                super.decrementSize(previousSize);
            }
        }

        private Object[] getSubExpectedArray() {
            if (this.parent == null) {
                return this.localArray;
            }
            return super.getSubExpectedArray();
        }

        private void setSubExpectedArray(Object[] subExpectedArray) {
            if (this.parent == null) {
                this.localArray = subExpectedArray;
                return;
            }
            super.setSubExpectedArray(subExpectedArray);
        }

        private void checkForComodification() {
            if (((CopyOnWriteArrayList)this.l).array != this.getSubExpectedArray()) {
                throw new ConcurrentModificationException();
            }
        }

        private void rangeCheck(int index) {
            if (index < 0 || index >= this.localSize) {
                throw new IndexOutOfBoundsException("Index: " + index + ",Size: " + this.localSize);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int index, E element) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(index);
                this.checkForComodification();
                E x = this.l.set(index + this.offset, element);
                this.setSubExpectedArray(((CopyOnWriteArrayList)this.l).array);
                return x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int index) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(index);
                this.checkForComodification();
                return this.l.get(index + this.offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return this.localSize;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, E element) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (index < 0 || index > this.localSize) {
                    throw new IndexOutOfBoundsException();
                }
                this.l.add(index + this.offset, element);
                this.setSubExpectedArray(((CopyOnWriteArrayList)this.l).array);
                this.incrementSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (this.localSize <= 0) {
                    return;
                }
                ((CopyOnWriteArrayList)this.l).removeRange(this.offset, this.offset + this.localSize);
                this.setSubExpectedArray(((CopyOnWriteArrayList)this.l).array);
                this.clearSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int index) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(index);
                this.checkForComodification();
                E result = this.l.remove(index + this.offset);
                this.setSubExpectedArray(((CopyOnWriteArrayList)this.l).array);
                this.decrementSize();
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object element) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                for (int lcv = 0; lcv < this.localSize; ++lcv) {
                    int index = lcv + this.offset;
                    if (!CopyOnWriteArrayList.safeEquals(element, this.getSubExpectedArray()[index])) continue;
                    this.remove(lcv);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                boolean retVal = false;
                for (Object killMe : c) {
                    while (this.remove(killMe)) {
                        retVal = true;
                    }
                }
                return retVal;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            LinkedList<E> removeAllList = new LinkedList<E>();
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                for (E localElement : this) {
                    if (c.contains(localElement)) continue;
                    removeAllList.add(localElement);
                }
                if (removeAllList.isEmpty()) {
                    return false;
                }
                this.removeAll(removeAllList);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<E> iterator() {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return new COWSubListIterator(this.l, 0, this.offset, this.localSize);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<E> listIterator(int index) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (index < 0 || index > this.localSize) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.localSize);
                }
                return new COWSubListIterator(this.l, index, this.offset, this.localSize);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (fromIndex < 0 || toIndex > this.localSize) {
                    throw new IndexOutOfBoundsException();
                }
                return new COWSubList<E>(this, this.l, fromIndex + this.offset, toIndex + this.offset);
            }
        }
    }

    private static final class COWIterator<E>
    implements ListIterator<E> {
        private final Object[] array;
        private int cursor;

        private COWIterator(Object[] elementArray, int initialCursor) {
            this.array = elementArray;
            this.cursor = initialCursor;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            try {
                return (E)this.array[this.cursor++];
            }
            catch (IndexOutOfBoundsException ex) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public E previous() {
            try {
                return (E)this.array[--this.cursor];
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E o) {
            throw new UnsupportedOperationException();
        }
    }
}

